/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwadatatable;

import de.riwagis.geotools.data.riwadatatable.RiwaDataTableFeatureSource;
import de.riwagis.geotools.data.riwadatatable.RiwaDataTableFeatureStore;
import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.DbTableImpl;
import de.riwagis.riwadatatable.table.DbTableNameConvention;
import de.riwagis.riwadatatable.table.DefaultTableDefinition;
import de.riwagis.riwadatatable.table.TableDefinition;
import de.riwagis.riwadatatable.table.extension.DbTableExtender;
import de.riwagis.riwadatatable.table.extension.label.DbTableLabelDefUtils;
import de.riwagis.riwadatatable.table.extension.label.DbTableLabelExtender;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTablePresetValuesExtender;
import de.riwagis.riwadatatable.table.geotools.FeatureDbTable;
import de.riwagis.riwadatatable.table.geotools.FeatureDbTableImpl;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfo;
import de.riwagis.util.exception.SystemException;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;

public class RiwaDataTableDataStore
extends ContentDataStore {
    private final List<Name> tableNames = new ArrayList<Name>();
    private DataSource dataSource;
    private DbTableUserInfo userInfo;
    private JDBCConnectionManager connectionManager;
    private final Lock lockDS = new ReentrantLock();
    private final Map<ContentEntry, ContentFeatureSource> mapCacheFeatureSource = new HashMap<ContentEntry, ContentFeatureSource>();
    private boolean initialized = false;
    private boolean lowerCaseWhenOracle = false;
    private Runnable runOnDispose = null;
    private Boolean hasRiwaLabelDef = null;
    private DbTable riwaLabelDbt;
    private volatile NamePatternEscaping namePatternEscaping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasRiwaLabelDef() throws IOException, SystemException {
        try {
            this.lockDS.lock();
            if (this.hasRiwaLabelDef == null) {
                try (Connection cx = this.dataSource.getConnection();){
                    this.hasRiwaLabelDef = DbTableLabelDefUtils.hasRiwaLabelDefTable((Connection)cx);
                }
                catch (SQLException e) {
                    throw new IOException("Error occurred at finding out if table RIWA_LABEL_DEF exists.", e);
                }
                if (this.hasRiwaLabelDef.booleanValue()) {
                    TableDefinition tblDef = DbTableLabelDefUtils.getRiwaLabelDefTableDefinition();
                    this.riwaLabelDbt = new DbTableImpl(tblDef, this.connectionManager, null, null);
                }
            }
            boolean bl = this.hasRiwaLabelDef;
            return bl;
        }
        finally {
            this.lockDS.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Name> createTypeNames() throws IOException {
        try {
            this.lockDS.lock();
            if (!this.initialized) {
                if (this.tableNames.isEmpty()) {
                    ArrayList<NameImpl> typeNames = new ArrayList<NameImpl>();
                    try (Connection cx = this.dataSource.getConnection();){
                        String[] desiredTablesTypes;
                        DatabaseMetaData metaData = cx.getMetaData();
                        HashSet<String> availableTableTypes = new HashSet<String>();
                        try (ResultSet tableTypes = metaData.getTableTypes();){
                            while (tableTypes.next()) {
                                availableTableTypes.add(tableTypes.getString("TABLE_TYPE"));
                            }
                        }
                        HashSet<String> queryTypes = new HashSet<String>();
                        for (String desiredTableType : desiredTablesTypes = new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "SYNONYM"}) {
                            if (!availableTableTypes.contains(desiredTableType)) continue;
                            queryTypes.add(desiredTableType);
                        }
                        String databaseSchema = this.connectionManager.getConnectionInfo().getScheme();
                        try (ResultSet tables = metaData.getTables(null, this.escapeNamePattern(metaData, databaseSchema), "%", queryTypes.toArray(new String[0]));){
                            while (tables.next()) {
                                String tableName = tables.getString("TABLE_NAME");
                                if (this.connectionManager.getConnectionInfo().getDBType() == DBType.Oracle && this.lowerCaseWhenOracle) {
                                    tableName = tableName.toLowerCase();
                                }
                                typeNames.add(new NameImpl(this.namespaceURI, tableName));
                            }
                        }
                    }
                    catch (SQLException e) {
                        throw new IOException(String.format("Error occurred getting table name list: %s (Datasource: '%s')", e.getMessage(), this.dataSource), e);
                    }
                    this.tableNames.addAll(typeNames);
                }
                this.initialized = true;
            }
            List<Name> list = Collections.unmodifiableList(this.tableNames);
            return list;
        }
        finally {
            this.lockDS.unlock();
        }
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        try {
            boolean useLowerCase;
            this.lockDS.lock();
            boolean bl = useLowerCase = this.connectionManager.getConnectionInfo().getDBType() == DBType.Oracle && this.lowerCaseWhenOracle;
            if (this.mapCacheFeatureSource.containsKey(entry)) {
                ContentFeatureSource contentFeatureSource = this.mapCacheFeatureSource.get(entry);
                return contentFeatureSource;
            }
            DefaultTableDefinition tblDef = new DefaultTableDefinition();
            tblDef.setName(entry.getTypeName());
            tblDef.setSeq("##AUTOINCREMENT##");
            tblDef.setDelete(1);
            tblDef.setInsert(1);
            tblDef.setUpdate(1);
            if (useLowerCase) {
                tblDef.setDbTableNameConvention(DbTableNameConvention.LOWERCASE);
            } else {
                tblDef.setDbTableNameConvention(DbTableNameConvention.CASE_SENSITIVE);
            }
            FeatureDbTableImpl dbt = new FeatureDbTableImpl((TableDefinition)tblDef, this.connectionManager, null, this.userInfo);
            if (this.hasRiwaLabelDef()) {
                Collection labelTableNames = DbTableLabelDefUtils.getDistinctListOfLabelTables(null, (DbTable)this.riwaLabelDbt, (String)dbt.getTablename());
                for (String labelTableName : labelTableNames) {
                    DefaultTableDefinition tblDefLabel = new DefaultTableDefinition();
                    tblDefLabel.setName(labelTableName);
                    tblDefLabel.setSeq("##AUTOINCREMENT##");
                    tblDefLabel.setDelete(1);
                    tblDefLabel.setInsert(1);
                    tblDefLabel.setUpdate(1);
                    if (useLowerCase) {
                        tblDefLabel.setDbTableNameConvention(DbTableNameConvention.LOWERCASE);
                    } else {
                        tblDefLabel.setDbTableNameConvention(DbTableNameConvention.CASE_SENSITIVE);
                    }
                    FeatureDbTableImpl dbtLabel = new FeatureDbTableImpl((TableDefinition)tblDefLabel, this.connectionManager, null, this.userInfo);
                    List labelInfos = DbTableLabelDefUtils.getRiwaLabelDefInfos(null, (DbTable)this.riwaLabelDbt, (String)dbt.getTablename(), (String)labelTableName);
                    DbTableLabelExtender labelDefExtender = new DbTableLabelExtender((FeatureDbTable)dbt, (FeatureDbTable)dbtLabel, labelInfos);
                    dbt.addExtender((DbTableExtender)labelDefExtender);
                }
            }
            dbt.setFidWithLeadingTablename(true);
            ((DbTablePresetValuesExtender)dbt.retrieveExtender(DbTablePresetValuesExtender.class)).setOverwrite(true);
            Object featureSource = dbt.getInsertable() && dbt.getUpdateable() && dbt.getDeleteable() ? new RiwaDataTableFeatureStore(entry, (FeatureDbTable)dbt) : new RiwaDataTableFeatureSource(entry, (FeatureDbTable)dbt);
            this.mapCacheFeatureSource.put(entry, (ContentFeatureSource)featureSource);
            Object object = featureSource;
            return object;
        }
        catch (SystemException ex) {
            throw new IOException(ex);
        }
        finally {
            this.lockDS.unlock();
        }
    }

    public void onDisposeAction(Runnable runOnDispose) {
        this.runOnDispose = runOnDispose;
    }

    public void dispose() {
        super.dispose();
        this.mapCacheFeatureSource.clear();
        this.tableNames.clear();
        if (this.dataSource != null && this.dataSource instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)((Object)this.dataSource)));
        }
        if (this.runOnDispose != null) {
            this.runOnDispose.run();
        }
    }

    protected void setDataSource(DataSource dataSource) {
        if (this.initialized) {
            throw new IllegalStateException("DataStore is already initialized");
        }
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setConnectionManager(JDBCConnectionManager connectionManager) {
        if (this.initialized) {
            throw new IllegalStateException("DataStore is already initialized");
        }
        this.connectionManager = connectionManager;
    }

    public JDBCConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected void setUserInfo(DbTableUserInfo userInfo) {
        if (this.initialized) {
            throw new IllegalStateException("DataStore is already initialized");
        }
        this.userInfo = userInfo;
    }

    public DbTableUserInfo getUserInfo() {
        return this.userInfo;
    }

    protected void setDataDictionary(List<Name> tableDefinitions) {
        if (this.initialized) {
            throw new IllegalStateException("DataStore is already initialized");
        }
        this.tableNames.addAll(tableDefinitions);
    }

    public String escapeNamePattern(DatabaseMetaData metaData, String name) throws SQLException {
        if (this.namePatternEscaping == null) {
            this.namePatternEscaping = new NamePatternEscaping(metaData.getSearchStringEscape());
        }
        return this.namePatternEscaping.escape(name);
    }

    public void setLowerCaseWhenOracle(boolean lowerCaseWhenOracle) {
        this.lowerCaseWhenOracle = lowerCaseWhenOracle;
    }

    class NamePatternEscaping {
        private final String escape;
        private final Pattern replacementPattern;
        private final String replacement;

        public NamePatternEscaping(String escape) {
            this.escape = escape == null ? "" : escape;
            String quotedEscape = Pattern.quote(this.escape);
            this.replacementPattern = Pattern.compile("(" + quotedEscape + "|[_%])");
            this.replacement = Matcher.quoteReplacement(this.escape) + "$1";
        }

        public String escape(String name) {
            if (this.needsEscaping(name)) {
                return this.replacementPattern.matcher(name).replaceAll(this.replacement);
            }
            return name;
        }

        private boolean needsEscaping(String name) {
            if (name == null) {
                return false;
            }
            if (this.escape.isEmpty()) {
                return false;
            }
            return name.indexOf(95) != -1 || name.indexOf(37) != -1 || name.contains(this.escape);
        }
    }
}

