/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.geopkg;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.geopkg.GeoPkgDataStoreFactory;
import org.geotools.geopkg.GeoPkgDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoPackageDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger log = LoggerFactory.getLogger(GeoPackageDataStoreFactory.class);
    public static final DataAccessFactory.Param FILE = new DataAccessFactory.Param("file", File.class, "Filename", true, null, Collections.singletonMap("ext", "gpkg"));
    private final GeoPkgDataStoreFactory wrappedFactory = new GeoPkgDataStoreFactory();

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        JDBCDataStore dataStore = this.wrappedFactory.createDataStore(this.mapParameters(params));
        GeoPkgDialect dialect = new GeoPkgDialect(dataStore){

            public void setGeometryValue(Geometry g, int dimension, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
                int clampedDim;
                if (dimension < 2 || dimension > 3) {
                    clampedDim = 2;
                    Coordinate coordinate = g.getCoordinate();
                    if (coordinate.getZ() != 0.0) {
                        ++clampedDim;
                    }
                    if (!Double.isNaN(coordinate.getM())) {
                        ++clampedDim;
                    }
                    log.warn("Reduced WKT Dimension from {} to {}. Don't try this at home kids!", (Object)dimension, (Object)clampedDim);
                } else {
                    clampedDim = dimension;
                }
                super.setGeometryValue(g, clampedDim, srid, binding, ps, column);
            }
        };
        dataStore.setSQLDialect((SQLDialect)dialect);
        return dataStore;
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        return this.wrappedFactory.createNewDataStore(this.mapParameters(params));
    }

    public String getDisplayName() {
        return "GeoPackage";
    }

    public String getDescription() {
        return "GeoPackage (*.gpkg)";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{FILE};
    }

    public boolean canProcess(Map<String, ?> params) {
        return this.wrappedFactory.canProcess(this.mapParameters(params));
    }

    public boolean isAvailable() {
        return this.wrappedFactory.isAvailable();
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return this.wrappedFactory.getImplementationHints();
    }

    private Map<String, ?> mapParameters(Map<String, ?> params) {
        HashMap<String, String> mappedParams = new HashMap<String, String>();
        mappedParams.put(GeoPkgDataStoreFactory.DBTYPE.key, "geopkg");
        mappedParams.put(GeoPkgDataStoreFactory.DATABASE.key, Objects.requireNonNullElse(params.get(GeoPackageDataStoreFactory.FILE.key), ""));
        return mappedParams;
    }
}

