/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.dir.shapefile.indexer;

import de.riwagis.geotools.data.dir.DirShpDataStore;
import de.riwagis.geotools.data.dir.shapefile.indexer.ShapeFileIndexer;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ShapeFileIndexerUI
extends JFrame {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.geotools.i18n.i18n");
    private final JFileChooser dirChooser = new JFileChooser();
    private static final File USER_HOME = new File(System.getProperty("user.home"));
    private JButton butClose;
    private JButton butDir;
    private JButton butIndex;
    private JComboBox cmbIndextype;
    private JLabel lbl1;
    private JLabel lbl2;
    private JLabel lblDir;
    private JLabel lblFile;
    private JLabel lblFilename;
    private JLabel lblIndexdepth;
    private JLabel lblIndextype;
    private JLabel lblTitle;
    private JTextField txtIndexdepth;

    public ShapeFileIndexerUI() {
        this.initComponents();
        this.i18n();
        this.init();
        this.dirChooser.setFileSelectionMode(1);
    }

    public final void init() {
        this.cmbIndextype.addItem("QUADTREE");
        this.cmbIndextype.addItem("R-TREE");
        this.cmbIndextype.setSelectedIndex(0);
        this.txtIndexdepth.setText("15");
    }

    private void i18n() {
        this.setTitle(i18n.get("ShapeFileIndexerUI.title"));
        this.lblTitle.setText(i18n.get("ShapeFileIndexerUI.title"));
        this.butDir.setText(i18n.get("ShapeFileIndexerUI.choose-dir"));
        this.lblDir.setText(USER_HOME.getAbsolutePath());
        this.butIndex.setText(i18n.get("ShapeFileIndexerUI.start-indexing"));
        this.lblFile.setText(i18n.get("ShapeFileIndexerUI.file"));
        this.lblFilename.setText("");
        this.lblIndexdepth.setText(i18n.get("ShapeFileIndexerUI.index-depth"));
        this.lblIndextype.setText(i18n.get("ShapeFileIndexerUI.index-type"));
        this.butClose.setText(i18n.get("ShapeFileIndexerUI.close"));
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.butDir = new JButton();
        this.lbl1 = new JLabel();
        this.lbl2 = new JLabel();
        this.lblDir = new JLabel();
        this.butIndex = new JButton();
        this.lblFile = new JLabel();
        this.lblFilename = new JLabel();
        this.butClose = new JButton();
        this.cmbIndextype = new JComboBox();
        this.lblIndextype = new JLabel();
        this.lblIndexdepth = new JLabel();
        this.txtIndexdepth = new JTextField();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont((float)this.lblTitle.getFont().getSize() + 1.0f));
        this.lblTitle.setText("Shapedateien indizieren");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblTitle, gridBagConstraints);
        this.butDir.setText("Verzeichnis w\u00e4hlen...");
        this.butDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShapeFileIndexerUI.this.butDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.butDir, gridBagConstraints);
        this.lbl1.setText("1.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lbl1, gridBagConstraints);
        this.lbl2.setText("2.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lbl2, gridBagConstraints);
        this.lblDir.setText(".../verzeichnis/...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblDir, gridBagConstraints);
        this.butIndex.setText("Indizierung starten");
        this.butIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShapeFileIndexerUI.this.butIndexActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.butIndex, gridBagConstraints);
        this.lblFile.setHorizontalAlignment(4);
        this.lblFile.setText("Datei:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblFile, gridBagConstraints);
        this.lblFilename.setBackground(new Color(255, 255, 255));
        this.lblFilename.setText("jLabel7");
        this.lblFilename.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblFilename, gridBagConstraints);
        this.butClose.setText("Beenden");
        this.butClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShapeFileIndexerUI.this.butCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.butClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.cmbIndextype, gridBagConstraints);
        this.lblIndextype.setText("Indextyp:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblIndextype, gridBagConstraints);
        this.lblIndexdepth.setText("Indextiefe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblIndexdepth, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.txtIndexdepth, gridBagConstraints);
        this.pack();
    }

    private void butIndexActionPerformed(ActionEvent evt) {
        try {
            File workDir = new File(this.lblDir.getText());
            DirShpDataStore store = new DirShpDataStore(workDir, Charset.forName("ISO-8859-1"));
            final String[] arrTypes = store.getTypeNames();
            final String strDir = workDir.getAbsolutePath();
            final ShapeFileIndexerUI comp = this;
            Thread idxThread = new Thread(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < arrTypes.length; ++i) {
                            ShapeFileIndexerUI.this.lblFilename.setText(arrTypes[i] + ".shp");
                            String strPath = strDir + "\\" + arrTypes[i] + ".shp";
                            ShapeFileIndexer ix = new ShapeFileIndexer();
                            ix.setShapeFileName(strPath);
                            ix.setMax(Integer.parseInt(ShapeFileIndexerUI.this.txtIndexdepth.getText()));
                            if (ShapeFileIndexerUI.this.cmbIndextype.getSelectedItem().toString().equals("QUADTREE")) {
                                ix.setIdxType("QUADTREE");
                            } else {
                                ix.setIdxType("RTREE");
                            }
                            ix.index(true);
                            if (i != arrTypes.length - 1) continue;
                            ShapeFileIndexerUI.this.lblFilename.setText("fertig");
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(comp, i18n.get("common.error") + ": " + e.getMessage());
                    }
                }
            };
            idxThread.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, i18n.get("common.error") + ": " + e.getMessage());
        }
    }

    private void butCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        System.exit(0);
    }

    private void butDirActionPerformed(ActionEvent evt) {
        Window parent = SwingUtilities.windowForComponent(this);
        this.dirChooser.setSelectedFile(new File(this.lblDir.getText()));
        this.dirChooser.showOpenDialog(parent);
        this.lblDir.setText(this.dirChooser.getSelectedFile().getAbsolutePath());
    }

    public static void main(String[] args) {
        try {
            String laf = System.getProperty("swing.defaultlaf");
            if (laf == null) {
                laf = UIManager.getSystemLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(() -> new ShapeFileIndexerUI().setVisible(true));
    }
}

