/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.dir;

import de.riwagis.geotools.data.dir.DirShpDataStore;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;

public class DirShpDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param DIRECTORY = new DataAccessFactory.Param("directory", File.class, "Directory containing shp files", true);
    public static final DataAccessFactory.Param DBFCHARSET = new DataAccessFactory.Param("charset", String.class, "character used to decode strings from the DBF file", false, "UTF-8"){

        public Object lookUp(Map<String, ?> map) throws IOException {
            if (map.containsKey(this.key) && map.get(this.key) instanceof Charset) {
                return ((Charset)map.get(this.key)).toString();
            }
            return super.lookUp(map);
        }
    };

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        if (!this.canProcess(params)) {
            throw new IOException("Invalid parameters for DirectoryDataStore");
        }
        File f = (File)DIRECTORY.lookUp(params);
        String charsetName = ObjectUtils.toString((Object)DBFCHARSET.lookUp(params));
        Charset dbfCharset = !charsetName.trim().isEmpty() ? Charset.forName(charsetName) : StandardCharsets.ISO_8859_1;
        if (dbfCharset == null) {
            dbfCharset = StandardCharsets.ISO_8859_1;
        }
        if (!f.isDirectory()) {
            throw new IOException("Invalid parameter " + DirShpDataStoreFactory.DIRECTORY.key + " : is not a valid directory");
        }
        return new DirShpDataStore(f, dbfCharset);
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        if (!this.canProcess(params)) {
            throw new IOException("Invalid parameters for DirectoryDataStore");
        }
        File f = (File)DIRECTORY.lookUp(params);
        if (f.exists()) {
            throw new IOException("Invalid parameter " + DirShpDataStoreFactory.DIRECTORY.key + " : directory already exists");
        }
        if (!f.isDirectory()) {
            throw new IOException("Invalid parameter " + DirShpDataStoreFactory.DIRECTORY.key + " : is not a valid directory");
        }
        if (!f.createNewFile()) {
            throw new IOException("Invalid parameter " + DirShpDataStoreFactory.DIRECTORY.key + " : cannot create directory");
        }
        String charsetName = ObjectUtils.toString((Object)DBFCHARSET.lookUp(params));
        Charset dbfCharset = !charsetName.trim().isEmpty() ? Charset.forName(charsetName) : StandardCharsets.ISO_8859_1;
        if (dbfCharset == null) {
            dbfCharset = StandardCharsets.ISO_8859_1;
        }
        return new DirShpDataStore(f, dbfCharset);
    }

    public String getDisplayName() {
        return "Shape Directory";
    }

    public String getDescription() {
        return "Propagates to multiple file types representing a directory";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DIRECTORY, DBFCHARSET};
    }

    public boolean canProcess(Map<String, ?> params) {
        try {
            File f = (File)DIRECTORY.lookUp(params);
            return f != null && f.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }
}

