/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.dir;

import de.riwagis.geotools.data.AbstractFileDataStore;
import de.riwagis.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.view.DefaultView;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirShpDataStore
implements DataStore,
LockingManager {
    private static final Logger log = LoggerFactory.getLogger(DirShpDataStore.class);
    private final File dir;
    private final Charset dbfCharset;
    private final Map<String, IndexedShapefileDataStore> dataStores = new HashMap<String, IndexedShapefileDataStore>();

    public SimpleFeatureSource getView(Query query) throws IOException, SchemaException {
        return new DefaultView(this.getFeatureSource(query.getTypeName()), query);
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from Directory " + this.dir);
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        info.setSource(this.dir.toURI());
        try {
            info.setPublisher(new URI(System.getenv("user.name")));
        }
        catch (URISyntaxException e) {
            log.error("Could not set publisher with username", (Throwable)e);
        }
        return info;
    }

    public void dispose() {
        this.dataStores.forEach((k, v) -> v.dispose());
    }

    public DirShpDataStore(File f, Charset _dbfCharset) throws MalformedURLException, IOException {
        File[] children;
        this.dir = f;
        this.dbfCharset = _dbfCharset;
        for (File children1 : children = f.listFiles()) {
            if (!children1.isFile() || !children1.getName().toLowerCase().endsWith(".shp")) continue;
            IndexedShapefileDataStore afds = new IndexedShapefileDataStore(children1.toURI().toURL(), true, true);
            afds.retrieveAndSetEncoding(this.dbfCharset);
            this.dataStores.put(afds.getTypeNames()[0], afds);
        }
    }

    public String[] getTypeNames() throws IOException {
        HashSet<String> l = new HashSet<String>();
        for (AbstractFileDataStore abstractFileDataStore : this.dataStores.values()) {
            String[] strs = abstractFileDataStore.getTypeNames();
            if (strs == null) continue;
            l.addAll(Arrays.asList(strs));
        }
        return l.toArray(new String[l.size()]);
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        AbstractFileDataStore afds = this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getSchema();
        }
        return null;
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        File f = new File(this.dir, featureType.getTypeName() + ".shp");
        IndexedShapefileDataStore shpDS = new IndexedShapefileDataStore(f.toURI().toURL());
        shpDS.setStringCharset(this.dbfCharset);
        shpDS.createSchema(featureType);
        this.dataStores.put(shpDS.getTypeNames()[0], shpDS);
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        AbstractFileDataStore afds = this.dataStores.get(typeName);
        if (afds != null) {
            afds.updateSchema(featureType);
        }
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        AbstractFileDataStore afds = this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureSource();
        }
        return null;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = this.dataStores.get(query.getTypeName());
        if (afds != null) {
            return afds.getFeatureReader(query, transaction);
        }
        return null;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureWriter(filter, transaction);
        }
        return null;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureWriter(transaction);
        }
        return null;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureWriterAppend(transaction);
        }
        return null;
    }

    public LockingManager getLockingManager() {
        return this;
    }

    public boolean exists(String authID) {
        for (AbstractFileDataStore abstractFileDataStore : this.dataStores.values()) {
            if (abstractFileDataStore.getLockingManager() == null || !abstractFileDataStore.getLockingManager().exists(authID)) continue;
            return true;
        }
        return false;
    }

    public boolean release(String authID, Transaction transaction) throws IOException {
        for (AbstractFileDataStore abstractFileDataStore : this.dataStores.values()) {
            if (abstractFileDataStore.getLockingManager() == null || !abstractFileDataStore.getLockingManager().exists(authID)) continue;
            return abstractFileDataStore.getLockingManager().release(authID, transaction);
        }
        return false;
    }

    public boolean refresh(String authID, Transaction transaction) throws IOException {
        for (AbstractFileDataStore abstractFileDataStore : this.dataStores.values()) {
            if (abstractFileDataStore.getLockingManager() == null || !abstractFileDataStore.getLockingManager().exists(authID)) continue;
            return abstractFileDataStore.getLockingManager().refresh(authID, transaction);
        }
        return false;
    }

    public void unLockFeatureID(String typeName, String authID, Transaction transaction, FeatureLock featureLock) throws IOException {
        AbstractFileDataStore afds = this.dataStores.get(typeName);
        if (afds != null && afds.getLockingManager() != null) {
            afds.getLockingManager().unLockFeatureID(typeName, authID, transaction, featureLock);
        }
    }

    public void lockFeatureID(String typeName, String authID, Transaction transaction, FeatureLock featureLock) throws IOException {
        AbstractFileDataStore afds = this.dataStores.get(typeName);
        if (afds != null && afds.getLockingManager() != null) {
            afds.getLockingManager().lockFeatureID(typeName, authID, transaction, featureLock);
        }
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add((Name)new NameImpl(typeName));
        }
        return names;
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    public void removeSchema(String typeName) throws IOException {
        this.removeSchema((Name)new NameImpl(null, typeName));
    }

    public void removeSchema(Name name) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

