/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data;

import de.riwagis.geotools.data.AbstractDataStore;
import de.riwagis.geotools.data.TransactionStateDiff;
import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.Diff;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Deprecated
public abstract class AbstractFeatureSource
implements SimpleFeatureSource {
    protected Set<RenderingHints.Key> hints = Collections.EMPTY_SET;
    protected QueryCapabilities queryCapabilities;

    public AbstractFeatureSource() {
        this.queryCapabilities = new QueryCapabilities();
    }

    public abstract DataStore getDataStore();

    public Name getName() {
        return ((SimpleFeatureType)this.getSchema()).getName();
    }

    public AbstractFeatureSource(Set<RenderingHints.Key> hints) {
        this.hints = Collections.unmodifiableSet(new HashSet<RenderingHints.Key>(hints));
        this.queryCapabilities = new QueryCapabilities(){

            public boolean isUseProvidedFIDSupported() {
                return AbstractFeatureSource.this.hints.contains(Hints.USE_PROVIDED_FID);
            }
        };
    }

    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add(((SimpleFeatureType)AbstractFeatureSource.this.getSchema()).getTypeName());
            }

            public ReferencedEnvelope getBounds() {
                try {
                    return AbstractFeatureSource.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            public CoordinateReferenceSystem getCRS() {
                return ((SimpleFeatureType)AbstractFeatureSource.this.getSchema()).getCoordinateReferenceSystem();
            }

            public String getDescription() {
                return null;
            }

            public Set<String> getKeywords() {
                return this.words;
            }

            public String getName() {
                return ((SimpleFeatureType)AbstractFeatureSource.this.getSchema()).getTypeName();
            }

            public URI getSchema() {
                Name name = ((SimpleFeatureType)AbstractFeatureSource.this.getSchema()).getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            public String getTitle() {
                Name name = ((SimpleFeatureType)AbstractFeatureSource.this.getSchema()).getName();
                return name.getLocalPart();
            }
        };
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.queryCapabilities;
    }

    public Transaction getTransaction() {
        return Transaction.AUTO_COMMIT;
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        SimpleFeatureType schema = (SimpleFeatureType)this.getSchema();
        String typeName = schema.getTypeName();
        if (query.getTypeName() == null) {
            Query defaultQuery = new Query(query);
            defaultQuery.setTypeName(typeName);
        } else if (!typeName.equals(query.getTypeName())) {
            return new EmptyFeatureCollection(schema);
        }
        QueryCapabilities currQueryCapabilities = this.getQueryCapabilities();
        if (!currQueryCapabilities.supportsSorting(query.getSortBy())) {
            throw new DataSourceException("DataStore cannot provide the requested sort order");
        }
        DefaultFeatureResults collection = new DefaultFeatureResults((SimpleFeatureSource)this, query);
        if (((SimpleFeatureType)collection.getSchema()).getGeometryDescriptor() == null) {
            return collection;
        }
        return collection;
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures((Filter)Filter.INCLUDE);
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(this.getSchema() == null ? Query.ALL : new Query(((SimpleFeatureType)this.getSchema()).getTypeName()));
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return new ReferencedEnvelope(new Envelope(), ((SimpleFeatureType)this.getSchema()).getCoordinateReferenceSystem());
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return null;
        }
        return ((AbstractDataStore)dataStore).getBounds(this.namedQuery(query));
    }

    protected Query namedQuery(Query query) {
        String typeName = ((SimpleFeatureType)this.getSchema()).getTypeName();
        if (query.getTypeName() == null || !query.getTypeName().equals(typeName)) {
            return new Query(typeName, query.getFilter(), query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return 0;
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return -1;
        }
        Transaction t = this.getTransaction();
        int nativeCount = ((AbstractDataStore)dataStore).getCount(this.namedQuery(query));
        if (nativeCount == -1) {
            return -1;
        }
        int delta = 0;
        if (t != Transaction.AUTO_COMMIT) {
            Diff diff;
            if (t.getState((Object)dataStore) == null) {
                return nativeCount;
            }
            if (!(t.getState((Object)dataStore) instanceof TransactionStateDiff)) {
                return -1;
            }
            Diff diff2 = diff = ((AbstractDataStore)dataStore).state(t).diff(this.namedQuery(query).getTypeName());
            synchronized (diff2) {
                for (Object feature : diff.getAdded().values()) {
                    if (!query.getFilter().evaluate(feature)) continue;
                    ++delta;
                }
                for (Object feature : diff.getModified().values()) {
                    if (feature != Diff.NULL || !query.getFilter().evaluate(feature)) continue;
                    --delta;
                }
            }
        }
        return nativeCount + delta;
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return this.hints;
    }
}

