/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.swing.JFileChooser;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SaveImageAsSVGPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    File selFile = null;

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        JFileChooser fc = new JFileChooser();
        fc.showSaveDialog(context.getWorkbenchFrame());
        File file = fc.getSelectedFile();
        try {
            File newFile;
            String name = file.getPath();
            name = this.addExtension(name, "svg");
            this.selFile = newFile = new File(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.file.SaveImageAsSVGPlugIn.save-image-in-svg-format");
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        LayerViewPanel lvp = context.getLayerViewPanel();
        RenderingManager rms = lvp.getRenderingManager();
        Iterator<Layerable> i = context.getLayerManager().reverseIterator(Layerable.class, true);
        Dimension lvpSize = lvp.getSize();
        svgGenerator.setSVGCanvasSize(lvpSize);
        svgGenerator.setClip(0, 0, (int)lvpSize.getWidth(), (int)lvpSize.getHeight());
        boolean bolRaster = false;
        while (i.hasNext()) {
            Layerable ly = i.next();
            Renderer myR = rms.getRenderer(ly);
            if (myR instanceof LayerRenderer) {
                LayerRenderer myRnew = (LayerRenderer)myR;
                myRnew.copyTo((Graphics2D)svgGenerator);
                continue;
            }
            bolRaster = true;
        }
        if (bolRaster) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("org.openjump.core.ui.plugin.file.SaveImageAsSVGPlugIn.no-raster-layers"), (String)I18N.get("common.attention"));
        }
        try (FileOutputStream fos = new FileOutputStream(this.selFile, false);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");){
            svgGenerator.stream((Writer)out, true);
            out.close();
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser("error:" + e.getMessage());
        }
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(0));
    }

    private String addExtension(String path, String extension) {
        if (path.toUpperCase().endsWith(extension.toUpperCase())) {
            return path;
        }
        if (path.endsWith(".")) {
            return path + extension;
        }
        return path + "." + extension;
    }
}

