/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.selection.SelectionListener;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import de.riwagis.icons.IconLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.geomutils.GeoUtils;

public class ScaleSelectedItemsTool
extends DragTool {
    private final SelectionListener selectionListener;
    private final ViewportListener viewportListener;
    private String scaleSelectedItems = "Scale Selected Items";
    private String sScaleFactor = "scale factor";
    private final EnableCheckFactory checkFactory;
    private Shape selectionBBoxShape;
    private Geometry originalItemsAsLines = null;
    private Geometry outlineItems = null;
    private Shape outlineItemsShape = null;
    private Geometry originalBBox = null;
    private double xscale = 0.0;
    private double yscale = 0.0;
    private Coordinate mousePos = null;
    private Coordinate preScale = null;
    private Coordinate center = null;
    DecimalFormat df2 = new DecimalFormat("##0.0#");
    boolean startScaling = false;
    double toleranceFactor = 2.0;
    private BasicStroke originalStroke = null;
    boolean somethingChanged = false;
    int style = 1;
    Cursor cursor2 = ScaleSelectedItemsTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_move.svg").getImage());
    Cursor cursor1 = null;
    private final GeometryFactory geometryFactory;

    public ScaleSelectedItemsTool(EnableCheckFactory checkFactory) {
        this.scaleSelectedItems = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.ScaleSelectedItemsTool.Scale-Selected-Items");
        this.sScaleFactor = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.ScaleSelectedItemsTool.scale-factor");
        this.checkFactory = checkFactory;
        this.originalStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
        this.setStroke(this.originalStroke);
        this.style = 1;
        this.allowSnapping();
        this.cursor1 = this.getCursor();
        this.geometryFactory = new GeometryFactory();
        this.selectionListener = () -> this.updateBoundingRectangle();
        this.viewportListener = vPort -> this.updateBoundingRectangle();
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.startScaling) {
            ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
            for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
                transactions.add(this.createTransaction(layerWithSelectedItems));
            }
            EditTransaction.commit(transactions);
        }
    }

    private void updateBoundingRectangle() {
        try {
            this.startScaling = false;
            this.originalBBox = this.createSelectedItemsBoundingBox(this.getPanel().getSelectionManager().getSelectedItems());
            this.outlineItemsShape = this.selectionBBoxShape = this.getPanel().getJava2DConverter().toShape(this.originalBBox);
            this.somethingChanged = true;
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private EditTransaction createTransaction(Layer layer) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    ScaleSelectedItemsTool.this.scale(item);
                }
                return geometryWithSelectedItems;
            }
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
        return transaction;
    }

    private void scale(Geometry geometry) {
        geometry.apply(coordinate -> {
            coordinate.x = this.center.x + this.xscale * (coordinate.x - this.center.x);
            coordinate.y = this.center.y + this.yscale * (coordinate.y - this.center.y);
        });
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_scale.svg");
    }

    @Override
    public String getName() {
        return this.scaleSelectedItems;
    }

    @Override
    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        try {
            this.originalBBox = this.createSelectedItemsBoundingBox(panel.getSelectionManager().getSelectedItems());
            this.outlineItemsShape = this.selectionBBoxShape = this.getPanel().getJava2DConverter().toShape(this.originalBBox);
            this.setStroke(this.originalStroke);
            this.setColor(Color.RED);
            this.style = 1;
            this.somethingChanged = false;
            panel.getViewport().addListener(this.viewportListener);
            panel.getSelectionManager().addSelectionListener(this.selectionListener);
            this.somethingChanged = true;
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            if (!this.checkMouseButton(e)) {
                return;
            }
            this.setStroke(this.originalStroke);
            this.setColor(Color.RED);
            this.style = 1;
            try {
                this.setMousePos(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
            }
            catch (Throwable t) {
                this.getPanel().getContext().handleThrowable(t);
            }
            double tolerance = (double)SnapManager.getToleranceInPixels(JUMPWorkbench.getBlackboard()) / this.getPanel().getViewport().getScale();
            LineString ls = (LineString)this.originalBBox.getBoundary();
            MultiPoint mps = this.geometryFactory.createMultiPoint(ls.getCoordinates());
            Geometry buffergeom = mps.buffer(tolerance * this.toleranceFactor);
            Point mousep = this.geometryFactory.createPoint(this.mousePos);
            if (buffergeom.contains((Geometry)mousep)) {
                try {
                    if (!this.check(this.checkFactory.createAtLeastNFeaturesOrPartsMustBeSelectedCheck(1))) {
                        return;
                    }
                    if (!this.check(this.checkFactory.createSelectedItemsLayersMustBeEditableCheck())) {
                        return;
                    }
                    super.mousePressed(e);
                    this.setSelectedItemsOutlines();
                    this.originalBBox = this.createSelectedItemsBoundingBox(this.getPanel().getSelectionManager().getSelectedItems());
                    LineString lsBBox = (LineString)this.originalBBox.getBoundary();
                    this.outlineItems = this.geometryFactory.createGeometryCollection(new Geometry[]{lsBBox, this.originalItemsAsLines});
                    this.outlineItemsShape = this.getPanel().getJava2DConverter().toShape(this.outlineItems);
                    this.center = this.getFarestPoint(this.originalBBox, this.mousePos);
                    this.startScaling = true;
                    this.somethingChanged = true;
                    this.preScale = new Coordinate(this.mousePos.x > this.center.x ? 1.0 : -1.0, this.mousePos.y > this.center.y ? 1.0 : -1.0);
                }
                catch (Throwable t) {
                    this.getPanel().getContext().handleThrowable(t);
                }
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startScaling) {
            super.mouseDragged(e);
            if (!this.isDragApproved()) {
                return;
            }
            try {
                double dyEnv;
                this.setMousePos(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
                double dxMouse = this.preScale.x * (this.mousePos.x - this.center.x);
                double dyMouse = this.preScale.y * (this.mousePos.y - this.center.y);
                double dxEnv = this.originalBBox.getEnvelopeInternal().getWidth();
                if (dxEnv == 0.0) {
                    dxEnv = 1.0;
                }
                if ((dyEnv = this.originalBBox.getEnvelopeInternal().getHeight()) == 0.0) {
                    dyEnv = 1.0;
                }
                this.xscale = dxMouse / dxEnv;
                this.yscale = dyMouse / dyEnv;
                if (e.isShiftDown()) {
                    this.yscale = this.xscale;
                }
                this.getPanel().getContext().setStatusMessage(this.sScaleFactor + " x: " + this.df2.format(this.xscale) + "  " + this.sScaleFactor + " y: " + this.df2.format(this.yscale));
                Geometry geoms = (Geometry)this.outlineItems.clone();
                this.scale(geoms);
                this.outlineItemsShape = this.getPanel().getJava2DConverter().toShape(geoms);
                this.somethingChanged = true;
            }
            catch (Throwable t) {
                this.getPanel().getContext().handleThrowable(t);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            this.setMousePos(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
            double tolerance = (double)SnapManager.getToleranceInPixels(JUMPWorkbench.getBlackboard()) / this.getPanel().getViewport().getScale();
            LineString ls = (LineString)this.originalBBox.getBoundary();
            MultiPoint mps = this.geometryFactory.createMultiPoint(ls.getCoordinates());
            Geometry buffergeom = mps.buffer(tolerance * this.toleranceFactor);
            Point mousep = this.geometryFactory.createPoint(this.mousePos);
            if (buffergeom.contains((Geometry)mousep)) {
                if (this.style == 1) {
                    this.getPanel().setCursor(this.cursor2);
                    this.style = 2;
                    this.somethingChanged = true;
                }
            } else if (this.style == 2) {
                this.getPanel().setCursor(this.cursor1);
                this.style = 1;
                this.somethingChanged = true;
            }
            if (this.somethingChanged) {
                this.redrawShape();
                this.somethingChanged = false;
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Geometry createSelectedItemsBoundingBox(Collection colGeoms) {
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        int count = 0;
        for (Geometry element : colGeoms) {
            if (count == 0) {
                xmin = element.getEnvelopeInternal().getMinX();
                xmax = element.getEnvelopeInternal().getMaxX();
                ymin = element.getEnvelopeInternal().getMinY();
                ymax = element.getEnvelopeInternal().getMaxY();
            } else {
                if (element.getEnvelopeInternal().getMinX() < xmin) {
                    xmin = element.getEnvelopeInternal().getMinX();
                }
                if (element.getEnvelopeInternal().getMaxX() > xmax) {
                    xmax = element.getEnvelopeInternal().getMaxX();
                }
                if (element.getEnvelopeInternal().getMinY() < ymin) {
                    ymin = element.getEnvelopeInternal().getMinY();
                }
                if (element.getEnvelopeInternal().getMaxY() > ymax) {
                    ymax = element.getEnvelopeInternal().getMaxY();
                }
            }
            ++count;
        }
        Coordinate[] coords = new Coordinate[]{new Coordinate(xmin, ymin), new Coordinate(xmin, ymax), new Coordinate(xmax, ymax), new Coordinate(xmax, ymin), new Coordinate(xmin, ymin)};
        LinearRing ring = this.geometryFactory.createLinearRing(coords);
        Polygon geo = this.geometryFactory.createPolygon(ring, null);
        return geo;
    }

    private void setSelectedItemsOutlines() {
        Collection<Geometry> selectedItems = this.getPanel().getSelectionManager().getSelectedItems();
        ArrayList<Geometry> combinedGeometry = new ArrayList<Geometry>();
        for (Geometry element : selectedItems) {
            combinedGeometry.add(element instanceof Polygon ? element.getBoundary() : (Geometry)element.clone());
        }
        this.originalItemsAsLines = this.geometryFactory.createGeometryCollection(combinedGeometry.toArray(new Geometry[combinedGeometry.size()]));
    }

    @Override
    protected Shape getShape() {
        return this.outlineItemsShape;
    }

    public void deactivate(MouseEvent e) {
        super.deactivate();
        this.getPanel().getViewport().removeListener(this.viewportListener);
        this.getPanel().getSelectionManager().removeSelectionListener(this.selectionListener);
        this.cleanup((Graphics2D)this.getPanel().getGraphics());
    }

    protected void setMousePos(Coordinate destination) {
        this.mousePos = this.snap(destination);
    }

    private Coordinate getFarestPoint(Geometry box, Coordinate point) {
        Coordinate[] coords;
        Coordinate farestp = null;
        double maxDist = -1.0;
        double dist = -1.0;
        for (Coordinate coord : coords = box.getCoordinates()) {
            dist = GeoUtils.distance(coord, point);
            if (!(dist > maxDist)) continue;
            maxDist = dist;
            farestp = (Coordinate)coord.clone();
        }
        return farestp;
    }
}

