/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.ui.EditAttTransaction;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotateSelectedItemPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotationRenderObject;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.TransformableRenderObject;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyle;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyleFactory;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingListener;
import com.vividsolutions.jump.workbench.ui.selection.SelectionListener;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.RenderPointSpec;
import de.riwagis.geotools.feature.RenderType;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.bsh.BshCalculator;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.type.Types;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.openjump.core.geomutils.GeoUtils;
import org.openjump.core.geomutils.MathVector;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ListRotationRenderObject;

public class RotateSelectedItemTool
extends DragTool {
    static final String rotateSelectedItem = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.RotateSelectedItemTool.Rotate-Selected-Item");
    static final String angleST = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.angle");
    static final String degrees = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.degrees");
    private TransformableRenderObject selectedFeatureShape = null;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private Coordinate centerCoord = null;
    private Coordinate tentativeCoordinate = null;
    protected boolean clockwise = true;
    private double fullAngle = 0.0;
    private final RenderingListener renderingListener = new RenderingListener(){

        @Override
        public void renderingStarted(LayerViewPanel panel) {
        }

        @Override
        public void renderingStopped(LayerViewPanel panel) {
            if (!RotateSelectedItemTool.this.isDragApproved()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                try {
                    RotateSelectedItemTool.this.createAndSetSelectedItemShape();
                    RotateSelectedItemTool.this.redrawShape();
                }
                catch (Exception e) {
                    RotateSelectedItemTool.this.getPanel().getContext().handleThrowable(e);
                }
            });
        }
    };
    private final SelectionListener selectionListener = () -> {
        this.centerCoord = null;
    };
    boolean shift4SetCenterCoordsDown = false;
    private final KeyListener cursorSwitcher = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (RotateSelectedItemTool.this.shift4SetCenterCoordsDown) {
                RotateSelectedItemTool.this.shift4SetCenterCoordsDown = false;
                this.setCursor();
                RotateSelectedItemTool.this.tentativeCoordinate = null;
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            boolean bl = RotateSelectedItemTool.this.shift4SetCenterCoordsDown = (e.isShiftDown() || e.getKeyCode() == 16) && !e.isControlDown();
            if (RotateSelectedItemTool.this.shift4SetCenterCoordsDown) {
                this.setCursor();
                RotateSelectedItemTool.this.tentativeCoordinate = null;
            }
        }

        private void setCursor() {
            LayerViewPanel lvp = RotateSelectedItemTool.this.getPanel();
            if (lvp != null) {
                lvp.setCursor(RotateSelectedItemTool.this.shift4SetCenterCoordsDown ? Cursor.getPredefinedCursor(1) : RotateSelectedItemTool.this.getCursor());
            }
        }
    };
    private static RotateSelectedItemTool instance = null;

    private RotateSelectedItemTool() {
        this.allowSnapping();
    }

    @Override
    public KeyListener getKeyListener() {
        return this.cursorSwitcher;
    }

    public static RotateSelectedItemTool getInstance() {
        if (instance == null) {
            instance = new RotateSelectedItemTool();
        }
        return instance;
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return RotateSelectedItemTool.getInstance();
    }

    @Override
    protected void gestureFinished() throws Exception {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(() -> {
            boolean tmpFiringLayerEvents = this.getPanel().getLayerManager().isFiringEvents();
            HashMap layersWithEditedFeatures = new HashMap();
            try {
                ArrayList<UndoableCommand> commands = new ArrayList<UndoableCommand>();
                this.getPanel().getLayerManager().setFiringEvents(false);
                for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
                    int i;
                    EditTransaction transRot = this.createTransaction(layerWithSelectedItems);
                    commands.add(transRot.createCommand());
                    ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>(transRot.size());
                    for (i = 0; i < transRot.size(); ++i) {
                        features.add(transRot.getFeature(i));
                    }
                    layersWithEditedFeatures.put(layerWithSelectedItems, features);
                    if (!RotateSelectedItemPanel.instanceOf().isRotateSymbol() && !RotateSelectedItemPanel.instanceOf().isRotateText()) continue;
                    for (i = 0; i < transRot.size(); ++i) {
                        EditAttTransaction trans = this.createAttTransaction(layerWithSelectedItems, transRot.getFeature(i));
                        if (trans == null) continue;
                        commands.add(trans.createCommand());
                    }
                }
                this.execute(commands);
                this.getPanel().getLayerManager().setFiringEvents(tmpFiringLayerEvents);
            }
            catch (Exception e) {
                dlgWait.setError(e);
                layersWithEditedFeatures.clear();
            }
            finally {
                this.getPanel().getLayerManager().setFiringEvents(tmpFiringLayerEvents);
                if (dlgWait.getError() != null) return;
                for (Layer selectedLayer : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
                    this.getPanel().getLayerManager().fireGeometryModified((Collection)layersWithEditedFeatures.get(selectedLayer), selectedLayer, this.getPanel().getSelectionManager().getFeaturesWithSelectedItems(selectedLayer));
                }
                return;
            }
            if (dlgWait.getError() != null) return;
            for (Layer selectedLayer : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
                this.getPanel().getLayerManager().fireGeometryModified((Collection)layersWithEditedFeatures.get(selectedLayer), selectedLayer, this.getPanel().getSelectionManager().getFeaturesWithSelectedItems(selectedLayer));
            }
            return;
        });
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            this.getPanel().getContext().handleThrowable(dlgWait.getError());
        }
    }

    private EditTransaction createTransaction(Layer layer) {
        return EditTransaction.createTransactionOnSelection((geometryWithSelectedItems, selectedItems) -> {
            selectedItems.forEach(this::rotate);
            return geometryWithSelectedItems;
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
    }

    private EditAttTransaction createAttTransaction(Layer layer, SimpleFeature feat) throws Exception {
        Object objOri;
        ArrayList<SimpleFeature> lstFeat = new ArrayList<SimpleFeature>(1);
        lstFeat.add(feat);
        boolean useTransaction = false;
        EditAttTransaction trans = new EditAttTransaction(lstFeat, "RotateSelectionItemTool", layer, this.getPanel().getContext());
        String strOri = layer.getFMD().getOriAtt();
        String strOriTrans = layer.getFMD().getOriTrans();
        ExportStyle exportStyle = ExportStyleFactory.createExportStyle(layer, feat, 0.0);
        if (this.containsAtt(layer, strOri) && RotateSelectedItemPanel.instanceOf().isRotateSymbol()) {
            Object objOri2;
            double dblOri = 0.0;
            ExportStyle.InsertionPoint[] insertPoints = exportStyle.getSymInsertPoints();
            if (insertPoints != null && insertPoints.length > 0) {
                dblOri = insertPoints[0].getOrientation();
            } else {
                objOri2 = FeatureUtil.getAttribute((SimpleFeature)feat, (String)strOri);
                if (objOri2 instanceof Number) {
                    dblOri = ((Number)objOri2).doubleValue();
                }
            }
            dblOri -= this.fullAngle * 180.0 / Math.PI;
            dblOri = this.ensure360Degree(dblOri);
            if (strOriTrans == null || strOriTrans.trim().length() == 0) {
                objOri2 = Types.parse((AttributeDescriptor)layer.getFeatureType().getDescriptor(strOri), (Object)dblOri);
                trans.addAttribute(strOri, objOri2);
                useTransaction = true;
            } else {
                BshCalculator calc = layer.getFMD().getOriTransCalc();
                calc.setValue(dblOri);
                objOri = Types.parse((AttributeDescriptor)layer.getFeatureType().getDescriptor(strOri), (Object)calc.getDouble());
                trans.addAttribute(strOri, objOri);
                useTransaction = true;
            }
        }
        String strTextOri = layer.getFMD().getTextOriAtt();
        if (layer.getFMD().getUseText() && this.containsAtt(layer, strTextOri) && RotateSelectedItemPanel.instanceOf().isRotateText()) {
            double dblTextOri = 0.0;
            ExportStyle.InsertionPoint[] insertPoints = exportStyle.getTextInsertPoints();
            if (insertPoints != null && insertPoints.length > 0) {
                dblTextOri = insertPoints[0].getOrientation();
            } else {
                objOri = FeatureUtil.getAttribute((SimpleFeature)feat, (String)strTextOri);
                if (objOri instanceof Number) {
                    dblTextOri = ((Number)objOri).doubleValue();
                }
            }
            dblTextOri -= this.fullAngle * 180.0 / Math.PI;
            dblTextOri = this.ensure360Degree(dblTextOri);
            if (strOriTrans == null || strOriTrans.trim().length() == 0) {
                objOri = Types.parse((AttributeDescriptor)layer.getFeatureType().getDescriptor(strTextOri), (Object)dblTextOri);
                trans.addAttribute(strTextOri, objOri);
                useTransaction = true;
            } else {
                BshCalculator calc = layer.getFMD().getOriTransCalc();
                calc.setValue(dblTextOri);
                Object objOri3 = Types.parse((AttributeDescriptor)layer.getFeatureType().getDescriptor(strTextOri), (Object)calc.getDouble());
                trans.addAttribute(strTextOri, objOri3);
                useTransaction = true;
            }
        }
        String strDXAtt = layer.getFMD().getTextDXAtt();
        String strDYAtt = layer.getFMD().getTextDYAtt();
        if (this.containsAtt(layer, strDXAtt) && this.containsAtt(layer, strDYAtt) && RotateSelectedItemPanel.instanceOf().isRotateText()) {
            Object objDY;
            double dxFeat = 0.0;
            double dyFeat = 0.0;
            Object objDX = feat.getAttribute(strDXAtt);
            if (objDX != null) {
                if (objDX instanceof Number) {
                    dxFeat = ((Number)objDX).doubleValue();
                } else {
                    try {
                        dxFeat = Double.parseDouble(objDX.toString());
                    }
                    catch (Exception e) {
                        dxFeat = 0.0;
                    }
                }
            }
            if ((objDY = feat.getAttribute(strDYAtt)) != null) {
                if (objDY instanceof Number) {
                    dyFeat = ((Number)objDY).doubleValue();
                } else {
                    try {
                        dyFeat = Double.parseDouble(objDY.toString());
                    }
                    catch (Exception e) {
                        dyFeat = 0.0;
                    }
                }
            }
            double cosAngle = Math.cos(this.fullAngle);
            double sinAngle = Math.sin(this.fullAngle);
            double dxFeatNew = dxFeat * cosAngle + dyFeat * sinAngle;
            double dyFeatNew = dyFeat * cosAngle - dxFeat * sinAngle;
            objDX = Types.parse((AttributeDescriptor)layer.getFeatureType().getDescriptor(strDXAtt), (Object)dxFeatNew);
            trans.addAttribute(strDXAtt, objDX);
            objDY = Types.parse((AttributeDescriptor)layer.getFeatureType().getDescriptor(strDYAtt), (Object)dyFeatNew);
            trans.addAttribute(strDYAtt, objDY);
            useTransaction = true;
        }
        return useTransaction ? trans : null;
    }

    private double ensure360Degree(double dblOriDeg) {
        if (dblOriDeg < 0.0) {
            dblOriDeg += 360.0;
            dblOriDeg = this.ensure360Degree(dblOriDeg);
        } else if (dblOriDeg > 360.0) {
            dblOriDeg -= 360.0;
            dblOriDeg = this.ensure360Degree(dblOriDeg);
        }
        return dblOriDeg;
    }

    private void rotate(Geometry geometry) {
        geometry.apply(coordinate -> {
            double cosAngle = Math.cos(this.fullAngle);
            double sinAngle = Math.sin(this.fullAngle);
            double x = coordinate.x - this.centerCoord.x;
            double y = coordinate.y - this.centerCoord.y;
            coordinate.x = this.centerCoord.x + x * cosAngle + y * sinAngle;
            coordinate.y = this.centerCoord.y + y * cosAngle - x * sinAngle;
        });
    }

    @Override
    public Cursor createCursor() {
        return RotateSelectedItemTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_rotate_label.svg").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_rotate.svg");
    }

    @Override
    public String getName() {
        return rotateSelectedItem;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (this.shift4SetCenterCoordsDown) {
            try {
                this.tentativeCoordinate = this.snap(e.getPoint());
                this.redrawShape();
            }
            catch (Throwable t) {
                this.getPanel().getContext().handleThrowable(t);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            if (!this.checkMouseButton(e)) {
                return;
            }
            if (!this.check(EnableCheckFactory.getInstance().createSelectedItemsLayersMustBeEditableCheck())) {
                return;
            }
            if (this.shift4SetCenterCoordsDown) {
                this.centerCoord = this.snap(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
            } else {
                if (!this.check(EnableCheckFactory.getInstance().createAtLeastNItemsMustBeSelectedCheck(1))) {
                    return;
                }
                boolean ret = this.createAndSetSelectedItemShape();
                if (ret) {
                    return;
                }
                super.mousePressed(e);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected void setModelSource(Coordinate source) {
        super.setModelSource(this.snap(source));
    }

    public boolean createAndSetSelectedItemShape() {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(() -> {
            try {
                this.selectedFeatureShape = this.createSelectedItemsShape();
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(500L);
        if (dlgWait.getError() != null) {
            this.getPanel().getContext().handleThrowable(dlgWait.getError());
        }
        return dlgWait.isCanceled();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.shift4SetCenterCoordsDown) {
            this.tentativeCoordinate = null;
            return;
        }
        super.mouseReleased(e);
    }

    private TransformableRenderObject createSelectedItemsShape() {
        try {
            SelectionManager selectionManager = this.getPanel().getSelectionManager();
            Collection<Layer> layersWithSelectedItems = selectionManager.getLayersWithSelectedItems();
            if (layersWithSelectedItems.isEmpty()) {
                Assert.shouldNeverReachHere((String)"no Layer with selected features found");
            }
            Viewport vp = WorkbenchContext.getInstance().getLayerViewPanel().getViewport();
            if (this.centerCoord == null) {
                Collection<Geometry> selectedGeos = selectionManager.getSelectedItems();
                Geometry[] allGeoms = new Geometry[selectedGeos.size()];
                int j = 0;
                for (Geometry geo : selectedGeos) {
                    allGeoms[j++] = geo;
                }
                GeometryCollection geo = this.geometryFactory.createGeometryCollection(allGeoms);
                this.centerCoord = geo.getCentroid().getCoordinate();
            }
            ListRotationRenderObject renderObject = new ListRotationRenderObject();
            for (Layer layer : layersWithSelectedItems) {
                boolean useTextOriAttGlobal;
                Envelope queryEnv = vp.getEnvelopeInModelCoordinates();
                Rectangle2D queryRect = vp.toViewRectangle(queryEnv);
                HashSet<String> featureIDs = new HashSet<String>();
                for (SimpleFeature fi : selectionManager.getFeaturesWithSelectedItems(layer)) {
                    featureIDs.add(fi.getID());
                }
                if (featureIDs.size() > 100) {
                    ArrayList lst = new ArrayList(featureIDs);
                    Collections.shuffle(lst);
                    featureIDs = new HashSet(lst.subList(0, 100));
                }
                String strOriAtt = layer.getFMD().getOriAtt();
                String strTextOriAtt = layer.getFMD().getTextOriAtt();
                boolean useOriAttGlobal = this.containsAtt(layer, strOriAtt) && RotateSelectedItemPanel.instanceOf().isRotateSymbol();
                boolean bl = useTextOriAttGlobal = layer.getFMD().getUseText() && this.containsAtt(layer, strTextOriAtt) && RotateSelectedItemPanel.instanceOf().isRotateText();
                if (layer instanceof DimLayer) {
                    useOriAttGlobal = true;
                    useTextOriAttGlobal = true;
                }
                boolean useOriAtt = useOriAttGlobal;
                boolean useTextOriAtt = useTextOriAttGlobal;
                Iterator<Object> renderedIndexIter = layer.getRenderedIndexIterator(queryRect);
                while (renderedIndexIter.hasNext()) {
                    Object[] arrObj = (Object[])renderedIndexIter.next();
                    Shape[] shapes = (Shape[])arrObj[0];
                    SimpleFeature feature = (SimpleFeature)arrObj[1];
                    RenderPointSpec spec = (RenderPointSpec)arrObj[2];
                    if (!featureIDs.contains(feature.getID())) continue;
                    if (layer instanceof AbstractCadLayer) {
                        if (ObjectUtils.toString((Object)feature.getAttribute("isdim")).equals("1") || ObjectUtils.toString((Object)feature.getAttribute("ISDIM")).equals("1")) {
                            useOriAtt = true;
                            useTextOriAtt = true;
                        } else {
                            useOriAtt = useOriAttGlobal;
                            useTextOriAtt = useTextOriAttGlobal;
                        }
                    }
                    Geometry filteredGeo = selectionManager.filterGeometryIfNecessary(layer, feature);
                    if (shapes == null || spec == null) {
                        Shape shape2 = this.getPanel().getJava2DConverter().toShape(filteredGeo, 10.0);
                        renderObject.addObject(new RotationRenderObject(shape2, this.getCenterPoint()));
                        continue;
                    }
                    Path2D.Double path = new Path2D.Double();
                    this.processIfSelected(spec, shapes, filteredGeo, shape -> path.append((Shape)shape, false));
                    if (spec != null && spec.getRenderType() == RenderType.SYMBOL) {
                        this.addRenderObject(renderObject, useOriAtt, path, spec.getCenterPoint());
                        continue;
                    }
                    if (spec != null && spec.getRenderType() == RenderType.TEXT) {
                        this.addRenderObject(renderObject, useTextOriAtt, path, spec.getCenterPoint());
                        continue;
                    }
                    renderObject.addObject(new RotationRenderObject(path, this.getCenterPoint()));
                }
            }
            return renderObject;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addRenderObject(ListRotationRenderObject renderObject, boolean useOrientation, Path2D path, final Point2D basePt) throws NoninvertibleTransformException {
        if (useOrientation) {
            renderObject.addObject(new RotationRenderObject(path, this.getCenterPoint()));
        } else {
            renderObject.addObject(new RotationRenderObject(this, path, this.getCenterPoint()){

                @Override
                public Path2D getTransformedShape(double ori) {
                    AffineTransform transform = new AffineTransform();
                    transform.rotate(ori, this.centerPt.getX(), this.centerPt.getY());
                    Point2D t = transform.transform(basePt, null);
                    double dx = t.getX() - basePt.getX();
                    double dy = t.getY() - basePt.getY();
                    transform.setToIdentity();
                    transform.translate(dx, dy);
                    return new Path2D.Double(this.shape, transform);
                }
            });
        }
    }

    @Override
    protected Shape getShape() throws Exception {
        boolean ccwQuad;
        MathVector currVec;
        if (this.shift4SetCenterCoordsDown) {
            GeneralPath path = new GeneralPath();
            this.drawSnapCross(this.tentativeCoordinate, path, this.getPanel());
            return path;
        }
        if (this.centerCoord == null) {
            return new GeneralPath();
        }
        Point2D centerPt = this.getCenterPoint();
        Point2D initialPt = this.getViewSource();
        Point2D currPt = this.getViewDestination();
        MathVector center = new MathVector(centerPt.getX(), centerPt.getY());
        MathVector initial = new MathVector(initialPt.getX(), initialPt.getY());
        MathVector curr = new MathVector(currPt.getX(), currPt.getY());
        MathVector initVec = initial.vectorBetween(center);
        double arcAngle = initVec.angleRad(currVec = curr.vectorBetween(center));
        if (Double.isNaN(arcAngle)) {
            arcAngle = 0.0;
        }
        Coordinate initialCoord = this.getPanel().getViewport().toModelCoordinate(initialPt);
        Coordinate currCoord = this.getPanel().getViewport().toModelCoordinate(currPt);
        boolean toRight = GeoUtils.pointToRight(currCoord, this.centerCoord, initialCoord);
        boolean cwQuad = this.fullAngle >= 0.0 && this.fullAngle <= 90.0 && this.clockwise;
        boolean bl = ccwQuad = this.fullAngle < 0.0 && this.fullAngle >= -90.0 && !this.clockwise;
        if (arcAngle <= 90.0 && (cwQuad || ccwQuad)) {
            this.clockwise = toRight;
        }
        this.fullAngle = this.fullAngle > 90.0 || this.fullAngle < -90.0 ? (this.clockwise && !toRight || !this.clockwise && toRight ? 360.0 - arcAngle : arcAngle) : arcAngle;
        if (!this.clockwise) {
            this.fullAngle = -this.fullAngle;
        }
        DecimalFormat df2 = new DecimalFormat("##0.0#");
        this.getPanel().getContext().setStatusMessage(angleST + ": " + df2.format(Math.toDegrees(this.fullAngle) * -1.0) + " " + degrees);
        GeneralPath path = new GeneralPath();
        path.moveTo(centerPt.getX() - 10.0, centerPt.getY());
        path.lineTo(centerPt.getX() + 10.0, centerPt.getY());
        path.moveTo(centerPt.getX(), centerPt.getY() - 10.0);
        path.lineTo(centerPt.getX(), centerPt.getY() + 10.0);
        this.drawSnapCross(currCoord, path, this.getPanel());
        Path2D transformedShape = this.createTransformedShape(centerPt);
        if (transformedShape != null) {
            path.append(transformedShape, false);
        }
        return path;
    }

    private Path2D createTransformedShape(Point2D centerPt) {
        if (this.selectedFeatureShape == null) {
            return null;
        }
        return this.selectedFeatureShape.getTransformedShape(this.fullAngle);
    }

    private Point2D getCenterPoint() throws NoninvertibleTransformException {
        return this.getPanel().getViewport().toViewPoint(new Point2D.Double(this.centerCoord.x, this.centerCoord.y));
    }

    @Override
    public JPanel getAssistentPanel() {
        return RotateSelectedItemPanel.instanceOf();
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        this.getPanel().getRenderingManager().addRenderingListener(this.renderingListener);
        this.getPanel().getSelectionManager().addSelectionListener(this.selectionListener);
        Collection<Layer> colLy = this.getPanel().getSelectionManager().getLayersWithSelectedItems();
        Iterator<Layer> iLy = colLy.iterator();
        boolean setRotateSymbolEnabled = false;
        boolean setRotateTextEnabled = false;
        while (iLy.hasNext()) {
            Layer ly = iLy.next();
            String strOriAtt = ly.getFMD().getOriAtt();
            String strTextOriAtt = ly.getFMD().getTextOriAtt();
            if (this.containsAtt(ly, strOriAtt)) {
                setRotateSymbolEnabled = true;
            }
            if (!ly.getFMD().getUseText() || !this.containsAtt(ly, strTextOriAtt)) continue;
            setRotateTextEnabled = true;
        }
        RotateSelectedItemPanel.instanceOf().setRotateSymbolEnabled(setRotateSymbolEnabled);
        RotateSelectedItemPanel.instanceOf().setRotateTextEnabled(setRotateTextEnabled);
    }

    @Override
    public void deactivate() {
        this.getPanel().getRenderingManager().removeRenderingListener(this.renderingListener);
        this.getPanel().getSelectionManager().removeSelectionListener(this.selectionListener);
        super.deactivate();
        this.selectedFeatureShape = null;
        this.centerCoord = null;
    }

    private boolean containsAtt(Layer ly, String strText) {
        return StringUtils.isNotEmpty((CharSequence)strText) && ly.getFeatureType().indexOf(strText) > -1;
    }

    public static EnableCheck createEnableCheck() {
        return new MultiEnableCheck().add(EditingPanel.instanceOf().getEditSelectionAllLayerEnableCheck());
    }
}

