/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import de.riwagis.icons.IconLoader;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Icon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ConstrainedMultiClickTool;

public class DrawConstrainedLineStringTool
extends ConstrainedMultiClickTool {
    static final String drawConstrainedLineString = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedLineStringTool.Draw-Constrained-LineString");
    static final String TheLinestringMustHaveAtLeast2Points = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedLineStringTool.The-linestring-must-have-at-least-2-points");

    private DrawConstrainedLineStringTool() {
        this.drawClosed = false;
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new DrawConstrainedLineStringTool(), true);
    }

    @Override
    public String getName() {
        return drawConstrainedLineString;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon((String)"DrawLinestringConstrained.gif");
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (!this.checkLineString()) {
            return;
        }
        this.execute(FeatureDrawingUtil.createAddCommand((Geometry)this.getLineString(), this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
    }

    protected LineString getLineString() throws NoninvertibleTransformException {
        return new GeometryFactory().createLineString(this.toArray(this.getCoordinates()));
    }

    protected boolean checkLineString() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser(TheLinestringMustHaveAtLeast2Points);
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getLineString());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }
}

