/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import de.riwagis.icons.IconLoader;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.openjump.core.geomutils.Circle;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ConstrainedMultiClickTool;

public class DrawConstrainedCircleTool
extends ConstrainedMultiClickTool {
    static final String drawConstrainedCircle = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedCircleTool.Draw-Constrained-Circle");
    static final String theCircleMustHaveAtLeast2Points = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedCircleTool.The-circle-must-have-at-least-2-points");

    private DrawConstrainedCircleTool() {
        this.drawClosed = true;
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new DrawConstrainedCircleTool(), true);
    }

    @Override
    public String getName() {
        return drawConstrainedCircle;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon((String)"DrawCircleConstrained.gif");
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (!this.checkCircle()) {
            return;
        }
        this.execute(FeatureDrawingUtil.createAddCommand((Geometry)this.getCircle(), this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
    }

    protected Polygon getCircle() throws NoninvertibleTransformException {
        double angle = 360.0;
        ArrayList points = new ArrayList(this.getCoordinates());
        if (this.getCoordinates().size() == 2) {
            Circle circle = new Circle((Coordinate)points.get(0), ((Coordinate)points.get(0)).distance((Coordinate)points.get(1)));
            return circle.getPoly();
        }
        Coordinate a = (Coordinate)points.get(0);
        Coordinate b = (Coordinate)points.get(1);
        Coordinate c = (Coordinate)points.get(2);
        double A = b.x - a.x;
        double B = b.y - a.y;
        double C = c.x - a.x;
        double D = c.y - a.y;
        double E = A * (a.x + b.x) + B * (a.y + b.y);
        double F = C * (a.x + c.x) + D * (a.y + c.y);
        double G = 2.0 * (A * (c.y - b.y) - B * (c.x - b.x));
        if (G != 0.0) {
            double px = (D * E - B * F) / G;
            double py = (A * F - C * E) / G;
            Coordinate center = new Coordinate(px, py);
            double radius = Math.sqrt((a.x - px) * (a.x - px) + (a.y - py) * (a.y - py));
            Circle circle = new Circle(center, radius);
            return circle.getPoly();
        }
        Circle circle = new Circle((Coordinate)points.get(1), ((Coordinate)points.get(1)).distance((Coordinate)points.get(2)));
        return circle.getPoly();
    }

    protected boolean checkCircle() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser(theCircleMustHaveAtLeast2Points);
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getCircle());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }
}

