/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import de.riwagis.icons.IconLoader;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.openjump.core.geomutils.Arc;
import org.openjump.core.geomutils.MathVector;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ConstrainedMultiClickArcTool;

public class DrawConstrainedArcTool
extends ConstrainedMultiClickArcTool {
    static final String drawConstrainedArc = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedArcTool.Draw-Constrained-Arc");
    static final String theArcMustHaveAtLeast3Points = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedArcTool.The-arc-must-have-at-least-3-points");

    private DrawConstrainedArcTool() {
        this.drawClosed = false;
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new DrawConstrainedArcTool(), true);
    }

    @Override
    public String getName() {
        return drawConstrainedArc;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon((String)"DrawArcConstrained.gif");
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (!this.checkArc()) {
            return;
        }
        this.execute(FeatureDrawingUtil.createAddCommand((Geometry)this.getArc(), this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
    }

    protected LineString getArc() throws NoninvertibleTransformException {
        ArrayList points = new ArrayList(this.getCoordinates());
        if (points.size() > 1) {
            Coordinate a = (Coordinate)points.get(0);
            Coordinate b = (Coordinate)points.get(1);
            Coordinate c = this.tentativeCoordinate;
            if (points.size() > 2) {
                c = (Coordinate)points.get(points.size() - 1);
            }
            MathVector v1 = new MathVector(b).vectorBetween(new MathVector(a));
            MathVector v2 = new MathVector(c).vectorBetween(new MathVector(a));
            double arcAngle = v1.angleDeg(v2);
            Arc arc = new Arc(a, b, this.fullAngle);
            return arc.getLineString();
        }
        return null;
    }

    protected boolean checkArc() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 3) {
            this.getPanel().getContext().warnUser(theArcMustHaveAtLeast3Points);
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getArc());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }
}

