/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.openjump.core.ui.MultiInputDialogWithoutCancel;

public class DrawCircleWithGivenRadiusTool
extends NClickTool {
    protected Coordinate modelDestination = null;
    private Shape selectedFeaturesShape;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private boolean valuesWereSet = false;
    private double radius = 50.0;
    private Point mp = null;
    private int points = 8;
    private double tolerance = 0.1;
    private int deactivateCount = 0;
    private final String T1 = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Cirlce-Radius") + ":";
    private final String T2 = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Number-of-segments-per-circle-quarter") + ":";
    private final String name = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Draw-circle-with-given-radius-and-center");
    private final String sidebarstring = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Draws-a-circle-by-specifiying-the-radius-and-the-circle-accuracy-and-the-centre-position-by-mouse-click");
    private final String sAccuracy = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Circle-Accuracy");
    private final String sReset = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.too-small-tolerance-reset-to-300-segments");

    private DrawCircleWithGivenRadiusTool() {
        super(1);
        this.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f));
        this.allowSnapping();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new DrawCircleWithGivenRadiusTool(), true);
    }

    @Override
    protected void gestureFinished() throws Exception {
        Point p;
        this.mp = p = new GeometryFactory().createPoint(this.getModelDestination());
        double tmp = Math.acos((this.radius - this.tolerance) / this.radius);
        if (tmp != 0.0) {
            int pts = (int)Math.floor(Math.PI / tmp / 4.0);
            if (pts < 3) {
                pts = 3;
            }
            if (pts > 300) {
                pts = 300;
                AbstractCursorTool.workbenchFrame(this.getPanel()).warnUser(this.sReset);
            }
            this.points = pts;
        }
        Geometry circle = BufferOp.bufferOp((Geometry)p, (double)this.radius, (int)(this.points - 1));
        this.checkCircle(circle);
        if (circle instanceof Polygon) {
            FeatureDrawingUtil.drawRing((Polygon)circle, this.isRollingBackInvalidEdits(), this, this.getPanel());
        }
    }

    protected boolean checkCircle(Geometry circle) throws NoninvertibleTransformException {
        IsValidOp isValidOp = new IsValidOp(circle);
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        try {
            if (!this.valuesWereSet) {
                this.makeDialogThings(layerViewPanel);
                this.valuesWereSet = true;
            }
            Envelope viewportEnvelope = layerViewPanel.getViewport().getEnvelopeInModelCoordinates();
            double x = viewportEnvelope.getMinX() + viewportEnvelope.getWidth() / 2.0;
            double y = viewportEnvelope.getMinY() + viewportEnvelope.getHeight() / 2.0;
            Coordinate initCoords = new Coordinate(x, y);
            this.calcuateCircle(initCoords, layerViewPanel);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        ++this.deactivateCount;
        if (this.deactivateCount == 2) {
            this.valuesWereSet = false;
            this.deactivateCount = 0;
        }
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("DrawCircleByRadius.gif"));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            this.setViewDestination(e.getPoint());
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected Shape getShape() {
        this.calcuateCircle(this.modelDestination, this.getPanel());
        return this.selectedFeaturesShape;
    }

    private void calcuateCircle(Coordinate middlePoint, LayerViewPanel panel) {
        Point p;
        this.mp = p = new GeometryFactory().createPoint(middlePoint);
        Geometry buffer = p.buffer(this.radius);
        Geometry[] geomArray = new Geometry[]{buffer};
        GeometryCollection gc = this.geometryFactory.createGeometryCollection(geomArray);
        try {
            this.selectedFeaturesShape = panel.getJava2DConverter().toShape((Geometry)gc);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println("DrawCircleWithGivenRadiusTool:Exception " + String.valueOf(e));
        }
    }

    public boolean makeDialogThings(LayerViewPanel panel) throws Exception {
        LayerViewPanelContext context = panel.getContext();
        WorkbenchFrame fr = (WorkbenchFrame)context;
        MultiInputDialogWithoutCancel dialog = new MultiInputDialogWithoutCancel(fr, this.getName(), true);
        this.setDialogValues(dialog);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    private void setDialogValues(MultiInputDialogWithoutCancel dialog) {
        dialog.setSideBarDescription(this.sidebarstring);
        dialog.addDoubleField(this.T1, this.radius, 7, this.T1);
        dialog.addDoubleField(this.sAccuracy, this.tolerance, 7, this.sAccuracy);
    }

    private void getDialogValues(MultiInputDialogWithoutCancel dialog) {
        this.radius = dialog.getDouble(this.T1);
        this.tolerance = dialog.getDouble(this.sAccuracy);
    }

    protected void setViewDestination(Point2D destination) throws NoninvertibleTransformException {
        this.setModelDestination(this.getPanel().getViewport().toModelCoordinate(destination));
    }

    protected void setModelDestination(Coordinate destination) {
        this.modelDestination = this.snap(destination);
    }
}

