/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import lombok.Generated;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutFeaturesTool
extends MultiClickTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CutFeaturesTool.class);
    private final GeometryEditor geometryEditor = new GeometryEditor();
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final KeyListener klstEnter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10) {
                try {
                    CutFeaturesTool.this.finishGesture();
                }
                catch (Exception e1) {
                    WorkbenchContext.getFrame().handleThrowable(e1);
                }
            }
        }
    };

    public CutFeaturesTool() {
        this.setColor(Color.red);
        this.setStroke(new BasicStroke(1.5f, 2, 1, 10.0f, new float[]{10.0f, 5.0f}, 0.0f));
        this.allowSnapping();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_split.svg");
    }

    @Override
    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.tools.CutFeaturesTool");
    }

    @Override
    public Cursor createCursor() {
        return CutFeaturesTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_cut.svg").getImage());
    }

    @Override
    public KeyListener getKeyListener() {
        return this.klstEnter;
    }

    @Override
    protected void gestureFinished() throws Exception {
        WorkbenchContext context = JUMPWorkbench.getContext();
        SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
        final Layer activeLayer = selectionManager.getLayersWithSelectedItems().iterator().next();
        if (activeLayer.isEditable()) {
            SimpleFeatureType ft = activeLayer.getFeatureType();
            Collection<SimpleFeature> selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(activeLayer);
            final Layer ly2Insert = this.getTargetLayer(activeLayer);
            final ArrayList<SimpleFeature> lstEditFeat = new ArrayList<SimpleFeature>();
            final ArrayList<SimpleFeature> lstAddFeat = new ArrayList<SimpleFeature>();
            final ArrayList<SimpleFeature> lstOriFeat = new ArrayList<SimpleFeature>();
            for (SimpleFeature featureSelected : selectedFeatures) {
                Geometry geomSelected = (Geometry)featureSelected.getDefaultGeometry();
                LineString geomDraw = this.getLineString();
                if (geomSelected.isEmpty()) {
                    return;
                }
                if (this.isGeometryCollection(geomSelected)) {
                    List<Geometry> selectedItems = selectionManager.getSelections().stream().flatMap(s -> s.items(geomSelected, s.getSelectedItemIndices(activeLayer, featureSelected)).stream()).collect(Collectors.toList());
                    this.splitCollectionAndModify(lstEditFeat, lstOriFeat, featureSelected, geomSelected, selectedItems, (Geometry)geomDraw);
                    continue;
                }
                if (!geomDraw.intersects(geomSelected)) continue;
                if (geomSelected instanceof Polygon || geomSelected instanceof MultiPolygon) {
                    this.splitGeometryAndAdd(ft, lstEditFeat, lstAddFeat, lstOriFeat, featureSelected, CutFeaturesTool.splitPolygon((Geometry)geomDraw, geomSelected));
                    continue;
                }
                if (!(geomSelected instanceof LineString) && !(geomSelected instanceof MultiLineString)) continue;
                this.splitGeometryAndAdd(ft, lstEditFeat, lstAddFeat, lstOriFeat, featureSelected, CutFeaturesTool.splitLines((Geometry)geomDraw, geomSelected));
            }
            if (lstAddFeat.isEmpty() && lstEditFeat.isEmpty()) {
                return;
            }
            UndoableCommand command = new UndoableCommand(this, this.getName()){

                @Override
                public void execute() {
                    activeLayer.editFeature(lstEditFeat, 2);
                    try {
                        if (activeLayer instanceof AbstractCadLayer && ly2Insert instanceof AbstractCadLayer) {
                            ((AbstractCadLayer)activeLayer).setUseDefaultFeature(false);
                        }
                        ly2Insert.editFeature(lstAddFeat, 1);
                    }
                    finally {
                        if (activeLayer instanceof AbstractCadLayer) {
                            ((AbstractCadLayer)activeLayer).setUseDefaultFeature(true);
                        }
                    }
                }

                @Override
                public void unexecute() {
                    activeLayer.editFeature(lstOriFeat, 2);
                    ly2Insert.editFeature(lstAddFeat, 3);
                }
            };
            this.execute(command);
            SaveLayerFeatureChangesPlugIn.commitLayer(activeLayer, true, false, false);
            SaveLayerFeatureChangesPlugIn.commitLayer(ly2Insert, false, true, false);
            WorkbenchContext.getInstance().getSelectionManager().clear();
            WorkbenchContext.getInstance().getSelectionManager().getFeatureSelection().selectItems(activeLayer, lstEditFeat);
        } else {
            JOptionPane.showMessageDialog(null, I18N.getMessage("plugin.EnableCheckFactory.selected-items-layers-must-be-editable", 1), I18N.get("org.openjump.core.ui.plugin.edittoolbox.Information"), 1);
        }
    }

    private boolean isGeometryCollection(Geometry geomSelected) {
        return geomSelected.getClass().getSimpleName().equals("GeometryCollection");
    }

    private void splitCollectionAndModify(List<SimpleFeature> lstEditFeat, List<SimpleFeature> lstOriFeat, SimpleFeature featureSelected, Geometry geomSelected, List<Geometry> selectedItems, Geometry geomDraw) {
        Geometry newGeometry = this.geometryEditor.selectiveEdit(geomSelected, selectedItems, geometry -> {
            try {
                if (!this.isGeometryCollection(geometry) && geomDraw.intersects(geometry)) {
                    List<Geometry> div;
                    if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
                        List<Geometry> div2 = CutFeaturesTool.splitPolygon(geomDraw, geometry);
                        if (div2.size() > 1) {
                            return this.geometryFactory.createMultiPolygon(div2.toArray(new Polygon[div2.size()]));
                        }
                    } else if ((geometry instanceof LineString || geometry instanceof MultiLineString) && (div = CutFeaturesTool.splitLines(geomDraw, geometry)).size() > 1) {
                        return this.geometryFactory.createMultiLineString(div.toArray(new LineString[div.size()]));
                    }
                }
            }
            catch (Exception e) {
                log.error("Could not split and transform geometry", (Throwable)e);
            }
            return geometry;
        });
        if (newGeometry != geomSelected) {
            lstOriFeat.add(featureSelected);
            SimpleFeature editFeat = FeatureUtil.cloneFeature((SimpleFeature)featureSelected);
            editFeat.setDefaultGeometry((Object)this.geometryEditor.simplify(newGeometry));
            lstEditFeat.add(editFeat);
        }
    }

    void splitGeometryAndAdd(SimpleFeatureType ft, List<SimpleFeature> lstEditFeat, List<SimpleFeature> lstAddFeat, List<SimpleFeature> lstOriFeat, SimpleFeature featureSelected, List<Geometry> geometries) {
        List<Geometry> div = geometries;
        if (div.size() > 1) {
            lstOriFeat.add(featureSelected);
            SimpleFeature editFeat = FeatureUtil.cloneFeature((SimpleFeature)featureSelected);
            editFeat.setDefaultGeometry((Object)div.get(0));
            lstEditFeat.add(editFeat);
            for (int i = 1; i < div.size(); ++i) {
                Geometry geom = div.get(i);
                SimpleFeature featureIntersect = FeatureUtil.createFeature((SimpleFeatureType)ft);
                FeatureUtil.copyFeatureData((SimpleFeature)featureSelected, (SimpleFeature)featureIntersect);
                featureIntersect.setDefaultGeometry((Object)geom);
                lstAddFeat.add(featureIntersect);
            }
        }
    }

    protected boolean checkLineString() {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.DrawLineString.the-linestring-must-have-at-least-2-points"));
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getLineString());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }

    private LineString getLineString() {
        return this.geometryFactory.createLineString(CutFeaturesTool.toArray(this.getCoordinates()));
    }

    public static List<Geometry> splitPolygon(Geometry digitizedGeometry, Geometry geomSel) {
        ArrayList linearNetwork = new ArrayList();
        linearNetwork.addAll(LinearComponentExtracter.getLines((Geometry)digitizedGeometry));
        linearNetwork.addAll(LinearComponentExtracter.getLines((Geometry)geomSel));
        Geometry nodedLinearNetwork = UnaryUnionOp.union(linearNetwork);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(nodedLinearNetwork);
        Collection polys = polygonizer.getPolygons();
        Envelope env = geomSel.getEnvelopeInternal();
        double maxAbsX = Math.max(Math.abs(env.getMaxX()), Math.abs(env.getMinX()));
        double maxAbsY = Math.max(Math.abs(env.getMaxY()), Math.abs(env.getMinY()));
        Geometry buffer = geomSel.buffer(Math.ulp(Math.max(maxAbsX, maxAbsY)) * 1000.0);
        Iterator it = polys.iterator();
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        while (it.hasNext()) {
            Geometry geometry = (Geometry)it.next();
            if (!buffer.contains(geometry)) continue;
            result.add(geometry);
        }
        if (result.size() == 1) {
            result.clear();
            result.add(geomSel);
        }
        return result;
    }

    public static List<Geometry> splitLines(Geometry digitizedGeometry, Geometry geomSel) {
        ArrayList linearNetwork = new ArrayList();
        linearNetwork.addAll(LinearComponentExtracter.getLines((Geometry)digitizedGeometry));
        linearNetwork.addAll(LinearComponentExtracter.getLines((Geometry)geomSel));
        Geometry nodedLinearNetwork = UnaryUnionOp.union(linearNetwork);
        Envelope env = geomSel.getEnvelopeInternal();
        double maxAbsX = Math.max(Math.abs(env.getMaxX()), Math.abs(env.getMinX()));
        double maxAbsY = Math.max(Math.abs(env.getMaxY()), Math.abs(env.getMinY()));
        Geometry buffer = geomSel.buffer(Math.ulp(Math.max(maxAbsX, maxAbsY)) * 10000.0);
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        for (int i = 0; i < nodedLinearNetwork.getNumGeometries(); ++i) {
            Geometry geometry = nodedLinearNetwork.getGeometryN(i);
            if (!buffer.contains(geometry)) continue;
            result.add(geometry);
        }
        return result;
    }

    public Layer getSelectedLayer() {
        Collection<Layer> editableLayers = this.getPanel().getLayerManager().getEditableLayers();
        if (editableLayers.isEmpty()) {
            return null;
        }
        return editableLayers.iterator().next();
    }

    public static EnableCheck createEnableCheck() {
        EnableCheck editSelCheck = EditingPanel.instanceOf().getEditSelectionLayerEnableCheck();
        return component -> {
            try {
                String strEditCheck = editSelCheck.check(component);
                if (strEditCheck != null) {
                    return strEditCheck;
                }
                Layer ly = CutFeaturesTool.getLayer(WorkbenchContext.getInstance().getLayerViewPanel());
                if (ly == null) {
                    return "Please select exactly one feature with a linestring or polygon geometry.";
                }
                if (!ly.getFMD().isInsertAllowed()) {
                    return "Layer must be insertable";
                }
                return null;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        };
    }

    @Override
    public boolean isUndoable() {
        Layer activeLayer = this.getPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next();
        Layer ly2Insert = this.getTargetLayer(activeLayer);
        return ly2Insert instanceof RedlineLayer;
    }

    private Layer getTargetLayer(Layer activeLayer) {
        if (!activeLayer.getFMD().isInsertAllowed()) {
            return EditingPanel.instanceOf().getCurrentLayer();
        }
        return activeLayer;
    }

    private static Layer getLayer(LayerViewPanel panel) {
        if (panel == null) {
            return null;
        }
        Collection<Layer> colLy = panel.getSelectionManager().getLayersWithSelectedItems();
        if (colLy.size() != 1) {
            return null;
        }
        Layer ly = colLy.iterator().next();
        if (ly.isEditable()) {
            if (!ly.getFMD().isGeometryAllowed(LineString.class) && !ly.getFMD().isGeometryAllowed(Polygon.class)) {
                return null;
            }
            if (!ly.getFMD().isInsertAllowed()) {
                Layer ly2Insert = EditingPanel.instanceOf().getCurrentLayer();
                if (ly2Insert != null && (ly2Insert.getFMD().isGeometryAllowed(LineString.class) || ly2Insert.getFMD().isGeometryAllowed(Polygon.class))) {
                    return ly;
                }
                return null;
            }
            return ly;
        }
        return null;
    }
}

