/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintManager;

public abstract class ConstrainedMultiClickTool
extends AbstractCursorTool {
    static final String lengthST = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.length");
    static final String angleST = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.angle");
    static final String degrees = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.degrees");
    protected List coordinates = new ArrayList();
    protected Coordinate tentativeCoordinate;
    protected boolean drawClosed = true;
    private ConstraintManager constraintManager;

    @Override
    public boolean isRightMouseButtonUsed() {
        return true;
    }

    public List getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    @Override
    public void cancelGesture() {
        super.cancelGesture();
        this.coordinates.clear();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            if (e.getClickCount() == 1) {
                this.tentativeCoordinate = this.doConstraint(e);
                this.redrawShape();
            }
            super.mouseReleased(e);
            if (this.isFinishingRelease(e)) {
                this.finishGesture();
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected Coordinate doConstraint(MouseEvent e) throws NoninvertibleTransformException {
        Coordinate retPt = this.snap(e.getPoint());
        retPt = this.constraintManager.constrain(this.getPanel(), this.getCoordinates(), retPt, e);
        return retPt;
    }

    protected void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.coordinates.isEmpty()) {
                return;
            }
            this.tentativeCoordinate = this.doConstraint(e);
            Coordinate startPt = (Coordinate)this.coordinates.get(this.coordinates.size() - 1);
            double length = startPt.distance(this.tentativeCoordinate);
            double angle = this.constraintManager.getBearing(startPt, this.tentativeCoordinate);
            DecimalFormat df2 = new DecimalFormat("##0.0#");
            DecimalFormat df3 = new DecimalFormat("###,###,##0.0##");
            this.getPanel().getContext().setStatusMessage(lengthST + ": " + df3.format(length) + ";  " + angleST + ": " + df2.format(angle) + " " + degrees);
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    protected void add(Coordinate c) {
        this.coordinates.add(c);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            super.mousePressed(e);
            Assert.isTrue((e.getClickCount() > 0 ? 1 : 0) != 0);
            if (e.getClickCount() != 1) {
                return;
            }
            this.add(this.doConstraint(e));
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        Point2D firstPoint = this.getPanel().getViewport().toViewPoint((Coordinate)this.coordinates.get(0));
        GeneralPath path = new GeneralPath();
        path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
        for (int i = 1; i < this.coordinates.size(); ++i) {
            Coordinate nextCoordinate = (Coordinate)this.coordinates.get(i);
            Point2D nextPoint = this.getPanel().getViewport().toViewPoint(nextCoordinate);
            path.lineTo((int)nextPoint.getX(), (int)nextPoint.getY());
        }
        Point2D tentativePoint = this.getPanel().getViewport().toViewPoint(this.tentativeCoordinate);
        path.lineTo((int)tentativePoint.getX(), (int)tentativePoint.getY());
        if (this.drawClosed) {
            path.lineTo((float)firstPoint.getX(), (float)firstPoint.getY());
        }
        return path;
    }

    protected boolean isFinishingRelease(MouseEvent e) {
        return e.getClickCount() == 2 || e.getButton() == 3;
    }

    protected Coordinate[] toArray(List coordinates) {
        return coordinates.toArray(new Coordinate[0]);
    }

    protected void finishGesture() throws Exception {
        this.clearShape();
        try {
            this.fireGestureFinished();
        }
        finally {
            this.coordinates.clear();
        }
    }

    protected Coordinate getIntersection(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate p4) {
        Coordinate e = new Coordinate(0.0, 0.0);
        Coordinate v = new Coordinate(0.0, 0.0);
        Coordinate w = new Coordinate(0.0, 0.0);
        double t1 = 0.0;
        double n = 0.0;
        double d = 0.0;
        v.x = p2.x - p1.x;
        v.y = p2.y - p1.y;
        w.x = p4.x - p3.x;
        w.y = p4.y - p3.y;
        n = w.y * (p3.x - p1.x) - w.x * (p3.y - p1.y);
        d = w.y * v.x - w.x * v.y;
        if (d != 0.0) {
            t1 = n / d;
            e.x = p1.x + v.x * t1;
            e.y = p1.y + v.y * t1;
        } else {
            e.z = 999.0;
        }
        return e;
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        this.constraintManager = new ConstraintManager(JUMPWorkbench.getContext());
    }
}

