/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import de.riwagis.icons.IconLoader;
import java.awt.Cursor;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;

public class AutoCompletePolygonCursorTool
extends PolygonTool {
    static final String sAutoComplete = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.AutoCompletePolygonCursorTool.Auto-Complete-Polygon");
    static final String sCanNotAdd = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.AutoCompletePolygonCursorTool.Can-not-add-polygon");
    private final GeometryEditor geometryEditor = new GeometryEditor();

    public AutoCompletePolygonCursorTool() {
        this.allowSnapping();
    }

    @Override
    public JPanel getAssistentPanel() {
        DescriptionPanel.instanceOf().resetPanel();
        DescriptionPanel.instanceOf().setAssistentName(this.getName());
        DescriptionPanel.instanceOf().setDescription(I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.AutoCompletePolygonCursorTool.description"));
        return DescriptionPanel.instanceOf();
    }

    @Override
    public String getName() {
        return sAutoComplete;
    }

    @Override
    protected void gestureFinished() throws Exception {
        Geometry newGeo;
        if (!this.checkPolygon()) {
            return;
        }
        Polygon poly = this.getPolygon();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        Layer[] selectedLayers = WorkbenchContext.getInstance().getLayerNamePanel().getSelectedLayers();
        if (selectedLayers == null || selectedLayers.length == 0) {
            selectedLayers = new Layer[]{EditingPanel.instanceOf().getCurrentLayer()};
        }
        for (Layer actualLayer : selectedLayers) {
            try (FeatureIterator<SimpleFeature> fi = actualLayer.getFeatureIterator(poly.getEnvelopeInternal());){
                while (fi.hasNext()) {
                    SimpleFeature element = (SimpleFeature)fi.next();
                    Geometry fgeom = (Geometry)element.getDefaultGeometry();
                    if (fgeom == null) continue;
                    geometries.addAll(this.geometryEditor.flatten(fgeom));
                }
            }
        }
        Geometry diffGeo = newGeo = poly.getGeometryN(0);
        try {
            for (Geometry geom : geometries) {
                diffGeo = diffGeo.difference(geom);
            }
            if (diffGeo instanceof Polygon) {
                this.createPolygon((Polygon)diffGeo);
            } else if (diffGeo instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)diffGeo;
                for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                    this.createPolygon((Polygon)multiPolygon.getGeometryN(i));
                }
            }
        }
        catch (Exception e) {
            this.getPanel().getContext().warnUser(sCanNotAdd + " " + String.valueOf(e));
        }
    }

    private void createPolygon(Polygon geometryN) {
        FeatureDrawingUtil.drawRing(geometryN, this.isRollingBackInvalidEdits(), this, this.getPanel());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_auto_complete.svg");
    }

    @Override
    public Cursor getCursor() {
        return FeatureDrawingUtil.createEditCursor();
    }

    public static EnableCheck createEnableCheck() {
        return EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{Polygon.class});
    }
}

