/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit.helpclassesselection;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.jts.JTSSupport;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public class SelectItemsByCircleTool
extends DragTool {
    private Shape selectedFeaturesShape;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final List verticesToSnap = null;
    private PlugInContext context = null;
    private double diameter = 0.0;
    private Point mp = null;

    public SelectItemsByCircleTool(PlugInContext context, double diameter, Coordinate initCoo) {
        this.context = context;
        this.diameter = diameter;
        this.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f));
        this.allowSnapping();
        this.calcuateCircle(initCoo);
    }

    @Override
    protected void gestureFinished() throws Exception {
    }

    @Override
    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.edit.helpclassesselection.SelectItemsByCircleTool.name");
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon((String)"");
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            this.setViewDestination(e.getPoint());
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            Point p;
            if (!this.checkMouseButton(e)) {
                return;
            }
            this.mp = p = new GeometryFactory().createPoint(this.getModelDestination());
            Geometry circle = p.buffer(this.diameter);
            this.selectItems(circle);
            this.fireGestureFinished();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected Shape getShape() throws Exception {
        this.calcuateCircle(this.modelDestination);
        return this.selectedFeaturesShape;
    }

    @Override
    protected void setModelDestination(Coordinate modelDestination) {
        this.modelDestination = modelDestination;
    }

    private void calcuateCircle(Coordinate middlePoint) {
        Point p;
        this.mp = p = new GeometryFactory().createPoint(middlePoint);
        Geometry buffer = p.buffer(this.diameter);
        Geometry[] geomArray = new Geometry[]{buffer};
        GeometryCollection gc = this.geometryFactory.createGeometryCollection(geomArray);
        try {
            this.selectedFeaturesShape = this.context.getLayerViewPanel().getJava2DConverter().toShape((Geometry)gc);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println("SelectItemsByCircleTool:Exception " + String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectItems(Geometry circle) {
        int count = 0;
        Layer[] selectedLayers = this.context.getLayerNamePanel().getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            Layer actualLayer = selectedLayers[i];
            FeatureIterator<SimpleFeature> fi = null;
            try {
                fi = this.context.getSelectedLayer(i).getFeatureIterator(circle.getEnvelopeInternal());
            }
            catch (Exception e) {
                Assert.shouldNeverReachHere((String)e.getMessage());
            }
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            try {
                block6: while (fi.hasNext()) {
                    Geometry[] arrGeom;
                    SimpleFeature element = (SimpleFeature)fi.next();
                    Geometry fgeom = (Geometry)element.getDefaultGeometry();
                    for (Geometry g : arrGeom = JTSSupport.getGeometries((Geometry)fgeom)) {
                        if (g == null || circle.disjoint(g)) continue;
                        features.add(element);
                        ++count;
                        continue block6;
                    }
                }
            }
            finally {
                fi.close();
            }
            this.context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(actualLayer, features);
        }
    }
}

