/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit.helpclassesselection;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.jts.JTSSupport;
import java.util.ArrayList;
import javax.swing.Icon;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.openjump.core.ui.plugin.edit.helpclassesselection.FenceDrawingUtil;

public class DrawFenceTool
extends PolygonTool {
    private final PlugInContext context;

    protected DrawFenceTool(PlugInContext context) {
        this.context = context;
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy, PlugInContext context) {
        FenceDrawingUtil fDUtil = new FenceDrawingUtil(layerNamePanelProxy);
        return fDUtil.prepare(new DrawFenceTool(context), false);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon((String)"");
    }

    @Override
    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.edit.helpclassesselection.DrawFenceTool.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void gestureFinished() throws Exception {
        if (!this.checkPolygon()) {
            return;
        }
        int count = 0;
        Layer[] selectedLayers = this.context.getLayerNamePanel().getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            Layer actualLayer = selectedLayers[i];
            FeatureIterator<SimpleFeature> fi = null;
            try {
                fi = this.context.getSelectedLayer(i).getFeatureIterator(this.getPolygon().getEnvelopeInternal());
            }
            catch (Exception e) {
                Assert.shouldNeverReachHere((String)e.getMessage());
            }
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            try {
                block6: while (fi.hasNext()) {
                    Geometry[] arrGeom;
                    SimpleFeature element = (SimpleFeature)fi.next();
                    Geometry fgeom = (Geometry)element.getDefaultGeometry();
                    for (Geometry g : arrGeom = JTSSupport.getGeometries((Geometry)fgeom)) {
                        if (g == null || this.getPolygon().disjoint(g)) continue;
                        features.add(element);
                        ++count;
                        continue block6;
                    }
                }
            }
            finally {
                fi.close();
            }
            this.context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(actualLayer, features);
        }
    }
}

