/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.selection.AbstractSelection;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;

public class SelectByTypePlugIn
extends AbstractPlugIn {
    private boolean selectEmpty = false;
    private boolean selectPoint = false;
    private boolean selectMultiPoint = false;
    private boolean selectLineString = false;
    private boolean selectLinearRing = false;
    private boolean selectMultiLineString = false;
    private boolean selectPolygon = false;
    private boolean selectMultiPolygon = false;
    private boolean selectGeometryCollection = false;
    private boolean selectedLayersOnly = true;
    private AbstractSelection selection;
    private static final String sSelectByGeometryType = I18N.get("org.openjump.core.ui.plugin.edit.SelectByTypePlugIn.Select-by-Geometry-Type");
    private static final String sSelectOnlyTheseTypes = I18N.get("org.openjump.core.ui.plugin.edit.SelectByTypePlugIn.Select-only-these-types");
    private static final String sEmptyGeometries = I18N.get("org.openjump.core.ui.plugin.edit.SelectByTypePlugIn.Empty-Geometries");
    private static final String sOnSelectedLayersOnly = I18N.get("org.openjump.core.ui.plugin.edit.SelectByTypePlugIn.On-selected-layers-only");

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), sSelectByGeometryType, true);
        this.setDialogValues(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        WaitDialog dlgWait = new WaitDialog((Window)WorkbenchContext.getFrame(), I18N.get("common.wait"));
        dlgWait.addWorkToDo(() -> this.doSeletionAsync(context, dlgWait));
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Throwable)dlgWait.getError(), (String)"riwagis");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSeletionAsync(PlugInContext context, WaitDialog dlgWait) {
        try {
            LayerNamePanel layerNamePanel = context.getWorkbenchContext().getLayerNamePanel();
            LayerViewPanel layerViewPanel = context.getWorkbenchContext().getLayerViewPanel();
            Envelope env = layerViewPanel.getViewport().getEnvelopeInModelCoordinates();
            layerViewPanel.getSelectionManager().clear();
            Collection<Layer> layers = this.selectedLayersOnly ? layerNamePanel.selectedNodes(Layer.class) : layerNamePanel.getLayerManager().getLayers();
            int layersProcessed = 1;
            for (Layer layer : layers) {
                dlgWait.setMessage(I18N.getMessage("org.openjump.core.ui.plugin.edit.SelectByTypePlugIn.select-progress", layersProcessed++, layers.size()));
                if (!layer.isVisibleOnScreen()) continue;
                ArrayList<SimpleFeature> selectedFeatures = new ArrayList<SimpleFeature>();
                try (FeatureIterator<SimpleFeature> fi = layer.getLastFeatureIterator(env);){
                    while (fi.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)fi.next();
                        if (!this.selectFeature(feature)) continue;
                        selectedFeatures.add(feature);
                    }
                }
                if (selectedFeatures.isEmpty()) continue;
                layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(layer, selectedFeatures);
            }
        }
        catch (Exception e) {
            dlgWait.setError(e);
        }
    }

    private boolean selectFeature(SimpleFeature feature) {
        Geometry geo = (Geometry)feature.getDefaultGeometry();
        if (geo.isEmpty() && this.selectEmpty) {
            return true;
        }
        if (geo instanceof Point && this.selectPoint) {
            return true;
        }
        if (geo instanceof MultiPoint && this.selectMultiPoint) {
            return true;
        }
        if (geo instanceof LineString && this.selectLineString) {
            return true;
        }
        if (geo instanceof LinearRing && this.selectLinearRing) {
            return true;
        }
        if (geo instanceof MultiLineString && this.selectMultiLineString) {
            return true;
        }
        if (geo instanceof Polygon && this.selectPolygon) {
            return true;
        }
        if (geo instanceof MultiPolygon && this.selectMultiPolygon) {
            return true;
        }
        return geo instanceof GeometryCollection && this.selectGeometryCollection;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addLabel(sSelectOnlyTheseTypes);
        dialog.addCheckBox(sEmptyGeometries, this.selectEmpty);
        dialog.addCheckBox("Point", this.selectPoint);
        dialog.addCheckBox("MultiPoint", this.selectMultiPoint);
        dialog.addCheckBox("LineString", this.selectLineString);
        dialog.addCheckBox("LinearRing", this.selectLinearRing);
        dialog.addCheckBox("MultiLineString", this.selectMultiLineString);
        dialog.addCheckBox("Polygon", this.selectPolygon);
        dialog.addCheckBox("MultiPolygon", this.selectMultiPolygon);
        dialog.addCheckBox("GeometryCollection", this.selectGeometryCollection);
        dialog.addCheckBox(sOnSelectedLayersOnly, this.selectedLayersOnly);
        dialog.pack();
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.selectEmpty = dialog.getCheckBox(sEmptyGeometries).isSelected();
        this.selectPoint = dialog.getCheckBox("Point").isSelected();
        this.selectMultiPoint = dialog.getCheckBox("MultiPoint").isSelected();
        this.selectLineString = dialog.getCheckBox("LineString").isSelected();
        this.selectLinearRing = dialog.getCheckBox("LinearRing").isSelected();
        this.selectMultiLineString = dialog.getCheckBox("MultiLineString").isSelected();
        this.selectPolygon = dialog.getCheckBox("Polygon").isSelected();
        this.selectMultiPolygon = dialog.getCheckBox("MultiPolygon").isSelected();
        this.selectGeometryCollection = dialog.getCheckBox("GeometryCollection").isSelected();
        this.selectedLayersOnly = dialog.getCheckBox(sOnSelectedLayersOnly).isSelected();
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNSelectableLayersMustExistCheck(1));
    }
}

