/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.dem;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.Icon;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.openjump.core.ui.plugin.dem.DEMProfileGraphTool;

public class DEMQueryCursorTool
extends NClickTool {
    private final String VALUE = I18N.get("org.openjump.core.ui.plugin.dem.DEMQueryPlugIn.value");
    private final String RASTER_QUERY = I18N.get("org.openjump.core.ui.plugin.dem.DEMQueryPlugIn");
    private GridCoverage2D coverage2D = null;
    public ViewportListener viewportListener = vPort -> this.createDEMCoverage();

    public void createDEMCoverage() {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(() -> {
            try {
                this.coverage2D = DEMProfileGraphTool.createDEMCoverage(this.getPanel().getLayerManager().getTask(), (Geometry)JTS.toGeometry((Envelope)this.getPanel().getViewport().getEnvelopeInModelCoordinates()));
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(100L);
        if (dlgWait.getError() != null) {
            WorkbenchContext.getErrorHandler().handleThrowable(dlgWait.getError());
            WorkbenchContext.getFrame().activateDefaultCT();
        }
    }

    public DEMQueryCursorTool() {
        super(1);
        this.allowSnapping();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"show_grid_info.svg");
    }

    @Override
    public Cursor createCursor() {
        return DEMQueryCursorTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_info.svg").getImage());
    }

    @Override
    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.dem.DEMQueryPlugIn");
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        this.getPanel().getViewport().addListener(this.viewportListener);
        this.createDEMCoverage();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.getPanel().getViewport().removeListener(this.viewportListener);
        this.coverage2D = null;
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.coverage2D == null) {
            this.getPanel().getContext().warnUser(I18N.get("org.openjump.core.ui.plugin.dem.DEMQueryPlugIn.query-outside-raster"));
            return;
        }
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(() -> {
            try {
                ReferencedEnvelope envelope;
                Coordinate coord = this.getCoordinates().get(0);
                ReferencedEnvelope referencedEnvelope = envelope = this.coverage2D.getEnvelope() == null ? null : new ReferencedEnvelope(this.coverage2D.getEnvelope());
                if (envelope == null || envelope.isNull() || this.getPoint().within((Geometry)JTS.toGeometry((Envelope)envelope))) {
                    String heightString;
                    float[] pixelValues = this.coverage2D.evaluate((Point2D)new Point2D.Double(coord.x, coord.y), (float[])null);
                    float height = pixelValues[0];
                    if (DEMProfileGraphTool.isNoDataValue(this.coverage2D, height)) {
                        heightString = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.nodata");
                    } else {
                        Layerable ly;
                        String pattern = "##0.##";
                        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance();
                        df.applyPattern(pattern);
                        Point point = new GeometryFactory().createPoint(new Coordinate(coord.x, coord.y, (double)height));
                        heightString = df.format(height);
                        WorkbenchContext context = WorkbenchContext.getInstance();
                        RedlineLayer profileLayer = null;
                        if (context.getLayerManager().hasLayerable(this.RASTER_QUERY) && (ly = context.getLayerManager().getLayerableByKey(this.RASTER_QUERY)) instanceof RedlineLayer) {
                            profileLayer = (RedlineLayer)ly;
                        }
                        if (profileLayer == null) {
                            profileLayer = new RedlineLayer(this.RASTER_QUERY, context.getLayerManager());
                            context.getLayerManager().addLayer(StandardCategoryNames.REDLINE_LAYERS, profileLayer);
                        }
                        ArrayList<SimpleFeature> redlineFeatures = new ArrayList<SimpleFeature>();
                        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(RedlineLayer.REDLINE_FEATURE_TYPE);
                        sfb.set(CadFeatureAtts.SYMBOL.getName(), (Object)"cross.svg");
                        sfb.set(CadFeatureAtts.SYMSIZE.getName(), (Object)10);
                        sfb.set(CadFeatureAtts.GEOM.getName(), (Object)point);
                        redlineFeatures.add(sfb.buildFeature(null));
                        sfb.set(CadFeatureAtts.GEOM.getName(), (Object)point);
                        sfb.set(CadFeatureAtts.TEXT.getName(), (Object)heightString);
                        redlineFeatures.add(sfb.buildFeature(null));
                        profileLayer.editFeature(redlineFeatures, 1);
                    }
                    this.getPanel().getContext().setStatusMessage("(" + this.coverage2D.getName().toString() + ") " + this.VALUE + ": " + heightString);
                    this.getPanel().setViewportInitialized(true);
                } else {
                    this.getPanel().getContext().warnUser(I18N.get("org.openjump.core.ui.plugin.dem.DEMQueryPlugIn.query-outside-raster"));
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(100L);
        if (dlgWait.getError() != null) {
            WorkbenchContext.getErrorHandler().handleThrowable(dlgWait.getError());
        }
    }

    protected Point getPoint() {
        return new GeometryFactory().createPoint(this.getCoordinates().get(0));
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        block8: {
            if (this.coverage2D == null) {
                this.getPanel().getContext().warnUser(I18N.get("org.openjump.core.ui.plugin.dem.DEMQueryPlugIn.query-outside-raster"));
                return;
            }
            try {
                ReferencedEnvelope envelope;
                super.mouseMoved(me);
                Coordinate coord = this.snap(me.getPoint());
                String heightString = null;
                ReferencedEnvelope referencedEnvelope = envelope = this.coverage2D.getEnvelope() == null ? null : new ReferencedEnvelope(this.coverage2D.getEnvelope());
                if (envelope == null || envelope.isNull() || envelope.contains(coord)) {
                    try {
                        float[] pixelValues = this.coverage2D.evaluate((Point2D)new Point2D.Double(coord.x, coord.y), (float[])null);
                        float height = pixelValues[0];
                        if (DEMProfileGraphTool.isNoDataValue(this.coverage2D, height)) {
                            heightString = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.nodata");
                        } else {
                            String pattern = "##0.##";
                            DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance();
                            df.applyPattern(pattern);
                            heightString = df.format(height);
                        }
                    }
                    catch (Exception ex) {
                        heightString = I18N.get("common.error");
                    }
                    this.getPanel().getContext().setStatusMessage("(" + this.coverage2D.getName().toString() + ") " + this.VALUE + ": " + heightString);
                    break block8;
                }
                this.getPanel().getContext().warnUser(I18N.get("org.openjump.core.ui.plugin.dem.DEMQueryPlugIn.query-outside-raster"));
            }
            catch (Exception e) {
                WorkbenchContext.getFrame().warnUser(e.getLocalizedMessage());
            }
        }
    }
}

