/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.dem;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.task.PrintLayerView;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.components.ButtonPanel;
import com.vividsolutions.jump.workbench.ui.components.HTMLPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.renderer.WMTSLayerRenderer;
import com.vividsolutions.ows.wmts.TileMatrix;
import com.vividsolutions.ows.wmts.TileMatrixSet;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.geotools.envelope.EnvelopeUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.WMTSStyleModel;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.construction.ConstSupport;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.math.plot.plots.Plot;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.openjump.core.ui.plot.Plot2DPanelOJ;
import org.openjump.core.ui.plugin.dem.DEMLayer;
import org.openjump.core.ui.plugin.dem.DEMLayerRenderer;

public class DEMProfileGraphTool
extends MultiClickTool {
    private static final String sDistance = I18N.get("org.openjump.core.ui.plugin.tools.MeasureM_FTool.Distance");
    private static final String LAYER_NAME = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.layer_name");
    private static final String MIN = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.min");
    private static final String MEAN = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.mean");
    private static final String MAX = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.max");
    private static final String SUM = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.sum");
    private static final String INFO = I18N.get("ui.AboutDialog.info");
    private static final String CELL_SIZE = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.dimension_cell");
    private static final String PLOT = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.Profile-Plot");
    private static final String PROFILEPTS = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.profile-pts");
    private static final String CELL_STAT = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.cell-statistics");
    private static final String PROFILE = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.Profile");
    private static final String PROFILE_INFO = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.Profile-info");
    private static final String PROFILE_LENGTH = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.Profile-length");
    private static final String STARTING_POINT = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.starting-point");
    private static final String ENDING_POINT = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.ending-point");
    private static final String MEAN_SLOPE = I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.mean-slope");
    private static final String CREATE_PROFILE_FEATURE_KEY = "org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.create-profile-feature";
    private Coordinate currCoord;
    private final GeometryFactory gf = new GeometryFactory();
    private SimpleFeatureType resultFSchema = null;
    private double dDist = 0.0;
    private double dHorzDist = 0.0;
    private double m_dLastX;
    private double m_dLastY;
    private double m_dLastZ;
    private int nPoints = 0;
    private static JDialog dialog = null;

    public DEMProfileGraphTool() {
        this.allowSnapping();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"show_profile.svg");
    }

    @Override
    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphPlugIn.Profile-Graph");
    }

    @Override
    public Cursor createCursor() {
        return DEMProfileGraphTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_profile.svg").getImage());
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.isShapeOnScreen()) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
                currentCoordinates.add(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
                this.display(currentCoordinates, this.getPanel());
            }
            this.currCoord = this.snap(e.getPoint());
            super.mouseLocationChanged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected void gestureFinished() {
        this.display(this.getCoordinates(), this.getPanel());
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)dialog, (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(() -> {
            try {
                LineString line;
                if (this.getTaskFrame().getTask().isProjectionReductionActive()) {
                    ArrayList<Coordinate> convertedCoords = new ArrayList<Coordinate>();
                    CRSDefinition crsDef = this.getTaskFrame().getTask().getCRSDefinition();
                    DrawingUnit unit = this.getTaskFrame().getTask().getDrawingUnit();
                    double height = this.getTaskFrame().getTask().getHeightReduction();
                    Coordinate[] coords = DEMProfileGraphTool.toArray(this.getCoordinates());
                    convertedCoords.add(coords[0]);
                    for (int i = 1; i < coords.length; ++i) {
                        Coordinate coord1 = coords[i - 1];
                        Coordinate coord2 = coords[i];
                        Coordinate coordCenter = CoordUtil.average(coord1, coord2);
                        double dist = coord1.distance(coord2);
                        double distanceConverted = crsDef.getRealWorldDistance(dist, height, coordCenter, unit);
                        double t = ConstSupport.getOrientation((Coordinate)coord1, (Coordinate)coord2, (int)2);
                        Coordinate coordTmp = ConstSupport.getPolarCoord((Coordinate)coord1, (double)distanceConverted, (double)t);
                        convertedCoords.add(coordTmp);
                    }
                    line = this.gf.createLineString(MultiClickTool.toArray(convertedCoords));
                } else {
                    line = this.gf.createLineString(MultiClickTool.toArray(this.getCoordinates()));
                }
                GridCoverage2D coverage2D = DEMProfileGraphTool.createDEMCoverage(this.getTaskFrame().getTask(), (Geometry)line);
                if (this.resultFSchema == null) {
                    SimpleFeatureTypeBuilder sftp = new SimpleFeatureTypeBuilder();
                    sftp.setName("profilegraph");
                    sftp.add("geom", Geometry.class, coverage2D.getCoordinateReferenceSystem());
                    sftp.add("id", Long.class);
                    sftp.add("x", Double.class);
                    sftp.add("y", Double.class);
                    sftp.add("z", Double.class);
                    sftp.add("plane-dist", Double.class);
                    sftp.add("terrain-dist", Double.class);
                    sftp.add("cornerpoint", Boolean.class);
                    this.resultFSchema = sftp.buildFeatureType();
                }
                if (dlgWait.isCanceled()) {
                    return;
                }
                this.nPoints = 0;
                this.calculateProfile(coverage2D, line, JUMPWorkbench.getContext());
                coverage2D.dispose(true);
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(100L);
        if (dlgWait.getError() != null) {
            WorkbenchContext.getErrorHandler().handleThrowable(dlgWait.getError());
        }
    }

    public static GridCoverage2D createDEMCoverage(Task task, Geometry geom) throws Exception {
        Object demObject;
        GridCoverage2D coverage2D = null;
        CRSDefinition crsDefTask = task.getCRSDefinition();
        CoordinateReferenceSystem crsTask = null;
        if (crsDefTask != null) {
            crsTask = crsDefTask.getCRS();
        }
        if (!((demObject = task.getBlackboard().get("DEM")) instanceof WMTSStyleModel)) {
            throw new IllegalArgumentException("dem not set or type not supported");
        }
        WMTSStyleModel wmtsStyleModel = (WMTSStyleModel)demObject;
        Task demTask = new Task();
        LayerManager layerManager = demTask.getLayerManager();
        DEMLayer demLayer = new DEMLayer("wmts", layerManager, wmtsStyleModel);
        demLayer.setKey("wmts");
        layerManager.addLayerable("dummy", (Layerable)demLayer);
        PrintLayerView printLayerView = new PrintLayerView(layerManager);
        demTask.getBlackboard().put("CRS", CRSDefFactory.getKey((CRSDefinition)crsDefTask));
        double taskScaleDenom = task.getScale();
        TileMatrixSet tms = demLayer.getTileMatrixSet();
        TileMatrix tm = WMTSLayerRenderer.findBestMatchingTileMatrix(tms, taskScaleDenom);
        CoordinateReferenceSystem targetCRS = CRSDefFactory.createCRS((String)tms.getSupportedCRS());
        double tileSpanX = tm.computeTileSpanX();
        double tileSpanY = tm.computeTileSpanY();
        if (targetCRS instanceof GeographicCRS) {
            double degreeToMeters = 111319.49079327358;
            tileSpanX /= degreeToMeters;
            tileSpanY /= degreeToMeters;
        }
        double mpp = tileSpanX / (double)tm.getTileWidth();
        double length = geom.getLength();
        if (length / mpp > 100000.0) {
            throw new Exception(I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.error-to-many-points"));
        }
        org.locationtech.jts.geom.Envelope envelope = geom.getEnvelopeInternal();
        envelope.expandBy(mpp);
        EnvelopeUtil.roundEnvelope((org.locationtech.jts.geom.Envelope)envelope, (double)mpp);
        if (StringUtils.isNotEmpty((CharSequence)tm.getTopLeftCorner())) {
            double fixX1 = (envelope.getMinX() - tm.getTopLeft()[0]) % mpp;
            double fixX2 = (envelope.getMaxX() - tm.getTopLeft()[0]) % mpp;
            double fixY1 = (envelope.getMinY() - tm.getTopLeft()[1]) % mpp;
            double fixY2 = (envelope.getMaxY() - tm.getTopLeft()[1]) % mpp;
            envelope.init(envelope.getMinX() - fixX1, envelope.getMaxX() - fixX2, envelope.getMinY() - fixY1, envelope.getMaxY() - fixY2);
        }
        double allowedArea = tileSpanX * tileSpanY * 50.0;
        double requestedArea = Math.max(envelope.getWidth(), tileSpanX) * Math.max(envelope.getHeight(), tileSpanY);
        if (requestedArea > allowedArea) {
            throw new Exception(I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.error-area-to-large"));
        }
        double widthInPixel = envelope.getWidth() / mpp;
        double heightInPixel = envelope.getHeight() / mpp;
        double vpScale = widthInPixel / envelope.getWidth();
        printLayerView.setSize((int)Math.max(1L, Math.round(widthInPixel)), (int)Math.max(1L, Math.round(heightInPixel)));
        printLayerView.getViewport().initialize(vpScale, new Point2D.Double((envelope.getMinX() + envelope.getMaxX()) * 0.5, (envelope.getMinY() + envelope.getMaxY()) * 0.5));
        printLayerView.getViewport().update();
        BufferedImage bi = DEMProfileGraphTool.createBufferedImage(printLayerView.getWidth(), printLayerView.getHeight());
        DEMLayerRenderer layerRenderer = new DEMLayerRenderer(demLayer, printLayerView, printLayerView, bi);
        layerRenderer.createRunnable().run();
        ReferencedEnvelope env = new ReferencedEnvelope(envelope, crsTask);
        GridCoverageFactory factory = new GridCoverageFactory();
        coverage2D = factory.create((CharSequence)tm.getIdentifier(), (RenderedImage)bi, (Envelope)env);
        return coverage2D;
    }

    public static BufferedImage createBufferedImage(int width, int height) {
        ColorSpace linearRGB = ColorSpace.getInstance(1003);
        ComponentColorModel cm = new ComponentColorModel(linearRGB, new int[]{32}, false, false, 1, 4);
        WritableRaster wr = ((ColorModel)cm).createCompatibleWritableRaster(width, height);
        for (int w = 0; w < width; ++w) {
            for (int h = 0; h < height; ++h) {
                wr.setPixel(w, h, new float[]{0.0f});
            }
        }
        return new BufferedImage(cm, wr, true, null);
    }

    private void display(List<Coordinate> coordinates, LayerViewPanel panel) {
        this.display(this.distance(coordinates), panel);
    }

    private void display(double distance, LayerViewPanel panel) {
        panel.getContext().setStatusMessage(sDistance + ": " + panel.format(distance) + " " + WorkbenchContext.getTask().getDrawingUnit().getUnitName());
    }

    private double distance(List<Coordinate> coordinates) {
        double distance = 0.0;
        Task task = this.getTaskFrame().getTask();
        if (task.isProjectionReductionActive()) {
            CRSDefinition crsDef = task.getCRSDefinition();
            DrawingUnit unit = task.getDrawingUnit();
            double height = task.getHeightReduction();
            for (int i = 1; i < coordinates.size(); ++i) {
                Coordinate coord1 = coordinates.get(i - 1);
                Coordinate coord2 = coordinates.get(i);
                Coordinate coordCenter = CoordUtil.average(coord1, coord2);
                double dist = coord1.distance(coord2);
                double distanceConverted = crsDef.getRealWorldDistance(dist, height, coordCenter, unit);
                distance += distanceConverted;
            }
            return distance;
        }
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += coordinates.get(i - 1).distance(coordinates.get(i));
        }
        if (this.currCoord != null && coordinates.size() > 1) {
            distance -= coordinates.get(coordinates.size() - 2).distance(coordinates.get(coordinates.size() - 1));
            distance += coordinates.get(coordinates.size() - 2).distance(this.currCoord);
        }
        return distance;
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setCbo1LabelListener(I18N.get(CREATE_PROFILE_FEATURE_KEY), e -> PersistentBlackboardPlugIn.get().put(CREATE_PROFILE_FEATURE_KEY, valPanel.getCbo1Value()));
        valPanel.setCbo1Value(PersistentBlackboardPlugIn.get().get(CREATE_PROFILE_FEATURE_KEY, true));
        valPanel.setLeftButton(I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.use-selected-line"), e -> {
            try {
                this.resetCoordinates();
                Collection<Geometry> geometries = this.getPanel().getSelectionManager().getSelectedItems();
                if (geometries != null && geometries.size() == 1) {
                    Geometry geom = geometries.iterator().next();
                    if (!(geom instanceof LineString)) {
                        GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.Exactly-one-line-must-be-selected"), (String)I18N.get("common.error"));
                    }
                    for (Coordinate c : geom.getCoordinates()) {
                        this.add(c);
                    }
                    this.finishGesture();
                } else {
                    GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.Exactly-one-line-must-be-selected"), (String)I18N.get("common.error"));
                }
            }
            catch (Throwable t) {
                this.getPanel().getContext().handleThrowable(t);
            }
        });
        return valPanel;
    }

    private void calculateProfile(GridCoverage2D coverage2D, LineString line, WorkbenchContext context) throws Exception {
        ReferencedEnvelope envelope;
        if (dialog == null) {
            dialog = new JDialog(JUMPWorkbench.getFrame(), PLOT, false);
            dialog.setIconImage(JUMPWorkbench.getFrame().getIconImage());
            dialog.setResizable(true);
            dialog.setSize(800, 450);
            dialog.setDefaultCloseOperation(2);
            dialog.addWindowListener(new WindowAdapter(this){

                @Override
                public void windowClosing(WindowEvent e) {
                    dialog = null;
                }
            });
            dialog.setLocationRelativeTo(this.getTaskFrame());
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(true);
        ReferencedEnvelope referencedEnvelope = envelope = coverage2D.getEnvelope() == null ? null : new ReferencedEnvelope(coverage2D.getEnvelope());
        if (envelope == null || envelope.isNull() || line.within((Geometry)JTS.toGeometry((org.locationtech.jts.geom.Envelope)envelope))) {
            List<SimpleFeature> lstResults = this.processLine(coverage2D, (Geometry)line);
            SimpleFeatureCollection resultFC = DataUtilities.collection(lstResults);
            String pattern = "##0.##";
            DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance();
            df.applyPattern(pattern);
            if (GetValuePanel.instanceOf().getCbo1Value()) {
                Layerable ly;
                RedlineLayer profileLayer = null;
                if (context.getLayerManager().hasLayerable(PROFILE) && (ly = context.getLayerManager().getLayerableByKey(PROFILE)) instanceof RedlineLayer) {
                    profileLayer = (RedlineLayer)ly;
                }
                if (profileLayer == null) {
                    profileLayer = new RedlineLayer(PROFILE, context.getLayerManager());
                    context.getLayerManager().addLayer(StandardCategoryNames.REDLINE_LAYERS, profileLayer);
                }
                SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(RedlineLayer.REDLINE_FEATURE_TYPE);
                sfb.set(CadFeatureAtts.GEOM.getName(), (Object)line);
                ArrayList<SimpleFeature> redlineFeatures = new ArrayList<SimpleFeature>();
                redlineFeatures.add(sfb.buildFeature(null));
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
                SimpleFeatureCollection fc2 = resultFC.subCollection((Filter)ff.equals((Expression)ff.property("cornerpoint"), (Expression)ff.literal(true)));
                try (SimpleFeatureIterator iter = fc2.features();){
                    while (iter.hasNext()) {
                        SimpleFeature f = (SimpleFeature)iter.next();
                        sfb.set(CadFeatureAtts.GEOM.getName(), f.getDefaultGeometry());
                        sfb.set(CadFeatureAtts.TEXT.getName(), (Object)df.format(f.getAttribute("z")));
                        redlineFeatures.add(sfb.buildFeature(null));
                    }
                }
                profileLayer.editFeature(redlineFeatures, 1);
            }
            HTMLPanel outpanel = new HTMLPanel();
            outpanel.showNavigationControls(false);
            Coordinate end = line.getEndPoint().getCoordinate();
            Coordinate start = line.getStartPoint().getCoordinate();
            double max = Double.NaN;
            double min = Double.NaN;
            double sum = 0.0;
            SimpleFeatureIterator iter = resultFC.features();
            while (iter.hasNext()) {
                SimpleFeature feat = (SimpleFeature)iter.next();
                double z = (Double)feat.getAttribute("z");
                if (Double.isNaN(max) || z > max) {
                    max = z;
                }
                if (Double.isNaN(min) || z < min) {
                    min = z;
                }
                sum += z;
            }
            iter.close();
            double mean = sum / (double)resultFC.size();
            double gradient_percent = (max - min) / line.getLength() * 100.0;
            StringBuilder sbHTML = new StringBuilder();
            sbHTML.append("<!DOCTYPE html>");
            sbHTML.append("<html><head><title>Page Title</title><meta charset='utf-8' /></head><body>");
            sbHTML.append("<div style='width: 500px; text-justification: justify;'>");
            sbHTML.append("<b><font style='font-size:+2'>").append(PROFILE_INFO).append("</font></b><br>");
            sbHTML.append("<br/>");
            sbHTML.append("<b><font style='font-size:+1'>").append(this.getName()).append(": </font></b>").append(coverage2D.getName().toString()).append("<br/>");
            sbHTML.append("<br/>");
            sbHTML.append("<b><font style='font-size:+1'>").append(PROFILE).append("</font></b><br/>");
            sbHTML.append("<b>").append(PROFILE_LENGTH).append(": </b>").append(df.format(line.getLength())).append("<br/>");
            sbHTML.append("<b>").append(MEAN_SLOPE).append(": </b>").append(df.format(gradient_percent)).append("%<br/>");
            sbHTML.append("<b>").append(STARTING_POINT).append(": </b>").append(df.format(start.x)).append(" - ").append(df.format(start.y)).append("<br>");
            sbHTML.append("<b>").append(ENDING_POINT).append(": </b>").append(df.format(end.x)).append(" - ").append(df.format(end.y)).append("<br>");
            sbHTML.append("<b>").append(CELL_SIZE).append(": </b>").append(df.format(coverage2D.getEnvelope2D().getWidth() / (double)coverage2D.getRenderedImage().getWidth())).append("<br>");
            sbHTML.append("<br/>");
            sbHTML.append("<b><font style='font-size:+1'>").append(CELL_STAT).append("</font></b><br>");
            sbHTML.append("<table  style='border: 1px solid gray'>");
            sbHTML.append("</td><td style='background-color:#CCCCCC' align='center'> ").append(MIN).append("</td><td style='background-color:#CCCCCC' align='center'> ").append(MAX).append("</td><td style='background-color:#CCCCCC' align='center'> ").append(MEAN).append("</td></tr>");
            sbHTML.append("</td><td align='right'>").append(df.format(min)).append("</td><td align='right'>").append(df.format(max)).append("</td><td align='right'>").append(df.format(mean)).append("</td></tr>");
            sbHTML.append("</table>");
            sbHTML.append("</div></body></html>");
            Plot2DPanelOJ plot = this.createPlotPanel(resultFC);
            ButtonPanel buttonPanel = new ButtonPanel(new String[]{I18N.get("common.close")});
            buttonPanel.addActionListener(e -> {
                dialog.setVisible(false);
                dialog.dispose();
                dialog = null;
            });
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add((Component)plot, PLOT);
            tabbedPane.add((Component)outpanel, INFO);
            panel.add((Component)tabbedPane, "Center");
            panel.add((Component)buttonPanel, "South");
            dialog.setContentPane(panel);
            SwingUtilities.invokeAndWait(() -> dialog.setVisible(true));
            SwingUtilities.invokeLater(() -> outpanel.createNewDocument(sbHTML.toString(), null));
        } else {
            this.getPanel().getContext().warnUser(I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.query-outside-raster"));
        }
    }

    private List<SimpleFeature> processLine(GridCoverage2D coverage2D, Geometry line) {
        Coordinate[] coords = line.getCoordinates();
        ArrayList<SimpleFeature> lstResults = new ArrayList<SimpleFeature>();
        for (int i = 0; i < coords.length - 1; ++i) {
            Coordinate c1 = coords[i];
            Coordinate c2 = coords[i + 1];
            List<SimpleFeature> segmentResults = this.processSegment(coverage2D, c1, c2);
            lstResults.addAll(segmentResults);
            c1.setZ(((Point)segmentResults.get(0).getDefaultGeometry()).getCoordinate().getZ());
        }
        Coordinate c = coords[coords.length - 1];
        SimpleFeature f = this.addPoint(coverage2D, c.x, c.y, true);
        lstResults.add(f);
        c.setZ(((Point)f.getDefaultGeometry()).getCoordinate().getZ());
        return lstResults;
    }

    private List<SimpleFeature> processSegment(GridCoverage2D coverage2D, Coordinate c1, Coordinate c2) {
        double x = c1.x;
        double y = c1.y;
        double x2 = c2.x;
        double y2 = c2.y;
        double dx = Math.abs(x2 - x);
        double dy = Math.abs(y2 - y);
        int widthInPixel = coverage2D.getRenderedImage().getWidth();
        int heightInPixel = coverage2D.getRenderedImage().getHeight();
        double cellSizeX = coverage2D.getEnvelope2D().getWidth() / (double)widthInPixel;
        double cellSizeY = coverage2D.getEnvelope2D().getHeight() / (double)heightInPixel;
        ArrayList<SimpleFeature> lstResults = new ArrayList<SimpleFeature>();
        if (dx > 0.0 || dy > 0.0) {
            double n;
            if (dx > dy) {
                n = dx /= cellSizeX;
                dy /= dx;
                dx = cellSizeX;
            } else {
                n = dy /= cellSizeY;
                dx /= dy;
                dy = cellSizeY;
            }
            if (x2 < x) {
                dx = -dx;
            }
            if (y2 < y) {
                dy = -dy;
            }
            double d = 0.0;
            while (d <= n) {
                boolean cornerPoint = d == 0.0 || d == n;
                SimpleFeature f = this.addPoint(coverage2D, x, y, cornerPoint);
                lstResults.add(f);
                d += 1.0;
                x += dx;
                y += dy;
            }
        }
        return lstResults;
    }

    private SimpleFeature addPoint(GridCoverage2D coverage2D, double x, double y, boolean cornerPoint) {
        double[] res = null;
        double z = coverage2D.evaluate((Point2D)new Point2D.Double(x, y), res)[0];
        boolean noData = DEMProfileGraphTool.isNoDataValue(coverage2D, z);
        if (noData) {
            z = 0.0;
        }
        if (this.nPoints == 0) {
            this.dDist = 0.0;
            this.dHorzDist = 0.0;
        } else {
            double dDX = x - this.m_dLastX;
            double dDY = y - this.m_dLastY;
            double dDZ = noData ? 0.0 : z - this.m_dLastZ;
            this.dDist += Math.sqrt(dDX * dDX + dDY * dDY);
            this.dHorzDist += Math.sqrt(dDX * dDX + dDY * dDY + dDZ * dDZ);
        }
        this.m_dLastX = x;
        this.m_dLastY = y;
        this.m_dLastZ = z;
        ++this.nPoints;
        Point geometry = this.gf.createPoint(new Coordinate(x, y, z));
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(this.resultFSchema);
        sfb.set("geom", (Object)geometry);
        sfb.set("x", (Object)x);
        sfb.set("y", (Object)y);
        sfb.set("z", (Object)z);
        sfb.set("plane-dist", (Object)this.dDist);
        sfb.set("terrain-dist", (Object)this.dHorzDist);
        sfb.set("cornerpoint", (Object)cornerPoint);
        DecimalFormat df = new DecimalFormat("FID000000");
        return sfb.buildFeature(df.format(this.nPoints));
    }

    public static boolean isNoDataValue(GridCoverage2D coverage2D, double sample) {
        if (Double.isNaN(sample)) {
            return true;
        }
        double[] noDataValues = coverage2D.getSampleDimension(0).getNoDataValues();
        if (noDataValues == null || noDataValues.length == 0) {
            return false;
        }
        return ArrayUtils.contains((double[])noDataValues, (double)sample);
    }

    private Plot2DPanelOJ createPlotPanel(SimpleFeatureCollection fc) {
        double[][] datas1 = new double[fc.size()][2];
        SimpleFeatureIterator iter = fc.features();
        int j = 0;
        while (iter.hasNext()) {
            SimpleFeature f = (SimpleFeature)iter.next();
            datas1[j][0] = (Double)f.getAttribute("plane-dist");
            datas1[j][1] = (Double)f.getAttribute("z");
            ++j;
        }
        iter.close();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        SimpleFeatureCollection fc2 = fc.subCollection((Filter)ff.equals((Expression)ff.property("cornerpoint"), (Expression)ff.literal(true)));
        double[][] datas2 = new double[fc2.size()][2];
        iter = fc2.features();
        j = 0;
        while (iter.hasNext()) {
            SimpleFeature f = (SimpleFeature)iter.next();
            datas2[j][0] = (Double)f.getAttribute("plane-dist");
            datas2[j][1] = (Double)f.getAttribute("z");
            ++j;
        }
        iter.close();
        Plot2DPanelOJ plot2dA = new Plot2DPanelOJ();
        int linePlotIndex = plot2dA.addLinePlot(I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphPlugIn.Profile-Graph"), datas1);
        int barPlotIndex = plot2dA.addBarPlot(PROFILEPTS, Color.RED, datas2);
        plot2dA.addLegend("West");
        plot2dA.setAxisLabel(0, I18N.getMessage("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.2d-distance", WorkbenchContext.getTask().getDrawingUnit().getUnitName()));
        plot2dA.setAxisLabel(1, I18N.getMessage("org.openjump.core.ui.plugin.dem.DEMProfileGraphTool.values", WorkbenchContext.getTask().getDrawingUnit().getUnitName()));
        plot2dA.getPlotToolBar().viewAdjustBounds(false);
        Plot linePlot = plot2dA.getPlot(linePlotIndex);
        Plot barPlot = plot2dA.getPlot(barPlotIndex);
        linePlot.setNumberFormat("##0.##");
        barPlot.setNumberFormat("##0.##");
        BiFunction<Object[], Plot, String> noteCoordFormatter = (data, plot) -> "X = " + String.valueOf(data[0]) + "\nY = " + String.valueOf(data[1]);
        linePlot.setNoteCoordFormatter(noteCoordFormatter);
        barPlot.setNoteCoordFormatter(noteCoordFormatter);
        return plot2dA;
    }
}

