/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.dem;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.WMTSStyleModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openjump.core.ui.plugin.dem.DEMProfileGraphTool;

public class DEMProfileGraphPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        QuasimodeTool quasimodeTool = QuasimodeTool.addStandardQuasimodes(new DEMProfileGraphTool());
        context.getLayerViewPanel().setCurrentCursorTool(quasimodeTool);
        return true;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"show_profile.svg");
    }

    @Override
    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.dem.DEMProfileGraphPlugIn.Profile-Graph");
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new MultiEnableCheck().add(EnableCheckFactory.getInstance().createTaskWindowMustBeActiveCheck()).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                Object demObject = WorkbenchContext.getInstance().getLayerManager().getTask().getBlackboard().get("DEM");
                if (demObject == null) {
                    return "no dem";
                }
                if (demObject instanceof WMTSStyleModel) {
                    return null;
                }
                return "no wmts dem";
            }
        });
    }
}

