/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.dem;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.jump.workbench.ui.renderer.WMTSLayerRenderer;
import de.riwagis.util.thread.CancelableRunnable;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.ui.plugin.dem.DEMLayer;
import org.openjump.core.ui.plugin.dem.DEMProfileGraphTool;

public class DEMLayerRenderer
extends WMTSLayerRenderer {
    private final LayerView layerView;
    private final BufferedImage bi;

    public DEMLayerRenderer(DEMLayer layer, LayerView panel, LayerView layerView, BufferedImage bi) {
        super(layer, panel);
        this.layerView = layerView;
        this.bi = bi;
    }

    @Override
    protected void renderHook(ThreadSafeImage image, CancelableRunnable runnable) throws Exception {
        ThreadSafeImage tsi = new ThreadSafeImage(this.layerView){

            @Override
            public Image getImage() {
                this.image = DEMLayerRenderer.this.bi;
                return DEMLayerRenderer.this.bi;
            }
        };
        super.renderHook(tsi, runnable);
    }

    @Override
    protected void renderImage(ThreadSafeImage image, Image tileImage, Envelope bounds) throws Exception {
        if (tileImage == null) {
            return;
        }
        Point2D p = this.getPanel().getViewport().toViewPoint(new Coordinate(bounds.getMinX(), bounds.getMaxY()));
        BufferedImage bim = (BufferedImage)image.getImage();
        BufferedImage tileBIM = (BufferedImage)tileImage;
        int xMin = (int)Math.round(p.getX());
        int yMin = (int)Math.round(p.getY());
        Point2D p2 = this.getPanel().getViewport().toViewPoint(new Coordinate(bounds.getMaxX(), bounds.getMinY()));
        int xMax = (int)Math.round(p2.getX());
        int yMax = (int)Math.round(p2.getY());
        double scaleX = (p2.getX() - p.getX()) / (double)tileBIM.getWidth();
        double scaleY = (p2.getY() - p.getY()) / (double)tileBIM.getHeight();
        float[] value = new float[1];
        int startX = Math.max(0, xMin);
        int startY = Math.max(0, yMin);
        int endX = Math.min(bim.getWidth(), xMax);
        int endY = Math.min(bim.getHeight(), yMax);
        for (int w = startX; w < endX; ++w) {
            for (int h = startY; h < endY; ++h) {
                int px = (int)Math.round((double)(w - xMin) / scaleX);
                int py = (int)Math.round((double)(h - yMin) / scaleY);
                if (px < 0 || py < 0 || px > tileBIM.getWidth() - 1 || py > tileBIM.getHeight() - 1) continue;
                value = tileBIM.getRaster().getPixel(px, py, value);
                bim.getRaster().setPixel(w, h, value);
            }
        }
    }

    @Override
    public BufferedImage createBufferedImage(int width, int height) {
        return DEMProfileGraphTool.createBufferedImage(width, height);
    }

    @Override
    public void renderImage(BufferedImage bim, BufferedImage tileBIM, int x, int y, int width, int height) {
        float[] value = new float[1];
        for (int w = 0; w < tileBIM.getWidth(); ++w) {
            for (int h = 0; h < tileBIM.getHeight(); ++h) {
                int px = x + w;
                int py = y + h;
                if (px < 0 || py < 0 || px > bim.getWidth() - 1 || py > bim.getHeight() - 1) continue;
                value = tileBIM.getRaster().getPixel(w, h, value);
                bim.getRaster().setPixel(px, py, value);
            }
        }
    }
}

