/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plot;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.awt.Color;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.plotObjects.Base;
import org.math.plot.plotObjects.BasePlot;
import org.math.plot.plots.BarPlot;
import org.math.plot.plots.BoxPlot2D;
import org.math.plot.plots.CloudPlot2D;
import org.math.plot.plots.HistogramPlot2D;
import org.math.plot.plots.LinePlot;
import org.math.plot.plots.ScatterPlot;
import org.math.plot.plots.StaircasePlot;
import org.math.plot.render.AWTDrawer2D;
import org.math.plot.utils.Array;
import org.math.plot.utils.Histogram;
import org.openjump.core.ui.plot.BarPlotOJ;
import org.openjump.core.ui.plot.HistogramPlot2DOJ;
import org.openjump.core.ui.plot.ScatterPlotOJ;

public class Plot2DCanvasOJ
extends PlotCanvas {
    private static final long serialVersionUID = 1L;

    public Plot2DCanvasOJ() {
        this.ActionMode = 0;
    }

    public Plot2DCanvasOJ(Base b, BasePlot bp) {
        super(b, bp);
        this.ActionMode = 0;
    }

    public Plot2DCanvasOJ(double[] min, double[] max, String[] axesScales, String[] axesLabels) {
        super(min, max, axesScales, axesLabels);
        this.ActionMode = 0;
    }

    @Override
    public void initDrawer() {
        this.draw = new AWTDrawer2D(this);
    }

    @Override
    public void initBasenGrid(double[] min, double[] max) {
        this.initBasenGrid(min, max, new String[]{"lin", "lin"}, new String[]{"X", "Y"});
    }

    @Override
    public void initBasenGrid() {
        this.initBasenGrid(new double[]{0.0, 0.0}, new double[]{1.0, 1.0});
    }

    private static double[][] convertY(double[] XY) {
        double[] x = Array.increment(XY.length, 1.0, 1.0);
        return Array.mergeColumns(x, XY);
    }

    private static double[][] convertXY(double[] ... XY) {
        if (XY.length == 2 && XY[0].length != 2) {
            return Array.mergeColumns(XY[0], XY[1]);
        }
        return XY;
    }

    public int addScatterPlot(String name, Color c, double[] Y) {
        return this.addPlot(new ScatterPlot(name, c, Plot2DCanvasOJ.convertY(Y)));
    }

    public int addScatterPlot(String name, Color c, double[][] XY) {
        return this.addPlot(new ScatterPlot(name, c, Plot2DCanvasOJ.convertXY(XY)));
    }

    public int addScatterPlotOJ(String name, Color c, double[][] XY, String[] fID, PlugInContext context, Layer layer) {
        return this.addPlot(new ScatterPlotOJ(name, c, Plot2DCanvasOJ.convertXY(XY), fID, context, layer));
    }

    public int addScatterPlot(String name, Color c, double[] X, double[] Y) {
        return this.addPlot(new ScatterPlot(name, c, Plot2DCanvasOJ.convertXY(X, Y)));
    }

    public int addLinePlot(String name, Color c, double[] Y) {
        return this.addPlot(new LinePlot(name, c, Plot2DCanvasOJ.convertY(Y)));
    }

    public int addLinePlot(String name, Color c, double[][] XY) {
        return this.addPlot(new LinePlot(name, c, Plot2DCanvasOJ.convertXY(XY)));
    }

    public int addLinePlot(String name, Color c, double[] X, double[] Y) {
        return this.addPlot(new LinePlot(name, c, Plot2DCanvasOJ.convertXY(X, Y)));
    }

    public int addBarPlot(String name, Color c, double[] Y) {
        return this.addPlot(new BarPlot(name, c, Plot2DCanvasOJ.convertY(Y)));
    }

    public int addBarPlotOJ(String name, Color c, double[] Y, String[] fID, PlugInContext context, Layer layer) {
        return this.addPlot(new BarPlotOJ(name, c, Plot2DCanvasOJ.convertY(Y), fID, context, layer));
    }

    public int addBarPlot(String name, Color c, double[][] XY) {
        return this.addPlot(new BarPlot(name, c, Plot2DCanvasOJ.convertXY(XY)));
    }

    public int addBarPlot(String name, Color c, double[] X, double[] Y) {
        return this.addPlot(new BarPlot(name, c, Plot2DCanvasOJ.convertXY(X, Y)));
    }

    public int addStaircasePlot(String name, Color c, double[] Y) {
        return this.addPlot(new StaircasePlot(name, c, Plot2DCanvasOJ.convertY(Y)));
    }

    public int addStaircasePlot(String name, Color c, double[][] XY) {
        return this.addPlot(new StaircasePlot(name, c, Plot2DCanvasOJ.convertXY(XY)));
    }

    public int addStaircasePlot(String name, Color c, double[] X, double[] Y) {
        return this.addPlot(new StaircasePlot(name, c, Plot2DCanvasOJ.convertXY(X, Y)));
    }

    public int addBoxPlot(String name, Color c, double[][] XY, double[][] dX) {
        return this.addPlot(new BoxPlot2D(XY, dX, c, name));
    }

    public int addBoxPlot(String name, Color c, double[][] XYdX) {
        return this.addPlot(new BoxPlot2D(Array.getColumnsRangeCopy(XYdX, 0, 1), Array.getColumnsRangeCopy(XYdX, 2, 3), c, name));
    }

    public int addHistogramPlot(String name, Color c, double[][] XY, double[] dX) {
        return this.addPlot(new HistogramPlot2D(name, c, XY, dX));
    }

    public int addHistogramPlot(String name, Color c, double[][] XY, double dX) {
        return this.addPlot(new HistogramPlot2D(name, c, XY, dX));
    }

    public int addHistogramPlot(String name, Color c, double[][] XYdX) {
        return this.addPlot(new HistogramPlot2D(name, c, Array.getColumnsRangeCopy(XYdX, 0, 1), Array.getColumnCopy(XYdX, 2)));
    }

    public int addHistogramPlot(String name, Color c, double[] X, int n) {
        double[][] XY = Histogram.histogram_classes(X, n);
        return this.addPlot(new HistogramPlot2D(name, c, XY, XY[1][0] - XY[0][0]));
    }

    public int addHistogramPlotOJ(String name, Color c, double[] X, int n, PlugInContext context, Layer layer, String attrName) {
        double[][] XY = Histogram.histogram_classes(X, n);
        return this.addPlot(new HistogramPlot2DOJ(name, c, XY, XY[1][0] - XY[0][0], context, layer, attrName));
    }

    public int addHistogramPlot(String name, Color c, double[] X, double ... bounds) {
        double[][] XY = Histogram.histogram_classes(X, bounds);
        return this.addPlot(new HistogramPlot2D(name, c, XY, XY[1][0] - XY[0][0]));
    }

    public int addHistogramPlot(String name, Color c, double[] X, double min, double max, int n) {
        double[][] XY = Histogram.histogram_classes(X, min, max, n);
        return this.addPlot(new HistogramPlot2D(name, c, XY, XY[1][0] - XY[0][0]));
    }

    public int addCloudPlot(String name, Color c, double[][] sampleXY, int nX, int nY) {
        double[][] XYh = Histogram.histogram_classes_2D(sampleXY, nX, nY);
        return this.addPlot(new CloudPlot2D(name, c, XYh, XYh[1][0] - XYh[0][0], XYh[nX][1] - XYh[0][1]));
    }
}

