/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plot;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToSelectedItemsPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.awt.Color;
import java.util.ArrayList;
import org.geotools.data.simple.SimpleFeatureReader;
import org.math.plot.plots.HistogramPlot2D;
import org.math.plot.render.AbstractDrawer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.Filter;

public class HistogramPlot2DOJ
extends HistogramPlot2D {
    double[][] XY;
    double width = 0.0;
    String attrName = "";
    PlugInContext context = null;
    Layer layer = null;
    AttributeType type = null;
    private final ZoomToSelectedItemsPlugIn zoomToSelectedItemsPlugIn = new ZoomToSelectedItemsPlugIn();

    public HistogramPlot2DOJ(String n, Color c, double[][] _XY, double w, PlugInContext context, Layer layer, String attrName) {
        super(n, c, _XY, w, 0.5, 1.0);
        this.width = w;
        this.XY = _XY;
        this.context = context;
        this.layer = layer;
        this.attrName = attrName;
        SimpleFeatureType fs = layer.getFeatureType();
        this.type = fs.getType(attrName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        for (double[] XY1 : this.XY) {
            int[] screenCoord = draw.project(XY1);
            if (screenCoord[0] + this.note_precision <= screenCoordTest[0] || screenCoord[0] - this.note_precision >= screenCoordTest[0] || screenCoord[1] + this.note_precision <= screenCoordTest[1] || screenCoord[1] - this.note_precision >= screenCoordTest[1]) continue;
            double mean = XY1[0];
            double lBound = mean - 0.5 * this.width;
            double hBound = mean + 0.5 * this.width;
            SimpleFeatureReader fread = null;
            try {
                fread = (SimpleFeatureReader)this.layer.getFMD().getFeatureReader(this.layer.getLayerManager().getTask().getDataStores(), (Filter)Filter.INCLUDE);
                ArrayList<SimpleFeature> coveredFeatures = new ArrayList<SimpleFeature>();
                while (fread.hasNext()) {
                    SimpleFeature f = (SimpleFeature)fread.next();
                    double dval = 0.0;
                    Object val = f.getAttribute(this.attrName);
                    if (this.type.getBinding() == Double.class) {
                        dval = (Double)val;
                    } else if (this.type.getBinding() == Integer.class) {
                        dval = ((Integer)val).intValue();
                    }
                    if (!(dval < hBound) || !(dval > lBound)) continue;
                    coveredFeatures.add(f);
                }
                this.zoomToSelectedItemsPlugIn.flash(FeatureUtil.toGeometries(coveredFeatures), this.context.getLayerViewPanel());
            }
            catch (Throwable t) {
                WorkbenchContext.getErrorHandler().handleThrowable(t);
            }
            finally {
                if (fread != null) {
                    try {
                        fread.close();
                    }
                    catch (Throwable t) {
                        WorkbenchContext.getErrorHandler().handleThrowable(t);
                    }
                }
            }
            return XY1;
        }
        return null;
    }
}

