/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.geomutils;

import java.util.BitSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.UniqueCoordinateArrayFilter;
import org.openjump.core.geomutils.MathVector;

public class GeoUtils {
    public static final int emptyBit = 0;
    public static final int pointBit = 1;
    public static final int lineBit = 2;
    public static final int polyBit = 3;

    public static double mag(Coordinate q) {
        return Math.sqrt(q.x * q.x + q.y * q.y);
    }

    public static double distance(Coordinate p1, Coordinate p2) {
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static Coordinate unitVec(Coordinate q) {
        double m = GeoUtils.mag(q);
        if (m == 0.0) {
            m = 1.0;
        }
        return new Coordinate(q.x / m, q.y / m);
    }

    public static Coordinate vectorAdd(Coordinate q, Coordinate r) {
        return new Coordinate(q.x + r.x, q.y + r.y);
    }

    public static Coordinate vectorBetween(Coordinate q, Coordinate r) {
        return new Coordinate(r.x - q.x, r.y - q.y);
    }

    public static Coordinate vectorTimesScalar(Coordinate q, double m) {
        return new Coordinate(q.x * m, q.y * m);
    }

    public static Coordinate rotPt(Coordinate inpt, Coordinate rpt, double theta) {
        double tr = Math.toRadians(theta);
        double ct = Math.cos(tr);
        double st = Math.sin(tr);
        double x = inpt.x - rpt.x;
        double y = inpt.y - rpt.y;
        double xout = rpt.x + x * ct + y * st;
        double yout = rpt.y + y * ct - st * x;
        return new Coordinate(xout, yout);
    }

    public static boolean pointToRight(Coordinate pt, Coordinate p1, Coordinate p2) {
        double a = p2.x - p1.x;
        double b = p2.y - p1.y;
        double c = p1.y * a - p1.x * b;
        double fpt = a * pt.y - b * pt.x - c;
        return fpt < 0.0;
    }

    public static Coordinate perpendicularVector(Coordinate v1, Coordinate v2, double dist, boolean toLeft) {
        Coordinate v3 = GeoUtils.vectorBetween(v2, v1);
        Coordinate v4 = new Coordinate();
        if (toLeft) {
            v4.x = -v3.y;
            v4.y = v3.x;
        } else {
            v4.x = v3.y;
            v4.y = -v3.x;
        }
        return GeoUtils.vectorAdd(v1, GeoUtils.vectorTimesScalar(GeoUtils.unitVec(v4), dist));
    }

    public static double getBearing180(Coordinate startPt, Coordinate endPt) {
        Coordinate r = new Coordinate(endPt.x - startPt.x, endPt.y - startPt.y);
        double rMag = Math.sqrt(r.x * r.x + r.y * r.y);
        if (rMag == 0.0) {
            return 0.0;
        }
        double rCos = r.x / rMag;
        double rAng = Math.acos(rCos);
        if (r.y < 0.0) {
            rAng = -rAng;
        }
        return rAng * 360.0 / (Math.PI * 2);
    }

    public static double getBearing360(Coordinate startPt, Coordinate endPt) {
        double bearing = GeoUtils.getBearing180(startPt, endPt);
        if (bearing < 0.0) {
            bearing = 360.0 + bearing;
        }
        return bearing;
    }

    public static double theta(Coordinate p1, Coordinate p2) {
        double ay;
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double ax = Math.abs(dx);
        double t = ax + (ay = Math.abs(dy));
        if (t != 0.0) {
            t = dy / t;
        }
        if (dx < 0.0) {
            t = 2.0 - t;
        } else if (dy < 0.0) {
            t = 4.0 + t;
        }
        return t * 90.0;
    }

    public static CoordinateList ConvexHullWrap(CoordinateList coords) {
        int i;
        CoordinateList newcoords = new CoordinateList();
        int n = coords.size();
        Coordinate[] p = new Coordinate[n + 1];
        for (i = 0; i < n; ++i) {
            p[i] = coords.getCoordinate(i);
        }
        int min = 0;
        for (i = 1; i < n; ++i) {
            if (!(p[i].y < p[min].y)) continue;
            min = i;
        }
        p[n] = coords.getCoordinate(min);
        double minAngle = 0.0;
        double distMax = 0.0;
        for (int m = 0; m < n; ++m) {
            Coordinate temp = p[m];
            p[m] = p[min];
            p[min] = temp;
            min = n;
            double v = minAngle;
            double vdist = distMax;
            minAngle = 360.0;
            for (i = m + 1; i <= n; ++i) {
                double t = GeoUtils.theta(p[m], p[i]);
                double dist = GeoUtils.distance(p[m], p[i]);
                if (!(t > v) && (t != v || !(dist > vdist)) || !(t < minAngle) && (t != minAngle || !(dist > distMax))) continue;
                min = i;
                minAngle = t;
                distMax = dist;
            }
            if (min != n) continue;
            for (int j = 0; j <= m; ++j) {
                newcoords.add(p[j], true);
            }
            if (!p[0].equals2D(p[m])) {
                newcoords.add(p[0], true);
            }
            return newcoords;
        }
        return newcoords;
    }

    public static double getDistance(Coordinate pt, Coordinate p0, Coordinate p1) {
        return pt.distance(GeoUtils.getClosestPointOnSegment(pt, p0, p1));
    }

    public static Coordinate getClosestPointOnSegment(Coordinate pt, Coordinate p0, Coordinate p1) {
        Coordinate coordOut = new Coordinate(0.0, 0.0);
        double X0 = p0.x;
        double Y0 = p0.y;
        double X1 = p1.x;
        double Y1 = p1.y;
        double Xr = pt.x;
        double Yr = pt.y;
        double Xv = X1 - X0;
        double Yv = Y1 - Y0;
        double VdotV = Xv * Xv + Yv * Yv;
        double Xp0r = Xr - X0;
        double Yp0r = Yr - Y0;
        double DistP0toR = Math.sqrt(Xp0r * Xp0r + Yp0r * Yp0r);
        if (VdotV == 0.0) {
            return p0;
        }
        double t = (Xp0r * Xv + Yp0r * Yv) / VdotV;
        if (t >= 0.0 && t <= 1.0) {
            double Xp = X0 + t * Xv - Xr;
            double Yp = Y0 + t * Yv - Yr;
            coordOut.x = pt.x + Xp;
            coordOut.y = pt.y + Yp;
        } else {
            double Xp1r = Xr - X1;
            double Yp1r = Yr - Y1;
            double DistP1toR = Math.sqrt(Xp1r * Xp1r + Yp1r * Yp1r);
            coordOut = DistP1toR < DistP0toR ? p1 : p0;
        }
        return coordOut;
    }

    public static Coordinate getClosestPointOnLine(Coordinate pt, Coordinate p0, Coordinate p1) {
        MathVector vpt = new MathVector(pt);
        MathVector vp0 = new MathVector(p0);
        MathVector vp1 = new MathVector(p1);
        MathVector v = vp0.vectorBetween(vp1);
        double vdotv = v.dot(v);
        if (vdotv == 0.0) {
            return p0;
        }
        double t = vpt.vectorBetween(vp0).dot(v) / vdotv;
        MathVector vt = v.scale(t);
        vpt = vp0.add(vt);
        return vpt.getCoord();
    }

    public static Coordinate along(double d, Coordinate q, Coordinate r) {
        Coordinate n = (Coordinate)r.clone();
        double ux = r.x - q.x;
        double uy = r.y - q.y;
        double m = Math.sqrt(ux * ux + uy * uy);
        if (m != 0.0) {
            ux = d * ux / m;
            uy = d * uy / m;
            n.x = q.x + ux;
            n.y = q.y + uy;
        }
        return n;
    }

    public static Geometry reducePoints(Geometry geo, double tolerance) {
        int maxIndex;
        CoordinateList coords = new CoordinateList();
        UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
        geo.apply((CoordinateFilter)filter);
        coords.add(filter.getCoordinates(), false);
        if (geo instanceof Polygon || geo instanceof LinearRing) {
            coords.add(coords.getCoordinate(0));
        }
        int temp = maxIndex = coords.size() - 1;
        do {
            temp = maxIndex;
            int i = 0;
            do {
                Coordinate anchor = coords.getCoordinate(i);
                boolean pointDeleted = false;
                int k = maxIndex;
                do {
                    Coordinate floater = coords.getCoordinate(k);
                    double dmax = -1.0;
                    int j = k;
                    while (j > i + 1) {
                        Coordinate cp;
                        Coordinate pt;
                        double d;
                        if (!((d = (pt = coords.getCoordinate(--j)).distance(cp = GeoUtils.getClosestPointOnLine(pt, anchor, floater))) > dmax)) continue;
                        dmax = d;
                        k = j;
                    }
                    if (!(dmax < tolerance) || !(dmax > -1.0) || maxIndex <= 1) continue;
                    pointDeleted = true;
                    coords.remove(k);
                    k = --maxIndex;
                } while (!pointDeleted && k > i + 1);
            } while (++i <= maxIndex - 2);
        } while (temp != maxIndex);
        if (geo instanceof LineString) {
            return new GeometryFactory().createLineString(coords.toCoordinateArray());
        }
        if (geo instanceof LinearRing) {
            return new GeometryFactory().createLinearRing(coords.toCoordinateArray());
        }
        if (geo instanceof Polygon) {
            return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(coords.toCoordinateArray()), null);
        }
        return geo;
    }

    public static boolean clockwise(Geometry geo) {
        if (geo instanceof Polygon || geo instanceof LinearRing) {
            Coordinate[] geoCoords = geo.getCoordinates();
            int maxIndex = geoCoords.length - 1;
            double t1 = geoCoords[maxIndex].x * geoCoords[0].y;
            double t2 = -geoCoords[0].x * geoCoords[maxIndex].y;
            for (int i = 0; i < maxIndex; ++i) {
                t1 += geoCoords[i].x * geoCoords[i + 1].y;
                t2 -= geoCoords[i + 1].x * geoCoords[i].y;
            }
            double geoArea = 0.5 * (t1 + t2);
            return geoArea < 0.0;
        }
        return true;
    }

    public static Coordinate getIntersection(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate p4) {
        Coordinate e = new Coordinate(0.0, 0.0, 0.0);
        Coordinate v = new Coordinate(0.0, 0.0);
        Coordinate w = new Coordinate(0.0, 0.0);
        double t1 = 0.0;
        double n = 0.0;
        double d = 0.0;
        v.x = p2.x - p1.x;
        v.y = p2.y - p1.y;
        w.x = p4.x - p3.x;
        w.y = p4.y - p3.y;
        n = w.y * (p3.x - p1.x) - w.x * (p3.y - p1.y);
        d = w.y * v.x - w.x * v.y;
        if (d != 0.0) {
            t1 = n / d;
            e.x = p1.x + v.x * t1;
            e.y = p1.y + v.y * t1;
        } else {
            e.z = 999.0;
        }
        return e;
    }

    public static Coordinate getCenter(Coordinate p1, Coordinate p2, Coordinate p3) {
        double x = p1.x + (p1.x - p2.x) / 2.0;
        double y = p1.y + (p1.y - p2.y) / 2.0;
        Coordinate p12 = new Coordinate(x, y);
        p12 = GeoUtils.rotPt(p12, p1, 90.0);
        x = p1.x + (p1.x - p2.x) / 2.0;
        y = p1.y + (p1.y - p2.y) / 2.0;
        Coordinate p23 = new Coordinate(x, y);
        p23 = GeoUtils.rotPt(p23, p2, 90.0);
        Coordinate center = GeoUtils.getIntersection(p1, p12, p2, p23);
        if (center.z != 0.0) {
            return p2;
        }
        return center;
    }

    public static BitSet setBit(BitSet bitSet, Geometry geometry) {
        BitSet newBitSet = (BitSet)bitSet.clone();
        if (geometry.isEmpty()) {
            newBitSet.set(0);
        } else if (geometry instanceof Point) {
            newBitSet.set(1);
        } else if (geometry instanceof MultiPoint) {
            newBitSet.set(1);
        } else if (geometry instanceof LineString) {
            newBitSet.set(2);
        } else if (geometry instanceof LinearRing) {
            newBitSet.set(2);
        } else if (geometry instanceof MultiLineString) {
            newBitSet.set(2);
        } else if (geometry instanceof Polygon) {
            newBitSet.set(3);
        } else if (geometry instanceof MultiPolygon) {
            newBitSet.set(3);
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                newBitSet = GeoUtils.setBit(newBitSet, geometryCollection.getGeometryN(i));
            }
        }
        return newBitSet;
    }
}

