/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.Plot3DPanel;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;
import org.math.plot.utils.FastMath;

public class ScatterPlot
extends Plot {
    private int type;
    private int radius;
    private boolean[][] pattern;
    private boolean use_pattern;
    double[][] XY;
    private String[] tags;

    public ScatterPlot(String n, Color c, boolean[][] _pattern, double[][] _XY) {
        super(n, c);
        this.XY = _XY;
        this.use_pattern = true;
        this.pattern = _pattern;
    }

    public ScatterPlot(String n, Color c, int _type, int _radius, double[][] _XY) {
        super(n, c);
        this.XY = _XY;
        this.use_pattern = false;
        this.type = _type;
        this.radius = _radius;
    }

    public ScatterPlot(String n, Color c, double[][] _XY) {
        this(n, c, 1, 2, _XY);
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.visible) {
            return;
        }
        draw.setColor(c);
        if (this.use_pattern) {
            draw.setDotType(0);
            draw.setDotPattern(this.pattern);
        } else {
            draw.setDotRadius(this.radius);
            if (this.type == 2) {
                draw.setDotType(2);
            } else {
                draw.setDotType(1);
            }
        }
        for (double[] XY1 : this.XY) {
            draw.drawDot(XY1);
        }
    }

    public void setDotPattern(int t) {
        this.type = t;
        this.use_pattern = false;
    }

    public void setDotPattern(boolean[][] t) {
        this.use_pattern = true;
        this.pattern = t;
    }

    @Override
    public void setData(double[][] d) {
        this.datapanel = null;
        this.XY = d;
    }

    @Override
    public double[][] getData() {
        return this.XY;
    }

    @Override
    public double[][] getBounds() {
        return Array.mergeRows(Array.min(this.XY), Array.max(this.XY));
    }

    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        for (double[] XY1 : this.XY) {
            int[] screenCoord = draw.project(XY1);
            if (FastMath.abs(screenCoord[0] - screenCoordTest[0]) >= this.note_precision || FastMath.abs(screenCoord[1] - screenCoordTest[1]) >= this.note_precision) continue;
            return XY1;
        }
        return null;
    }

    public static void main(String[] args) {
        Plot2DPanel p2 = new Plot2DPanel();
        for (int i = 0; i < 3; ++i) {
            double[][] XYZ;
            for (double[] XYZ1 : XYZ = new double[10][2]) {
                XYZ1[0] = Math.random();
                XYZ1[1] = Math.random();
            }
            p2.addScatterPlot("toto" + i, XYZ);
        }
        p2.setLegendOrientation("South");
        new FrameView(p2).setDefaultCloseOperation(3);
        Plot3DPanel p = new Plot3DPanel();
        String[] tags = null;
        for (int i = 0; i < 3; ++i) {
            double[][] XYZ = new double[10][3];
            tags = new String[10];
            for (int j = 0; j < XYZ.length; ++j) {
                XYZ[j][0] = 2.5 * Math.random();
                XYZ[j][1] = Math.random();
                XYZ[j][2] = Math.random();
                tags[j] = "tags " + j;
            }
            p.addScatterPlot("toto" + i, XYZ);
        }
        ((ScatterPlot)p.getPlot(0)).setTags(tags);
        p.setLegendOrientation("South");
        new FrameView(p).setDefaultCloseOperation(3);
    }

    public void setTags(String[] tags) {
        this.datapanel = null;
        this.tags = tags;
    }

    @Override
    public void noteCoord(AbstractDrawer draw, double[] coordNoted) {
        if (coordNoted == null) {
            return;
        }
        if (this.tags == null) {
            super.noteCoord(draw, coordNoted);
        } else {
            draw.setColor(PlotCanvas.NOTE_COLOR);
            for (int i = 0; i < this.XY.length; ++i) {
                if (this.tags.length <= i || !Array.equals(this.XY[i], coordNoted)) continue;
                draw.drawShadowedText(this.tags[i], 0.5f, coordNoted);
            }
        }
    }
}

