/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.LayerPlot;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class QuantileLayerPlot
extends LayerPlot {
    public static int WIDTH = 2;
    int axe;
    double quantileRate;
    Color gradC;
    double main_data_constant = 0.0;
    public boolean symetric = false;
    double[] Q;

    public QuantileLayerPlot(Plot p, int a, double q, double r, boolean _symetric) {
        this(p, a, null, r, true);
        this.main_data_constant = q;
    }

    public QuantileLayerPlot(Plot p, int a, double[] q, double r, boolean _symetric) {
        super(r + " quantile of " + p.name, p);
        if (q != null) {
            Array.checkLength(q, p.getData().length);
        }
        this.Q = q;
        this.axe = a;
        this.quantileRate = r;
        this.symetric = _symetric;
    }

    public double getQuantilesValue(int numCoord) {
        return this.Q[numCoord];
    }

    public int getAxe() {
        return this.axe;
    }

    public double getQuantileRate() {
        return this.quantileRate;
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.plot.visible) {
            return;
        }
        draw.setColor(c);
        this.gradC = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (1.0 - this.quantileRate)));
        draw.setLineType(1);
        draw.setLineWidth(WIDTH);
        if (this.main_data_constant == 0.0) {
            for (int i = 0; i < this.plot.getData().length; ++i) {
                double[] d = Array.getRowCopy(this.plot.getData(), i);
                int n = this.axe;
                d[n] = d[n] + this.Q[i];
                draw.setGradient(this.plot.getData()[i], c, d, this.gradC);
                draw.drawLine(this.plot.getData()[i], d);
                if (!this.symetric) continue;
                int n2 = this.axe;
                d[n2] = d[n2] - 2.0 * this.Q[i];
                draw.setGradient(this.plot.getData()[i], c, d, this.gradC);
                draw.drawLine(this.plot.getData()[i], d);
            }
        } else {
            for (int i = 0; i < this.plot.getData().length; ++i) {
                double[] d = Array.getRowCopy(this.plot.getData(), i);
                int n = this.axe;
                d[n] = d[n] + this.main_data_constant;
                draw.setGradient(this.plot.getData()[i], c, d, this.gradC);
                draw.drawLine(this.plot.getData()[i], d);
                if (!this.symetric) continue;
                int n3 = this.axe;
                d[n3] = d[n3] - 2.0 * this.main_data_constant;
                draw.setGradient(this.plot.getData()[i], c, d, this.gradC);
                draw.drawLine(this.plot.getData()[i], d);
            }
        }
        draw.resetGradient();
        draw.setLineWidth(1);
    }

    @Override
    public void setData(double[][] d) {
        this.Q = d[0];
    }

    @Override
    public double[][] getData() {
        return new double[][]{this.Q};
    }

    public static void main(String[] args) {
        Plot2DPanel p2 = new Plot2DPanel();
        for (int i = 0; i < 1; ++i) {
            double[][] XYZ;
            for (double[] XYZ1 : XYZ = new double[10][2]) {
                XYZ1[0] = Math.random();
                XYZ1[1] = Math.random();
            }
            p2.addScatterPlot("toto" + i, XYZ);
        }
        p2.addQuantiletoPlot(0, 1, 1.0, true, 0.2);
        new FrameView(p2).setDefaultCloseOperation(3);
    }
}

