/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot3DPanel;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class GridPlot3D
extends Plot {
    double[] X;
    double[] Y;
    double[][] Z;
    private double[][] XYZ_list;
    public boolean draw_lines = true;
    public boolean fill_shape = true;

    public GridPlot3D(String n, Color c, double[] _X, double[] _Y, double[][] _Z) {
        super(n, c);
        this.X = _X;
        this.Y = _Y;
        this.Z = _Z;
        this.buildXYZ_list();
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        int i;
        int j;
        if (!this.visible) {
            return;
        }
        draw.setColor(c);
        if (this.draw_lines) {
            draw.setLineType(1);
            for (i = 0; i < this.X.length; ++i) {
                for (j = 0; j < this.Y.length - 1; ++j) {
                    draw.drawLine({this.X[i], this.Y[j], this.Z[j][i]}, {this.X[i], this.Y[j + 1], this.Z[j + 1][i]});
                }
            }
            for (j = 0; j < this.Y.length; ++j) {
                for (i = 0; i < this.X.length - 1; ++i) {
                    draw.drawLine({this.X[i], this.Y[j], this.Z[j][i]}, {this.X[i + 1], this.Y[j], this.Z[j][i + 1]});
                }
            }
        } else {
            draw.setDotType(1);
            draw.setDotRadius(2);
            for (i = 0; i < this.X.length; ++i) {
                for (j = 0; j < this.Y.length; ++j) {
                    draw.drawDot(this.X[i], this.Y[j], this.Z[j][i]);
                }
            }
        }
        if (this.fill_shape) {
            for (j = 0; j < this.Y.length - 1; ++j) {
                for (i = 0; i < this.X.length - 1; ++i) {
                    draw.fillPolygon(0.2f, {this.X[i], this.Y[j], this.Z[j][i]}, {this.X[i + 1], this.Y[j], this.Z[j][i + 1]}, {this.X[i + 1], this.Y[j + 1], this.Z[j + 1][i + 1]}, {this.X[i], this.Y[j + 1], this.Z[j + 1][i]});
                }
            }
        }
    }

    private void buildXYZ_list() {
        this.XYZ_list = new double[this.X.length * this.Y.length][3];
        for (int i = 0; i < this.X.length; ++i) {
            for (int j = 0; j < this.Y.length; ++j) {
                this.XYZ_list[i + j * this.X.length][0] = this.X[i];
                this.XYZ_list[i + j * this.X.length][1] = this.Y[j];
                this.XYZ_list[i + j * this.X.length][2] = this.Z[j][i];
            }
        }
    }

    @Override
    public void setData(double[][] _Z) {
        this.datapanel = null;
        this.Z = _Z;
        this.buildXYZ_list();
    }

    @Override
    public double[][] getData() {
        return this.XYZ_list;
    }

    @Override
    public double[][] getBounds() {
        return new double[][]{{Array.min(this.X), Array.min(this.Y), Array.min(Array.min(this.Z))}, {Array.max(this.X), Array.max(this.Y), Array.max(Array.min(this.Z))}};
    }

    public void setDataZ(double[][] _Z) {
        this.setData(_Z);
    }

    public double[][] getDataZ() {
        return this.Z;
    }

    public void setDataX(double[] _X) {
        this.datapanel = null;
        this.X = _X;
        this.buildXYZ_list();
    }

    public double[] getDataX() {
        return this.X;
    }

    public void setDataY(double[] _Y) {
        this.datapanel = null;
        this.Y = _Y;
        this.buildXYZ_list();
    }

    public double[] getDataY() {
        return this.Y;
    }

    public void setDataXYZ(double[] _X, double[] _Y, double[][] _Z) {
        this.datapanel = null;
        this.X = _X;
        this.Y = _Y;
        this.Z = _Z;
        this.buildXYZ_list();
    }

    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        for (int i = 0; i < this.X.length; ++i) {
            for (int j = 0; j < this.Y.length; ++j) {
                double[] XY = new double[]{this.X[i], this.Y[j], this.Z[j][i]};
                int[] screenCoord = draw.project(XY);
                if (screenCoord[0] + this.note_precision <= screenCoordTest[0] || screenCoord[0] - this.note_precision >= screenCoordTest[0] || screenCoord[1] + this.note_precision <= screenCoordTest[1] || screenCoord[1] - this.note_precision >= screenCoordTest[1]) continue;
                return XY;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        int n = 14;
        int m = 16;
        Plot3DPanel p = new Plot3DPanel();
        double[] X = new double[n];
        double[] Y = new double[m];
        double[][] Z = new double[m][n];
        for (int i = 0; i < X.length; ++i) {
            X[i] = 3.0 + (double)i / (double)X.length;
            for (int j = 0; j < Y.length; ++j) {
                Y[j] = 5.0 + (double)j / (double)Y.length;
                Z[j][i] = Math.exp(X[i]) + Y[j];
            }
        }
        p.addGridPlot("toto", X, Y, Z);
        p.setLegendOrientation("South");
        new FrameView(p);
    }
}

