/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot3DPanel;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class CloudPlot3D
extends Plot {
    double[][] topNW;
    double[][] topNE;
    double[][] topSW;
    double[][] topSE;
    double[][] botNW;
    double[][] botNE;
    double[][] botSW;
    double[][] botSE;
    double[] width_constant = new double[]{-1.0, -1.0, -1.0};
    double[][] XY;
    float[] f;
    boolean fill_shape = true;

    public CloudPlot3D(String n, Color c, double[][] _XYcard, double wX, double wY, double wZ) {
        super(n, c);
        this.splitXYf(_XYcard);
        this.width_constant = new double[]{wX, wY, wZ};
        this.build();
    }

    private void splitXYf(double[][] xycard) {
        int i;
        this.XY = new double[xycard.length][3];
        this.f = new float[xycard.length];
        float normf = 0.0f;
        for (i = 0; i < xycard.length; ++i) {
            this.XY[i][0] = xycard[i][0];
            this.XY[i][1] = xycard[i][1];
            this.XY[i][2] = xycard[i][2];
            this.f[i] = (float)xycard[i][3];
            normf += this.f[i];
        }
        for (i = 0; i < this.f.length; ++i) {
            this.f[i] = this.f[i] / normf;
        }
    }

    private void build() {
        if (this.width_constant[0] > 0.0) {
            this.topNW = new double[this.XY.length][];
            this.topNE = new double[this.XY.length][];
            this.topSW = new double[this.XY.length][];
            this.topSE = new double[this.XY.length][];
            this.botNW = new double[this.XY.length][];
            this.botNE = new double[this.XY.length][];
            this.botSW = new double[this.XY.length][];
            this.botSE = new double[this.XY.length][];
            for (int i = 0; i < this.XY.length; ++i) {
                this.topNW[i] = new double[]{this.XY[i][0] - this.width_constant[0] / 2.0, this.XY[i][1] + this.width_constant[1] / 2.0, this.XY[i][2] + this.width_constant[2] / 2.0};
                this.topNE[i] = new double[]{this.XY[i][0] + this.width_constant[0] / 2.0, this.XY[i][1] + this.width_constant[1] / 2.0, this.XY[i][2] + this.width_constant[2] / 2.0};
                this.topSW[i] = new double[]{this.XY[i][0] - this.width_constant[0] / 2.0, this.XY[i][1] - this.width_constant[1] / 2.0, this.XY[i][2] + this.width_constant[2] / 2.0};
                this.topSE[i] = new double[]{this.XY[i][0] + this.width_constant[0] / 2.0, this.XY[i][1] - this.width_constant[1] / 2.0, this.XY[i][2] + this.width_constant[2] / 2.0};
                this.botNW[i] = new double[]{this.XY[i][0] - this.width_constant[0] / 2.0, this.XY[i][1] + this.width_constant[1] / 2.0, this.XY[i][2] - this.width_constant[2] / 2.0};
                this.botNE[i] = new double[]{this.XY[i][0] + this.width_constant[0] / 2.0, this.XY[i][1] + this.width_constant[1] / 2.0, this.XY[i][2] - this.width_constant[2] / 2.0};
                this.botSW[i] = new double[]{this.XY[i][0] - this.width_constant[0] / 2.0, this.XY[i][1] - this.width_constant[1] / 2.0, this.XY[i][2] - this.width_constant[2] / 2.0};
                this.botSE[i] = new double[]{this.XY[i][0] + this.width_constant[0] / 2.0, this.XY[i][1] - this.width_constant[1] / 2.0, this.XY[i][2] - this.width_constant[2] / 2.0};
            }
        }
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.visible) {
            return;
        }
        draw.canvas.includeInBounds(this.botSW[0]);
        draw.canvas.includeInBounds(this.topNE[this.XY.length - 1]);
        draw.setColor(c);
        draw.setLineType(1);
        for (int i = 0; i < this.XY.length; ++i) {
            if (!(this.f[i] > 0.0f)) continue;
            draw.fillPolygon(this.f[i], this.topNW[i], this.topNE[i], this.topSE[i], this.topSW[i]);
            draw.fillPolygon(this.f[i], this.botNW[i], this.botNE[i], this.botSE[i], this.botSW[i]);
            draw.fillPolygon(this.f[i], this.botNW[i], this.botNE[i], this.topNE[i], this.topNW[i]);
            draw.fillPolygon(this.f[i], this.botSW[i], this.botSE[i], this.topSE[i], this.topSW[i]);
            draw.fillPolygon(this.f[i], this.botNW[i], this.botSW[i], this.topSW[i], this.topNW[i]);
            draw.fillPolygon(this.f[i], this.botNE[i], this.botSE[i], this.topSE[i], this.topNE[i]);
        }
    }

    @Override
    public void setData(double[][] d) {
        this.datapanel = null;
        this.splitXYf(d);
    }

    @Override
    public double[][] getData() {
        return this.XY;
    }

    @Override
    public double[][] getBounds() {
        double[][] b = new double[][]{Array.min(this.XY), Array.max(this.XY)};
        for (int i = 0; i < b[0].length; ++i) {
            b[0][i] = b[0][i] - this.width_constant[i] / 2.0;
            b[1][i] = b[1][i] + this.width_constant[i] / 2.0;
        }
        return b;
    }

    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        for (double[] XY1 : this.XY) {
            int[] screenCoord = draw.project(XY1);
            if (screenCoord[0] + this.note_precision <= screenCoordTest[0] || screenCoord[0] - this.note_precision >= screenCoordTest[0] || screenCoord[1] + this.note_precision <= screenCoordTest[1] || screenCoord[1] - this.note_precision >= screenCoordTest[1]) continue;
            return XY1;
        }
        return null;
    }

    public static void main(String[] args) {
        double[][] cloud;
        Plot3DPanel p = new Plot3DPanel();
        for (double[] cloud1 : cloud = new double[100][3]) {
            cloud1[0] = Math.random() + Math.random();
            cloud1[1] = Math.random() + Math.random();
            cloud1[2] = Math.random() + Math.random();
        }
        p.addCloudPlot("cloud", Color.RED, cloud, 3, 3, 3);
        double[][] cloud2 = new double[100][3];
        for (int i = 0; i < cloud.length; ++i) {
            cloud2[i][0] = 2.0 + Math.random() + Math.random();
            cloud2[i][1] = 2.0 + Math.random() + Math.random();
            cloud2[i][2] = 2.0 + Math.random() + Math.random();
        }
        p.addCloudPlot("cloud2", Color.RED, cloud2, 3, 3, 3);
        p.setLegendOrientation("South");
        new FrameView(p).setDefaultCloseOperation(3);
    }
}

