/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class CloudPlot2D
extends Plot {
    double[][] NW;
    double[][] NE;
    double[][] SW;
    double[][] SE;
    double[] width_constant = new double[]{-1.0, -1.0};
    double[][] XY;
    float[] f;
    boolean fill_shape = true;

    public CloudPlot2D(String n, Color c, double[][] _XYcard, double wX, double wY) {
        super(n, c);
        this.splitXYf(_XYcard);
        this.width_constant = new double[]{wX, wY};
        this.build();
    }

    private void splitXYf(double[][] xycard) {
        int i;
        this.XY = new double[xycard.length][2];
        this.f = new float[xycard.length];
        float normf = 0.0f;
        for (i = 0; i < xycard.length; ++i) {
            this.XY[i][0] = xycard[i][0];
            this.XY[i][1] = xycard[i][1];
            this.f[i] = (float)xycard[i][2];
            normf += this.f[i];
        }
        for (i = 0; i < this.f.length; ++i) {
            this.f[i] = this.f[i] / normf;
        }
    }

    private void build() {
        if (this.width_constant[0] > 0.0) {
            this.NW = new double[this.XY.length][];
            this.NE = new double[this.XY.length][];
            this.SW = new double[this.XY.length][];
            this.SE = new double[this.XY.length][];
            for (int i = 0; i < this.XY.length; ++i) {
                this.NW[i] = new double[]{this.XY[i][0] - this.width_constant[0] / 2.0, this.XY[i][1] + this.width_constant[1] / 2.0};
                this.NE[i] = new double[]{this.XY[i][0] + this.width_constant[0] / 2.0, this.XY[i][1] + this.width_constant[1] / 2.0};
                this.SW[i] = new double[]{this.XY[i][0] - this.width_constant[0] / 2.0, this.XY[i][1] - this.width_constant[1] / 2.0};
                this.SE[i] = new double[]{this.XY[i][0] + this.width_constant[0] / 2.0, this.XY[i][1] - this.width_constant[1] / 2.0};
            }
        }
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.visible) {
            return;
        }
        draw.canvas.includeInBounds(this.SW[0]);
        draw.canvas.includeInBounds(this.NE[this.XY.length - 1]);
        draw.setColor(c);
        draw.setLineType(1);
        for (int i = 0; i < this.XY.length; ++i) {
            if (!(this.f[i] > 0.0f)) continue;
            draw.fillPolygon(this.f[i], this.NW[i], this.NE[i], this.SE[i], this.SW[i]);
        }
    }

    @Override
    public void setData(double[][] d) {
        this.datapanel = null;
        this.splitXYf(d);
    }

    @Override
    public double[][] getData() {
        return this.XY;
    }

    @Override
    public double[][] getBounds() {
        double[][] b = new double[][]{Array.min(this.XY), Array.max(this.XY)};
        for (int i = 0; i < b[0].length; ++i) {
            b[0][i] = b[0][i] - this.width_constant[i] / 2.0;
            b[1][i] = b[1][i] + this.width_constant[i] / 2.0;
        }
        return b;
    }

    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        for (double[] XY1 : this.XY) {
            int[] screenCoord = draw.project(XY1);
            if (screenCoord[0] + this.note_precision <= screenCoordTest[0] || screenCoord[0] - this.note_precision >= screenCoordTest[0] || screenCoord[1] + this.note_precision <= screenCoordTest[1] || screenCoord[1] - this.note_precision >= screenCoordTest[1]) continue;
            return XY1;
        }
        return null;
    }

    public static void main(String[] args) {
        double[][] cloud2;
        double[][] cloud;
        Plot2DPanel p = new Plot2DPanel();
        for (double[] cloud1 : cloud = new double[100][2]) {
            cloud1[0] = Math.random() + Math.random();
            cloud1[1] = Math.random() + Math.random();
        }
        p.addCloudPlot("cloud", Color.RED, cloud, 5, 5);
        for (double[] cloud21 : cloud2 = new double[100][2]) {
            cloud21[0] = 2.0 + Math.random() + Math.random();
            cloud21[1] = 2.0 + Math.random() + Math.random();
        }
        p.addCloudPlot("cloud2", Color.RED, cloud2, 5, 5);
        p.setLegendOrientation("South");
        new FrameView(p).setDefaultCloseOperation(3);
    }
}

