/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class BoxPlot2D
extends Plot {
    double[] Xmin;
    double[] Xmax;
    double[] Ymin;
    double[] Ymax;
    double[][] widths;
    double[][] XY;

    public BoxPlot2D(double[][] _XY, double[][] w, Color c, String n) {
        super(n, c);
        this.XY = _XY;
        this.widths = w;
        this.Xmin = new double[this.XY.length];
        this.Xmax = new double[this.XY.length];
        this.Ymin = new double[this.XY.length];
        this.Ymax = new double[this.XY.length];
        for (int i = 0; i < this.XY.length; ++i) {
            this.Xmin[i] = this.XY[i][0] - this.widths[i][0] / 2.0;
            this.Xmax[i] = this.XY[i][0] + this.widths[i][0] / 2.0;
            this.Ymin[i] = this.XY[i][1] - this.widths[i][1] / 2.0;
            this.Ymax[i] = this.XY[i][1] + this.widths[i][1] / 2.0;
        }
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.visible) {
            return;
        }
        draw.setColor(c);
        draw.setLineType(1);
        for (int i = 0; i < this.XY.length; ++i) {
            draw.drawLine({this.Xmin[i], this.Ymin[i]}, {this.Xmax[i], this.Ymin[i]});
            draw.drawLine({this.Xmax[i], this.Ymin[i]}, {this.Xmax[i], this.Ymax[i]});
            draw.drawLine({this.Xmax[i], this.Ymax[i]}, {this.Xmin[i], this.Ymax[i]});
            draw.drawLine({this.Xmin[i], this.Ymax[i]}, {this.Xmin[i], this.Ymin[i]});
            draw.setDotType(1);
            draw.setDotRadius(2);
            draw.drawDot(this.XY[i]);
        }
    }

    @Override
    public void setData(double[][] d) {
        this.datapanel = null;
        this.XY = d;
    }

    @Override
    public double[][] getData() {
        return this.XY;
    }

    @Override
    public double[][] getBounds() {
        return new double[][]{{Array.min(this.Xmin), Array.min(this.Ymin)}, {Array.max(this.Xmax), Array.max(this.Ymax)}};
    }

    public void setDataWidth(double[][] w) {
        this.widths = w;
    }

    public double[][] getDataWidth() {
        return this.widths;
    }

    public void setData(double[][] d, double[][] w) {
        this.setData(d);
        this.widths = w;
    }

    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        for (double[] XY1 : this.XY) {
            int[] screenCoord = draw.project(XY1);
            if (screenCoord[0] + this.note_precision <= screenCoordTest[0] || screenCoord[0] - this.note_precision >= screenCoordTest[0] || screenCoord[1] + this.note_precision <= screenCoordTest[1] || screenCoord[1] - this.note_precision >= screenCoordTest[1]) continue;
            return XY1;
        }
        return null;
    }
}

