/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.components;

import com.vividsolutions.jump.I18N;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.file.FileSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.math.plot.PlotPanel;
import org.math.plot.canvas.Plot3DCanvas;
import org.math.plot.canvas.PlotCanvas;

public class PlotToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    protected ButtonGroup buttonGroup;
    protected JToggleButton buttonCenter;
    protected JToggleButton buttonZoom;
    protected JToggleButton buttonRotate;
    protected JButton buttonSetScales;
    protected JButton buttonDatas;
    protected JButton buttonSavePNGFile;
    protected JButton buttonReset;
    protected JButton buttonAdjustBounds;
    private boolean denySaveSecurity;
    private JFileChooser pngFileChooser;
    private PlotCanvas plotCanvas;
    private PlotPanel plotPanel;
    boolean adjustBoundsVisible = true;

    public PlotToolBar(PlotPanel pp) {
        this.plotPanel = pp;
        this.plotCanvas = pp.plotCanvas;
        try {
            this.pngFileChooser = new JFileChooser();
            this.pngFileChooser.setFileFilter(new FileFilter(this){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return "Portable Network Graphic (*.png)";
                }
            });
        }
        catch (AccessControlException ace) {
            this.denySaveSecurity = true;
        }
        this.buttonGroup = new ButtonGroup();
        this.buttonCenter = new JToggleButton(IconLoader.svgIcon((String)"common_hand.svg"));
        this.buttonCenter.setToolTipText(I18N.get("org.math.plot.components.PlotToolBar.center-axis"));
        this.buttonCenter.setSelected(this.plotCanvas.ActionMode == 1);
        this.buttonZoom = new JToggleButton(IconLoader.svgIcon((String)"zoom_in.svg"));
        this.buttonZoom.setToolTipText(I18N.get("org.math.plot.components.PlotToolBar.zoom"));
        this.buttonZoom.setSelected(this.plotCanvas.ActionMode == 0);
        this.buttonSetScales = new JButton(IconLoader.svgIcon((String)"common_options.svg"));
        this.buttonSetScales.setToolTipText(I18N.get("org.math.plot.components.PlotToolBar.edit-axis-scales"));
        this.buttonDatas = new JButton(IconLoader.svgIcon((String)"table_show.svg"));
        this.buttonDatas.setToolTipText(I18N.get("org.math.plot.components.PlotToolBar.get-data"));
        this.buttonSavePNGFile = new JButton(IconLoader.svgIcon((String)"common_save.svg"));
        this.buttonSavePNGFile.setToolTipText(I18N.get("org.math.plot.components.PlotToolBar.save-graphics"));
        this.buttonReset = new JButton(IconLoader.svgIcon((String)"zoom_bounds.svg"));
        this.buttonReset.setToolTipText(I18N.get("org.math.plot.components.PlotToolBar.reset"));
        this.buttonAdjustBounds = new JButton(this.plotCanvas.getAdjustBounds() ? IconLoader.svgIcon((String)"common_lock.svg") : IconLoader.svgIcon((String)"common_unlock.svg"));
        this.buttonAdjustBounds.setToolTipText(I18N.get("org.math.plot.components.PlotToolBar.auto-update"));
        this.buttonZoom.setSelected(true);
        this.buttonZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotCanvas.ActionMode = 0;
            }
        });
        this.buttonCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotCanvas.ActionMode = 1;
            }
        });
        this.buttonSetScales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotCanvas.displayScalesFrame();
            }
        });
        this.buttonDatas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotCanvas.displayDataFrame();
            }
        });
        this.buttonSavePNGFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.choosePNGFile();
            }
        });
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotCanvas.resetBase();
            }
        });
        this.buttonAdjustBounds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotCanvas.setAdjustBounds(!PlotToolBar.this.plotCanvas.getAdjustBounds());
                PlotToolBar.this.ajustBoundsChanged();
            }
        });
        this.buttonGroup.add(this.buttonCenter);
        this.buttonGroup.add(this.buttonZoom);
        this.add((Component)this.buttonCenter, null);
        this.add((Component)this.buttonZoom, null);
        this.add((Component)this.buttonReset, null);
        this.add((Component)this.buttonSetScales, null);
        if (this.adjustBoundsVisible) {
            this.add((Component)this.buttonAdjustBounds, null);
        }
        this.add((Component)this.buttonSavePNGFile, null);
        this.add((Component)this.buttonDatas, null);
        if (!this.denySaveSecurity) {
            this.pngFileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotToolBar.this.saveGraphicFile();
                }
            });
        } else {
            this.buttonSavePNGFile.setEnabled(false);
        }
        if (this.plotCanvas instanceof Plot3DCanvas) {
            if (this.buttonRotate == null) {
                this.buttonRotate = new JToggleButton(IconLoader.svgIcon((String)"geometry_rotate.svg"));
                this.buttonRotate.setToolTipText(I18N.get("org.math.plot.components.PlotToolBar.rotate-axes"));
                this.buttonRotate.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PlotToolBar.this.plotCanvas.ActionMode = 2;
                    }
                });
                this.buttonGroup.add(this.buttonRotate);
                this.add(this.buttonRotate, null, 2);
                this.buttonRotate.setSelected(this.plotCanvas.ActionMode == 2);
            } else {
                this.buttonRotate.setEnabled(true);
            }
        } else if (this.buttonRotate != null) {
            if (this.plotCanvas.ActionMode == 2) {
                this.plotCanvas.ActionMode = 0;
            }
            this.buttonRotate.setEnabled(false);
        }
    }

    void choosePNGFile() {
        this.pngFileChooser.showSaveDialog(this);
    }

    void saveGraphicFile() {
        File file = this.pngFileChooser.getSelectedFile();
        file = FileSupport.addExtension((File)file, (String)"png");
        try {
            this.plotPanel.toGraphicFile(file);
        }
        catch (IOException e) {
            JOptionPane.showConfirmDialog(null, I18N.get("org.math.plot.components.PlotToolBar.save-graphics-error") + " : " + e.getMessage(), I18N.get("common.error"), -1, 0);
        }
    }

    public void viewAdjustBounds(boolean visible) {
        if (visible && !this.adjustBoundsVisible) {
            this.add((Component)this.buttonAdjustBounds, null);
            this.adjustBoundsVisible = true;
        }
        if (!visible && this.adjustBoundsVisible) {
            this.remove(this.buttonAdjustBounds);
            this.adjustBoundsVisible = false;
        }
        this.ajustBoundsChanged();
    }

    public void ajustBoundsChanged() {
        this.buttonAdjustBounds.setIcon(this.plotCanvas.getAdjustBounds() ? IconLoader.svgIcon((String)"common_lock.svg") : IconLoader.svgIcon((String)"common_unlock.svg"));
    }
}

