/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.components;

import com.vividsolutions.jump.I18N;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.file.FileSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.AccessControlException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JToolBar;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.math.plot.DataPanel;

public class DataToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    protected JButton buttonPasteToClipboard;
    protected JButton buttonSaveFile;
    private boolean denySaveSecurity;
    private JFileChooser fileChooser;
    private DataPanel dataPanel;

    public DataToolBar(DataPanel dp) {
        this.dataPanel = dp;
        try {
            this.fileChooser = new JFileChooser();
        }
        catch (AccessControlException ace) {
            this.denySaveSecurity = true;
        }
        this.buttonPasteToClipboard = new JButton(IconLoader.svgIcon((String)"common_copy.svg"));
        this.buttonPasteToClipboard.setToolTipText(I18N.get("org.math.plot.components.DataToolBar.copy"));
        this.buttonSaveFile = new JButton(IconLoader.svgIcon((String)"common_save.svg"));
        this.buttonSaveFile.setToolTipText(I18N.get("org.math.plot.components.DataToolBar.save"));
        this.buttonPasteToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolBar.this.dataPanel.toClipBoard();
            }
        });
        this.buttonSaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolBar.this.chooseFile();
            }
        });
        this.add((Component)this.buttonPasteToClipboard, null);
        this.add((Component)this.buttonSaveFile, null);
        if (!this.denySaveSecurity) {
            this.fileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataToolBar.this.saveFile();
                }
            });
        } else {
            this.buttonSaveFile.setEnabled(false);
        }
    }

    void saveFile() {
        File file = this.fileChooser.getSelectedFile();
        if (StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)file.getName()))) {
            file = FileSupport.addExtension((File)file, (String)"txt");
        }
        this.dataPanel.toASCIIFile(file);
    }

    void chooseFile() {
        this.fileChooser.showSaveDialog(this);
    }
}

