/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.components.LegendPanel;
import org.math.plot.components.PlotToolBar;
import org.math.plot.plotObjects.Axis;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.plots.Plot;

public abstract class PlotPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public PlotToolBar plotToolBar;
    public PlotCanvas plotCanvas;
    public LegendPanel plotLegend;
    public static final String EAST = "East";
    public static final String SOUTH = "South";
    public static final String NORTH = "North";
    public static final String WEST = "West";
    public static final String INVISIBLE = "INVISIBLE";
    public static final String SCATTER = "SCATTER";
    public static final String LINE = "LINE";
    public static final String BAR = "BAR";
    public static final String HISTOGRAM = "HISTOGRAM";
    public static final String BOX = "BOX";
    public static final String STAIRCASE = "STAIRCASE";
    public static final String GRID = "GRID";
    public static final Color[] COLORLIST = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.YELLOW, Color.ORANGE, Color.PINK, Color.CYAN, Color.MAGENTA};
    private Font font = UIManager.getFont("Label.font");

    public PlotPanel(PlotCanvas _canvas, String legendOrientation) {
        this.plotCanvas = _canvas;
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.addPlotToolBar(NORTH);
        this.addLegend(legendOrientation);
        this.add((Component)this.plotCanvas, "Center");
    }

    public PlotPanel(PlotCanvas _canvas) {
        this(_canvas, INVISIBLE);
    }

    public void addLegend(String location) {
        if (location.equalsIgnoreCase(EAST)) {
            this.plotLegend = new LegendPanel(this, LegendPanel.VERTICAL);
            this.add((Component)this.plotLegend, EAST);
        } else if (location.equalsIgnoreCase(SOUTH)) {
            this.plotLegend = new LegendPanel(this, LegendPanel.HORIZONTAL);
            this.add((Component)this.plotLegend, SOUTH);
        } else if (location.equalsIgnoreCase(WEST)) {
            this.plotLegend = new LegendPanel(this, LegendPanel.VERTICAL);
            this.add((Component)this.plotLegend, WEST);
        } else if (location.equalsIgnoreCase(NORTH)) {
            this.plotLegend = new LegendPanel(this, LegendPanel.HORIZONTAL);
            this.add((Component)this.plotLegend, NORTH);
        } else if (location.equalsIgnoreCase(INVISIBLE)) {
            this.plotLegend = new LegendPanel(this, LegendPanel.INVISIBLE);
        } else {
            System.err.println("Orientation " + location + " is unknonw.");
        }
    }

    public void removeLegend() {
        this.remove(this.plotLegend);
    }

    public void setLegendOrientation(String location) {
        this.removeLegend();
        this.addLegend(location);
    }

    public void addPlotToolBar(String location) {
        if (location.equalsIgnoreCase(EAST)) {
            this.removePlotToolBar();
            this.plotToolBar = new PlotToolBar(this);
            this.plotToolBar.setFloatable(false);
            this.add((Component)this.plotToolBar, EAST);
        } else if (location.equalsIgnoreCase(SOUTH)) {
            this.removePlotToolBar();
            this.plotToolBar = new PlotToolBar(this);
            this.plotToolBar.setFloatable(false);
            this.add((Component)this.plotToolBar, SOUTH);
        } else if (location.equalsIgnoreCase(WEST)) {
            this.removePlotToolBar();
            this.plotToolBar = new PlotToolBar(this);
            this.plotToolBar.setFloatable(false);
            this.add((Component)this.plotToolBar, WEST);
        } else if (location.equalsIgnoreCase(NORTH)) {
            this.removePlotToolBar();
            this.plotToolBar = new PlotToolBar(this);
            this.plotToolBar.setFloatable(false);
            this.add((Component)this.plotToolBar, NORTH);
        } else {
            System.err.println("Location " + location + " is unknonw.");
        }
    }

    public void removePlotToolBar() {
        if (this.plotToolBar == null) {
            return;
        }
        this.remove(this.plotToolBar);
    }

    public void setPlotToolBarOrientation(String location) {
        this.addPlotToolBar(location);
    }

    public PlotToolBar getPlotToolBar() {
        return this.plotToolBar;
    }

    public void setAdjustBounds(boolean adjust) {
        this.plotCanvas.setAdjustBounds(adjust);
        if (this.plotToolBar != null) {
            this.plotToolBar.ajustBoundsChanged();
        }
    }

    public void setActionMode(int am) {
        this.plotCanvas.setActionMode(am);
    }

    public void setNoteCoords(boolean b) {
        this.plotCanvas.setNoteCoords(b);
    }

    public void setEditable(boolean b) {
        this.plotCanvas.setEditable(b);
    }

    public boolean getEditable() {
        return this.plotCanvas.getEditable();
    }

    public void setNotable(boolean b) {
        this.plotCanvas.setNotable(b);
    }

    public boolean getNotable() {
        return this.plotCanvas.getNotable();
    }

    public LinkedList<Plot> getPlots() {
        return this.plotCanvas.getPlots();
    }

    public Plot getPlot(int i) {
        return this.plotCanvas.getPlot(i);
    }

    public int getPlotIndex(Plot p) {
        return this.plotCanvas.getPlotIndex(p);
    }

    public LinkedList<Plotable> getPlotables() {
        return this.plotCanvas.getPlotables();
    }

    public Plotable getPlotable(int i) {
        return this.plotCanvas.getPlotable(i);
    }

    public Axis getAxis(int i) {
        return this.plotCanvas.getGrid().getAxis(i);
    }

    public String[] getAxisScales() {
        return this.plotCanvas.getAxisScales();
    }

    public void setAxisLabels(String ... labels) {
        this.plotCanvas.setAxisLabels(labels);
    }

    public void setAxisLabel(int axe, String label) {
        this.plotCanvas.setAxisLabel(axe, label);
    }

    public void setAxisScales(String ... scales) {
        this.plotCanvas.setAxisScales(scales);
    }

    public void setAxisScale(int axe, String scale) {
        this.plotCanvas.setAxiScale(axe, scale);
    }

    public void setFixedBounds(double[] min, double[] max) {
        this.plotCanvas.setFixedBounds(min, max);
    }

    public void setFixedBounds(int axe, double min, double max) {
        this.plotCanvas.setFixedBounds(axe, min, max);
    }

    public void includeInBounds(double ... into) {
        this.plotCanvas.includeInBounds(into);
    }

    public void includeInBounds(Plot plot) {
        this.plotCanvas.includeInBounds(plot);
    }

    public void setAutoBounds() {
        this.plotCanvas.setAutoBounds();
    }

    public void setAutoBounds(int axe) {
        this.plotCanvas.setAutoBounds(axe);
    }

    public double[][] mapData(Object[][] stringdata) {
        return this.plotCanvas.mapData(stringdata);
    }

    public void resetMapData() {
        this.plotCanvas.resetMapData();
    }

    public void addLabel(String text, Color c, double ... where) {
        this.plotCanvas.addLabel(text, c, where);
    }

    public void addBaseLabel(String text, Color c, double ... where) {
        this.plotCanvas.addBaseLabel(text, c, where);
    }

    public void addPlotable(Plotable p) {
        this.plotCanvas.addPlotable(p);
    }

    public void removePlotable(Plotable p) {
        this.plotCanvas.removePlotable(p);
    }

    public void removePlotable(int i) {
        this.plotCanvas.removePlotable(i);
    }

    public void removeAllPlotables() {
        this.plotCanvas.removeAllPlotables();
    }

    public int addPlot(Plot newPlot) {
        return this.plotCanvas.addPlot(newPlot);
    }

    protected Color getNewColor() {
        return COLORLIST[this.plotCanvas.plots.size() % COLORLIST.length];
    }

    public int addPlot(String type, String name, double[] ... v) {
        return this.addPlot(type, name, this.getNewColor(), v);
    }

    public abstract int addPlot(String var1, String var2, Color var3, double[] ... var4);

    public void setPlot(int I, Plot p) {
        this.plotCanvas.setPlot(I, p);
    }

    public void changePlotData(int I, double[] ... XY) {
        this.plotCanvas.changePlotData(I, XY);
    }

    public void changePlotName(int I, String name) {
        this.plotCanvas.changePlotName(I, name);
    }

    public void changePlotColor(int I, Color c) {
        this.plotCanvas.changePlotColor(I, c);
    }

    public void removePlot(int I) {
        this.plotCanvas.removePlot(I);
    }

    public void removePlot(Plot p) {
        this.plotCanvas.removePlot(p);
    }

    public void removeAllPlots() {
        this.plotCanvas.removeAllPlots();
    }

    public void addVectortoPlot(int numPlot, double[][] v) {
        this.plotCanvas.addVectortoPlot(numPlot, v);
    }

    public void addQuantiletoPlot(int numPlot, int numAxe, double rate, boolean symetric, double[] q) {
        this.plotCanvas.addQuantiletoPlot(numPlot, numAxe, rate, symetric, q);
    }

    public void addQuantiletoPlot(int numPlot, int numAxe, double rate, boolean symetric, double q) {
        this.plotCanvas.addQuantiletoPlot(numPlot, numAxe, rate, symetric, q);
    }

    public void addQuantilestoPlot(int numPlot, int numAxe, double[][] q) {
        this.plotCanvas.addQuantilestoPlot(numPlot, numAxe, q);
    }

    public void addQuantilestoPlot(int numPlot, int numAxe, double[] q) {
        this.plotCanvas.addQuantilestoPlot(numPlot, numAxe, q);
    }

    public void addGaussQuantilestoPlot(int numPlot, int numAxe, double[] s) {
        this.plotCanvas.addGaussQuantilestoPlot(numPlot, numAxe, s);
    }

    public void addGaussQuantilestoPlot(int numPlot, int numAxe, double s) {
        this.plotCanvas.addGaussQuantilestoPlot(numPlot, numAxe, s);
    }

    public void toGraphicFile(File file) throws IOException {
        this.plotToolBar.setVisible(false);
        Image image = this.createImage(this.getWidth(), this.getHeight());
        this.paint(image.getGraphics());
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, Color.WHITE, null);
        g.dispose();
        this.plotToolBar.setVisible(true);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }
}

