/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.math.plot.FrameView;
import org.math.plot.Plot3DPanel;
import org.math.plot.utils.Array;

public class DataSelectPanel
extends JPanel {
    private static final long serialVersionUID = 419181752327223313L;
    ParameterRow[] rows;
    private Object[][] _data;
    private Object[][] _selecteddata;
    private LinkedList<Object[]> _tmpselecteddata;
    boolean dataUpdated = false;
    private int[] _tmpselectedIndex;
    private int _nbselected;
    private int[] _selectedindex;
    private final String[] _parametersNames;
    int _dimension;
    public final Font font = UIManager.getFont("Label.font");
    public int row_height = 60;
    public int row_width = 300;

    void autoSelectVariableParam() {
        int d = 0;
        for (int i = 0; i < this._data[0].length; ++i) {
            boolean constant = true;
            String val = this._data[0][i].toString();
            for (int j = 1; j < this._data.length; ++j) {
                if (this._data[j][i].toString().equals(val)) continue;
                constant = false;
                break;
            }
            if (constant || this._dimension <= d) continue;
            if (d == 0) {
                this.selectAsX(i);
                ++d;
                continue;
            }
            if (d == 1) {
                this.selectAsY(i);
                ++d;
                continue;
            }
            if (d != 2) continue;
            this.selectAsZ(i);
            break;
        }
    }

    public DataSelectPanel(Object[][] data, int dimension, String ... parametersNames) {
        this._data = data;
        this._dimension = dimension;
        this._parametersNames = parametersNames;
        if (this._dimension > parametersNames.length) {
            throw new IllegalArgumentException("Number of parameters must be > to dimension=" + this._dimension);
        }
        this.setLayout(new GridLayout(this._parametersNames.length, 1));
        if (this._dimension == 0) {
            this.buildRows(new int[0]);
        } else if (this._dimension == 1) {
            this.buildRows(0);
        } else if (this._dimension == 2) {
            this.buildRows(0, 1);
        } else if (this._dimension == 3) {
            this.buildRows(0, 1, 2);
        }
        this.fireSelectedDataChanged("init");
    }

    void buildRows(int ... selectedaxis) {
        ButtonGroup xgrp = new ButtonGroup();
        ButtonGroup ygrp = new ButtonGroup();
        ButtonGroup zgrp = new ButtonGroup();
        this.rows = new ParameterRow[this._parametersNames.length];
        for (int i = 0; i < this._parametersNames.length; ++i) {
            this.rows[i] = new ParameterRow(this._parametersNames[i], DataSelectPanel.getColumn(i, this._data));
            if (selectedaxis != null && selectedaxis.length > 0) {
                if (selectedaxis.length >= 1) {
                    this.rows[i].xaxis.setSelected(selectedaxis[0] == i);
                }
                if (selectedaxis.length >= 2) {
                    this.rows[i].yaxis.setSelected(selectedaxis[1] == i);
                }
                if (selectedaxis.length == 3) {
                    this.rows[i].zaxis.setSelected(selectedaxis[2] == i);
                }
            }
            xgrp.add(this.rows[i].xaxis);
            ygrp.add(this.rows[i].yaxis);
            zgrp.add(this.rows[i].zaxis);
            this.add(this.rows[i]);
        }
        this.setPreferredSize(new Dimension(this.row_width, this.row_height * this._parametersNames.length));
        this.setSize(new Dimension(this.row_width, this.row_height * this._parametersNames.length));
        this.autoSelectVariableParam();
        this.updateSelectedData();
    }

    public void setData(Object[][] data) {
        if (data[0].length != this._data[0].length) {
            throw new IllegalArgumentException("new data dimension is not consistent with previous one.");
        }
        this._data = data;
        int[] selectedaxis = new int[this._dimension];
        for (int i = 0; i < this.rows.length; ++i) {
            if (selectedaxis.length >= 1 && this.rows[i].xaxis.isSelected()) {
                selectedaxis[0] = i;
            }
            if (selectedaxis.length >= 2 && this.rows[i].yaxis.isSelected()) {
                selectedaxis[1] = i;
            }
            if (selectedaxis.length == 3 && this.rows[i].zaxis.isSelected()) {
                selectedaxis[2] = i;
            }
            this.remove(this.rows[i]);
        }
        this.dataUpdated = false;
        this.buildRows(selectedaxis);
        this.fireSelectedDataChanged("set");
    }

    void updateSelectedData() {
        if (this.dataUpdated) {
            return;
        }
        for (ParameterRow row : this.rows) {
            boolean isaxis;
            boolean bl = isaxis = row.xaxis.isSelected() || row.yaxis.isSelected() || row.zaxis.isSelected();
            if (row._isNumber) {
                row.min.setEnabled(!isaxis);
                row.max.setEnabled(!isaxis);
            } else {
                row.list.setEnabled(!isaxis);
            }
            if (!isaxis) {
                if (row._isNumber) {
                    row.name.setText(row._paramName + "=[" + row._kernelDoubleValues[row.min.getValue() - 1] + "," + row._kernelDoubleValues[row.max.getValue() - 1] + "]");
                    continue;
                }
                row.name.setText(row._paramName + "={" + Array.cat(row.list.getSelectedValues()) + "}");
                continue;
            }
            row.name.setText(row._paramName);
        }
        this._tmpselectedIndex = new int[this._data.length];
        this._nbselected = 0;
        this._tmpselecteddata = new LinkedList();
        for (int i = 0; i < this._data.length; ++i) {
            boolean sel = true;
            for (int j = 0; j < this.rows.length; ++j) {
                ParameterRow row;
                row = this.rows[j];
                if (row.xaxis.isSelected() || row.yaxis.isSelected() || row.zaxis.isSelected() || row.check(this._data[i][j])) continue;
                sel = false;
            }
            if (!sel) continue;
            this._tmpselecteddata.add(this._data[i]);
            this._tmpselectedIndex[this._nbselected] = i;
            ++this._nbselected;
        }
        this.dataUpdated = true;
    }

    public void fireSelectedDataChanged(String from) {
        System.err.println("fireSelectedDataChanged from " + from);
        Object[][] sel = this.getSelectedFullData();
        System.err.println("selected full data :");
        System.err.println(Array.cat(this._parametersNames));
        if (sel.length > 0) {
            System.err.println(Array.cat(this.getSelectedFullData()));
        }
        sel = this.getSelectedProjectedData();
        System.err.println("selected projected data :");
        switch (this._dimension) {
            case 0: {
                System.err.println("No axis selected");
                break;
            }
            case 1: {
                System.err.println(Array.cat(new String[]{this.getSelectedXAxis()}));
                break;
            }
            case 2: {
                System.err.println(Array.cat(new String[]{this.getSelectedXAxis(), this.getSelectedYAxis()}));
                break;
            }
            case 3: {
                System.err.println(Array.cat(new String[]{this.getSelectedXAxis(), this.getSelectedYAxis(), this.getSelectedZAxis()}));
            }
        }
        if (sel.length > 0) {
            System.err.println(Array.cat(sel));
        }
        System.err.println("Done.");
    }

    public int[] getSelectedDataIndex() {
        this.updateSelectedData();
        this._selectedindex = new int[this._nbselected];
        for (int i = 0; i < this._nbselected; ++i) {
            this._selectedindex[i] = this._tmpselectedIndex[i];
        }
        return this._selectedindex;
    }

    public Object[][] getSelectedFullData() {
        this.updateSelectedData();
        this._selecteddata = new Object[this._tmpselecteddata.size()][this._data[0].length];
        for (int i = 0; i < this._selecteddata.length; ++i) {
            for (int j = 0; j < this._selecteddata[i].length; ++j) {
                this._selecteddata[i][j] = this._tmpselecteddata.get(i)[j];
            }
        }
        return this._selecteddata;
    }

    public Object[][] getSelectedProjectedData() {
        int[] selectedaxis = this.getSelectedAxisIndex();
        this._selecteddata = new Object[this._tmpselecteddata.size()][this._dimension];
        for (int i = 0; i < this._selecteddata.length; ++i) {
            for (int j = 0; j < this._dimension; ++j) {
                this._selecteddata[i][j] = this._tmpselecteddata.get(i)[selectedaxis[j]];
            }
        }
        return this._selecteddata;
    }

    public int[] getSelectedAxisIndex() {
        int[] selectedaxis = new int[this._dimension];
        this.updateSelectedData();
        for (int i = 0; i < this.rows.length; ++i) {
            if (this.rows[i].xaxis.isSelected()) {
                selectedaxis[0] = i;
            }
            if (this.rows[i].yaxis.isSelected()) {
                selectedaxis[1] = i;
            }
            if (!this.rows[i].zaxis.isSelected()) continue;
            selectedaxis[2] = i;
        }
        return selectedaxis;
    }

    public String getSelectedXAxis() {
        this.updateSelectedData();
        for (ParameterRow row : this.rows) {
            if (!row.xaxis.isSelected()) continue;
            return row._paramName;
        }
        return null;
    }

    public String getSelectedYAxis() {
        this.updateSelectedData();
        for (ParameterRow row : this.rows) {
            if (!row.yaxis.isSelected()) continue;
            return row._paramName;
        }
        return null;
    }

    public String getSelectedZAxis() {
        this.updateSelectedData();
        for (ParameterRow row : this.rows) {
            if (!row.zaxis.isSelected()) continue;
            return row._paramName;
        }
        return null;
    }

    static Object[] getColumn(int j, Object[][] mat) {
        Object[] col = new Object[mat.length];
        for (int i = 0; i < col.length; ++i) {
            col[i] = mat[i][j];
        }
        return col;
    }

    public void selectAsX(int row) {
        this.rows[row].selectAsX();
    }

    public void selectAsY(int row) {
        this.rows[row].selectAsY();
    }

    public void selectAsZ(int row) {
        this.rows[row].selectAsZ();
    }

    public static void main(String[] args) {
        final Plot3DPanel pp = new Plot3DPanel("West");
        pp.setPreferredSize(new Dimension(400, 400));
        new FrameView(pp).setDefaultCloseOperation(3);
        Object[][] data = new Object[][]{{1, 3, 4, 5, "a0"}, {1, 3, 1, 1, "a1"}, {1, 3, 2, 2, "a2"}, {1, 3, 3, 3, "a5"}, {1, 3, 3, 3, "a3"}, {1.5, 3.5, 3, 4, "a2"}};
        DataSelectPanel dsp3 = new DataSelectPanel(data, 3, new String[]{"x1", "x2", "x3", "x4", "x5"}){
            private static final long serialVersionUID = 1L;

            @Override
            public void fireSelectedDataChanged(String from) {
                super.fireSelectedDataChanged(from);
                pp.setAxisLabel(0, this.getSelectedXAxis());
                pp.setAxisLabel(1, this.getSelectedYAxis());
                pp.setAxisLabel(2, this.getSelectedZAxis());
                System.err.println("plotting ...");
                if (pp.getPlots().size() == 0) {
                    System.err.println("   new");
                    pp.addPlot("SCATTER", "data", pp.mapData(this.getSelectedProjectedData()));
                } else {
                    System.err.println(" existing");
                    if (from != null && from.endsWith("axis")) {
                        pp.resetMapData();
                        pp.removeAllPlots();
                        pp.addPlot("SCATTER", "data", pp.mapData(this.getSelectedProjectedData()));
                    } else {
                        pp.getPlot(0).setData(pp.mapData(this.getSelectedProjectedData()));
                    }
                }
            }
        };
        JFrame f3 = new JFrame("Test mat editor 3");
        f3.setContentPane(dsp3);
        f3.pack();
        f3.setVisible(true);
        f3.setDefaultCloseOperation(3);
    }

    class ParameterRow
    extends JPanel {
        String _paramName;
        JLabel name;
        JRadioButton xaxis;
        JRadioButton yaxis;
        JRadioButton zaxis;
        JComponent parameter;
        JSlider min;
        JSlider max;
        JCheckBox linkminmax;
        JList list;
        Vector<Object> _kernelStringValues;
        boolean _isNumber;
        double[] _kernelDoubleValues;

        public void selectAsX() {
            this.xaxis.setSelected(true);
            this.yaxis.setSelected(false);
            this.zaxis.setSelected(false);
            for (ParameterRow r : DataSelectPanel.this.rows) {
                if (r._paramName.equals(this._paramName)) continue;
                r.xaxis.setSelected(false);
            }
            DataSelectPanel.this.dataUpdated = false;
            DataSelectPanel.this.fireSelectedDataChanged(this._paramName + " xaxis");
        }

        public void selectAsY() {
            this.xaxis.setSelected(false);
            this.yaxis.setSelected(true);
            this.zaxis.setSelected(false);
            for (ParameterRow r : DataSelectPanel.this.rows) {
                if (r._paramName.equals(this._paramName)) continue;
                r.yaxis.setSelected(false);
            }
            DataSelectPanel.this.dataUpdated = false;
            DataSelectPanel.this.fireSelectedDataChanged(this._paramName + " yaxis");
        }

        public void selectAsZ() {
            this.xaxis.setSelected(false);
            this.yaxis.setSelected(false);
            this.zaxis.setSelected(true);
            for (ParameterRow r : DataSelectPanel.this.rows) {
                if (r._paramName.equals(this._paramName)) continue;
                r.zaxis.setSelected(false);
            }
            DataSelectPanel.this.dataUpdated = false;
            DataSelectPanel.this.fireSelectedDataChanged(this._paramName + " zaxis");
        }

        public ParameterRow(String paramName, Object[] values) {
            this._paramName = paramName;
            this._isNumber = Array.isDouble(values[0].toString());
            if (!this._isNumber) {
                this._kernelStringValues = new Vector(values.length);
                for (Object value : values) {
                    if (this._kernelStringValues.contains(value)) continue;
                    this._kernelStringValues.add(value);
                }
            } else {
                Vector<Double> _tmpdvalues = new Vector<Double>(values.length);
                for (Object value : values) {
                    if (_tmpdvalues.contains(Double.valueOf(value.toString()))) continue;
                    _tmpdvalues.add(Double.valueOf(value.toString()));
                }
                this._kernelDoubleValues = new double[_tmpdvalues.size()];
                for (int i = 0; i < this._kernelDoubleValues.length; ++i) {
                    this._kernelDoubleValues[i] = (Double)_tmpdvalues.get(i);
                }
                new Sorting(this, this._kernelDoubleValues, false);
            }
            this.setLayout(new GridLayout(1, 2));
            this.name = new JLabel(this._paramName);
            this.name.setFont(DataSelectPanel.this.font);
            JPanel left = new JPanel(new BorderLayout());
            left.add((Component)this.name, "Center");
            this.add((Component)left, 0);
            JPanel right = new JPanel(new BorderLayout());
            JPanel XYZ = new JPanel();
            if (DataSelectPanel.this._dimension > 0) {
                XYZ = new JPanel(new GridLayout(DataSelectPanel.this._dimension, 1));
            }
            this.xaxis = new JRadioButton("X");
            this.xaxis.setFont(DataSelectPanel.this.font);
            this.xaxis.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParameterRow.this.selectAsX();
                }
            });
            if (DataSelectPanel.this._dimension >= 1) {
                XYZ.add(this.xaxis);
            }
            this.yaxis = new JRadioButton("Y");
            this.yaxis.setFont(DataSelectPanel.this.font);
            this.yaxis.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParameterRow.this.selectAsY();
                }
            });
            if (DataSelectPanel.this._dimension >= 2) {
                XYZ.add(this.yaxis);
            }
            this.zaxis = new JRadioButton("Z");
            this.zaxis.setFont(DataSelectPanel.this.font);
            this.zaxis.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParameterRow.this.selectAsZ();
                }
            });
            if (DataSelectPanel.this._dimension == 3) {
                XYZ.add(this.zaxis);
            }
            left.add((Component)XYZ, "East");
            if (this._isNumber) {
                this.parameter = new JPanel();
                this.parameter.setLayout(new GridLayout(2, 1));
                this.min = new JSlider(1, this._kernelDoubleValues.length, 1);
                this.min.setFont(DataSelectPanel.this.font);
                this.min.setMinorTickSpacing(1);
                this.min.setSnapToTicks(true);
                this.min.setPaintTicks(true);
                this.max = new JSlider(1, this._kernelDoubleValues.length, this._kernelDoubleValues.length);
                this.max.setFont(DataSelectPanel.this.font);
                this.max.setMinorTickSpacing(1);
                this.max.setSnapToTicks(true);
                this.max.setPaintTicks(true);
                this.min.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (ParameterRow.this.max.getValue() < ParameterRow.this.min.getValue()) {
                            ParameterRow.this.max.setValue(ParameterRow.this.min.getValue());
                        }
                        DataSelectPanel.this.dataUpdated = false;
                        DataSelectPanel.this.fireSelectedDataChanged(ParameterRow.this._paramName + " min");
                    }
                });
                this.max.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (ParameterRow.this.max.getValue() < ParameterRow.this.min.getValue()) {
                            ParameterRow.this.min.setValue(ParameterRow.this.max.getValue());
                        }
                        DataSelectPanel.this.dataUpdated = false;
                        DataSelectPanel.this.fireSelectedDataChanged(ParameterRow.this._paramName + " max");
                    }
                });
                this.parameter.add((Component)this.min, 0);
                this.parameter.add((Component)this.max, 1);
            } else {
                this.list = new JList<Object>(this._kernelStringValues);
                this.list.setFont(DataSelectPanel.this.font);
                this.list.setSelectedIndices(this.buildIntSeq(0, this._kernelStringValues.size() - 1));
                this.list.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        DataSelectPanel.this.dataUpdated = false;
                        DataSelectPanel.this.fireSelectedDataChanged(ParameterRow.this._paramName + " list");
                    }
                });
                this.parameter = new JScrollPane(this.list);
            }
            right.add((Component)this.parameter, "Center");
            this.add((Component)right, 1);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setPreferredSize(new Dimension(DataSelectPanel.this.row_width, DataSelectPanel.this.row_height));
            this.setSize(new Dimension(DataSelectPanel.this.row_width, DataSelectPanel.this.row_height));
        }

        int[] buildIntSeq(int min, int max) {
            int[] seq = new int[max - min + 1];
            for (int i = 0; i < seq.length; ++i) {
                seq[i] = min + i;
            }
            return seq;
        }

        boolean check(Object value) {
            if (this._isNumber) {
                double dval = Double.valueOf(value.toString());
                return dval >= this._kernelDoubleValues[this.min.getValue() - 1] && dval <= this._kernelDoubleValues[this.max.getValue() - 1];
            }
            for (int i = 0; i < this.list.getSelectedIndices().length; ++i) {
                if (!this._kernelStringValues.get(this.list.getSelectedIndices()[i]).equals(value)) continue;
                return true;
            }
            return false;
        }

        public class Sorting {
            private final double[] A;
            private final int[] order;

            public Sorting(ParameterRow this$1, double[] array, boolean copyArray) {
                if (copyArray) {
                    this.A = new double[array.length];
                    System.arraycopy(array, 0, this.A, 0, array.length);
                } else {
                    this.A = array;
                }
                this.order = new int[this.A.length];
                for (int i = 0; i < this.A.length; ++i) {
                    this.order[i] = i;
                }
                this.sort(this.A);
            }

            public int[] invertIndex(int[] ind) {
                int[] invind = new int[ind.length];
                for (int i = 0; i < ind.length; ++i) {
                    invind[ind[i]] = i;
                }
                return invind;
            }

            public int getIndex(int i) {
                return this.order[i];
            }

            public int[] getIndex() {
                return this.order;
            }

            private void QuickSort(double[] a, int lo0, int hi0) {
                int lo = lo0;
                int hi = hi0;
                if (hi0 > lo0) {
                    double mid = a[(lo0 + hi0) / 2];
                    while (lo <= hi) {
                        while (lo < hi0 && a[lo] < mid) {
                            ++lo;
                        }
                        while (hi > lo0 && a[hi] > mid) {
                            --hi;
                        }
                        if (lo > hi) continue;
                        this.swap(a, lo, hi);
                        ++lo;
                        --hi;
                    }
                    if (lo0 < hi) {
                        this.QuickSort(a, lo0, hi);
                    }
                    if (lo < hi0) {
                        this.QuickSort(a, lo, hi0);
                    }
                }
            }

            private void swap(double[] a, int i, int j) {
                double T = a[i];
                a[i] = a[j];
                a[j] = T;
                int t = this.order[i];
                this.order[i] = this.order[j];
                this.order[j] = t;
            }

            private void sort(double[] a) {
                this.QuickSort(a, 0, a.length - 1);
            }
        }
    }
}

