/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import bsh.ParseException;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Methods;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.fife.rsta.ac.AbstractLanguageSupport;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.java.BeanShellCompletionMetadata;
import org.fife.rsta.ac.java.BeanShellSourceCompletionProvider;
import org.fife.rsta.ac.java.JarManager;
import org.fife.rsta.ac.java.JavaCellRenderer;
import org.fife.rsta.ac.java.JavaCompletionProvider;
import org.fife.rsta.ac.java.JavaParamListCellRenderer;
import org.fife.rsta.ac.java.JavaParser;
import org.fife.rsta.ac.java.JavadocUrlHandler;
import org.fife.rsta.ac.java.MethodCompletion;
import org.fife.rsta.ac.java.buildpath.ClasspathLibraryInfo;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.rjc.ast.CodeBlock;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rtextarea.ToolTipSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanShellLanguageSupport
extends AbstractLanguageSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BeanShellLanguageSupport.class);
    public static final String SYNTAX_STYLE_BEANSHELL = "text/bsh";
    private final Map<JavaParser, Info> parserToInfoMap = new HashMap<JavaParser, Info>();
    private static final String PROPERTY_LANGUAGE_JAVA_PARSER = "BeanShellLanguageSupport.JAVA_PARSER";
    private static final String PROPERTY_COMPLETION_METADATA = "BeanShellLanguageSupport.COMPLETION_METADATA";

    public static void register(RSyntaxTextArea textArea, BeanShellCompletionMetadata info) {
        textArea.putClientProperty((Object)PROPERTY_COMPLETION_METADATA, (Object)info);
        LanguageSupportFactory lsf = LanguageSupportFactory.get();
        lsf.addLanguageSupport(SYNTAX_STYLE_BEANSHELL, BeanShellLanguageSupport.class.getCanonicalName());
        lsf.register(textArea);
        textArea.setSyntaxEditingStyle(SYNTAX_STYLE_BEANSHELL);
    }

    public static void initialSetup() {
        TokenMakerFactory.setDefaultInstance((org.fife.ui.rsyntaxtextarea.TokenMakerFactory)new TokenMakerFactory());
    }

    public BeanShellLanguageSupport() {
        this.setAutoActivationEnabled(true);
        this.setParameterAssistanceEnabled(true);
        this.setShowDescWindow(false);
    }

    public void install(RSyntaxTextArea textArea) {
        JarManager jarManager = new JarManager();
        BeanShellCompletionMetadata completionMetadata = BeanShellLanguageSupport.getCompletionMetadata(textArea);
        textArea.getInputMap().put(KeyStroke.getKeyStroke(55, 128), "RSTA.ToggleCommentAction");
        try {
            List<String> classNames = completionMetadata.getClassImports().stream().map(c -> c.getCanonicalName()).toList();
            jarManager.addClassFileSource((LibraryInfo)new ClasspathLibraryInfo(classNames));
        }
        catch (IOException ex) {
            log.error("Could not setup code editor extras", (Throwable)ex);
        }
        final BeanShellSourceCompletionProvider bshSourceCompletionProvider = new BeanShellSourceCompletionProvider(jarManager, completionMetadata);
        JavaCompletionProvider provider = new JavaCompletionProvider(this, jarManager){

            public CompletionProvider getDefaultCompletionProvider() {
                return bshSourceCompletionProvider;
            }
        };
        BeanShellAutoCompletion ac = new BeanShellAutoCompletion(provider, textArea);
        ac.setListCellRenderer((ListCellRenderer)new JavaCellRenderer());
        ac.setAutoCompleteEnabled(this.isAutoCompleteEnabled());
        ac.setAutoActivationEnabled(this.isAutoActivationEnabled());
        ac.setAutoActivationDelay(this.getAutoActivationDelay());
        ac.setExternalURLHandler((ExternalURLHandler)new JavadocUrlHandler());
        ac.setParameterAssistanceEnabled(this.isParameterAssistanceEnabled());
        ac.setParamChoicesRenderer((ListCellRenderer)new JavaParamListCellRenderer());
        ac.setShowDescWindow(this.getShowDescWindow());
        ac.install((JTextComponent)textArea);
        this.installImpl(textArea, ac);
        textArea.setToolTipSupplier((ToolTipSupplier)provider);
        BeanShellParser parser = new BeanShellParser(completionMetadata.getCodeValidator());
        JavaParser javaParser = new JavaParser(textArea);
        textArea.putClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser", (Object)parser);
        textArea.putClientProperty((Object)PROPERTY_LANGUAGE_JAVA_PARSER, (Object)javaParser);
        textArea.addParser((Parser)parser);
        textArea.setToolTipSupplier((ToolTipSupplier)provider);
        bshSourceCompletionProvider.setJavaProvider(provider);
        Info info = new Info(provider, javaParser);
        this.parserToInfoMap.put(javaParser, info);
    }

    public void uninstall(RSyntaxTextArea textArea) {
        this.uninstallImpl(textArea);
        JavaParser parser = this.getParser(textArea);
        Info info = this.parserToInfoMap.remove(parser);
        if (info != null) {
            parser.removePropertyChangeListener("CompilationUnit", (PropertyChangeListener)info);
        }
        textArea.removeParser((Parser)parser);
        textArea.putClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser", null);
        textArea.putClientProperty((Object)PROPERTY_LANGUAGE_JAVA_PARSER, null);
        textArea.setToolTipSupplier(null);
    }

    private JavaParser getParser(RSyntaxTextArea textArea) {
        return (JavaParser)textArea.getClientProperty((Object)PROPERTY_LANGUAGE_JAVA_PARSER);
    }

    public void insertMethod(RSyntaxTextArea textArea, Class<Methods> clazz, String method, Map<String, String> argumentReplacements) {
        BeanShellAutoCompletion autoCompletion = (BeanShellAutoCompletion)this.getAutoCompletionFor(textArea);
        autoCompletion.insertMethod(clazz, method, argumentReplacements);
    }

    private static BeanShellCompletionMetadata getCompletionMetadata(RSyntaxTextArea textArea) {
        return (BeanShellCompletionMetadata)textArea.getClientProperty((Object)PROPERTY_COMPLETION_METADATA);
    }

    private static class TokenMakerFactory
    extends AbstractTokenMakerFactory
    implements SyntaxConstants {
        private TokenMakerFactory() {
        }

        protected void initTokenMakerMap() {
            String pkg = "org.fife.ui.rsyntaxtextarea.modes.";
            this.putMapping("text/plain", pkg + "PlainTextTokenMaker");
            this.putMapping("text/java", pkg + "JavaTokenMaker");
            this.putMapping(BeanShellLanguageSupport.SYNTAX_STYLE_BEANSHELL, pkg + "JavaTokenMaker");
        }
    }

    private class BeanShellAutoCompletion
    extends AutoCompletion {
        private static final String RETURN_VOID = "void";
        private final RSyntaxTextArea textArea;
        private final String classHeader;
        private final String classFooter;

        BeanShellAutoCompletion(JavaCompletionProvider provider, RSyntaxTextArea textArea) {
            super((CompletionProvider)provider);
            this.textArea = textArea;
            BeanShellCompletionMetadata completionMetadata = BeanShellLanguageSupport.getCompletionMetadata(textArea);
            this.classHeader = completionMetadata.getClassHeader();
            this.classFooter = completionMetadata.getClassFooter();
        }

        protected int refreshPopupWindow() {
            this.parseBeanShell();
            return super.refreshPopupWindow();
        }

        private void parseBeanShell() {
            try {
                JavaParser parser = BeanShellLanguageSupport.this.getParser(this.textArea);
                RSyntaxDocument doc = (RSyntaxDocument)this.textArea.getDocument();
                String style = this.textArea.getSyntaxEditingStyle();
                String text = doc.getText(0, doc.getLength());
                RSyntaxDocument fakeDoc = new RSyntaxDocument(style);
                String fakeJavaClass = this.classHeader + text + this.classFooter;
                fakeDoc.insertString(0, fakeJavaClass, null);
                parser.parse(fakeDoc, style);
            }
            catch (BadLocationException ex) {
                log.warn("Could not extract text for code completion.", (Throwable)ex);
            }
        }

        private void insertMethod(Class<Methods> clazz, String method, Map<String, String> argumentReplacements) {
            String assignment;
            JavaCompletionProvider provider = (JavaCompletionProvider)this.getCompletionProvider();
            BeanShellSourceCompletionProvider bshProvider = (BeanShellSourceCompletionProvider)provider.getDefaultCompletionProvider();
            MethodInfo methodToInsert = (MethodInfo)bshProvider.getJarManager().getClassEntry(clazz.getCanonicalName()).getMethodInfoByName(method).get(0);
            String returnType = methodToInsert.getReturnTypeString(false);
            if (RETURN_VOID.equals(returnType)) {
                assignment = null;
            } else {
                this.parseBeanShell();
                CompilationUnit compilationUnit = provider.getCompilationUnit();
                String unusedVariableName = this.findUnusedVariableName(compilationUnit, returnType.toLowerCase());
                assignment = "%s %s = ".formatted(returnType, unusedVariableName);
            }
            InsertMethodCompletion methodCompletion = new InsertMethodCompletion(BeanShellLanguageSupport.this, (CompletionProvider)bshProvider, methodToInsert, argumentReplacements, assignment);
            this.insertCompletion((Completion)methodCompletion);
        }

        private String findUnusedVariableName(CompilationUnit compilationUnit, String name) {
            Set<String> variableNames = this.getVariableNames(compilationUnit);
            Object nameToTest = name;
            int index = 1;
            while (variableNames.contains(nameToTest)) {
                nameToTest = name + index;
                ++index;
            }
            return nameToTest;
        }

        private Set<String> getVariableNames(CompilationUnit compilationUnit) {
            if (compilationUnit == null) {
                return Collections.emptySet();
            }
            HashSet<String> variableNames = new HashSet<String>();
            compilationUnit.getTypeDeclarationIterator().forEachRemaining(type -> type.getMethodIterator().forEachRemaining(method -> {
                CodeBlock body = method.getBody();
                for (int v = 0; v < body.getLocalVarCount(); ++v) {
                    variableNames.add(body.getLocalVar(v).getName());
                }
            }));
            return variableNames;
        }
    }

    private static class BeanShellParser
    extends AbstractParser {
        private final BeanShellCompletionMetadata.CodeValidator codeValidator;

        public BeanShellParser(BeanShellCompletionMetadata.CodeValidator codeValidator) {
            this.codeValidator = codeValidator;
        }

        public ParseResult parse(RSyntaxDocument doc, String style) {
            DefaultParseResult result = new DefaultParseResult((Parser)this);
            try {
                String code = doc.getText(0, doc.getLength());
                this.codeValidator.validate(code);
            }
            catch (ParseException ex) {
                String warning = StringUtils.removeStart((String)ex.getMessage(true), (String)"In file: <unknown> ");
                int line = ex.currentToken != null ? ex.getErrorLineNumber() : 0;
                Element lineMap = doc.getDefaultRootElement();
                Element lineElement = lineMap.getElement(line - 1);
                int offset = lineElement.getStartOffset();
                int length = lineElement.getEndOffset() - offset - 1;
                result.addNotice((ParserNotice)new DefaultParserNotice((Parser)this, warning, line, offset, length));
            }
            catch (Throwable ex) {
                result.addNotice((ParserNotice)new DefaultParserNotice((Parser)this, ex.getMessage(), 0));
            }
            return result;
        }
    }

    private static class Info
    implements PropertyChangeListener {
        private final JavaCompletionProvider provider;

        Info(JavaCompletionProvider provider, JavaParser parser) {
            this.provider = provider;
            parser.addPropertyChangeListener("CompilationUnit", (PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("CompilationUnit".equals(name)) {
                CompilationUnit cu = (CompilationUnit)e.getNewValue();
                this.provider.setCompilationUnit(cu);
            }
        }
    }

    private class InsertMethodCompletion
    extends MethodCompletion {
        private final Map<String, String> argumentReplacements;
        private final String assignment;

        public InsertMethodCompletion(BeanShellLanguageSupport beanShellLanguageSupport, CompletionProvider provider, MethodInfo info, Map<String, String> argumentReplacements, String assignment) {
            super(provider, info);
            this.argumentReplacements = argumentReplacements;
            this.assignment = assignment;
        }

        public ParameterizedCompletionInsertionInfo getInsertionInfo(JTextComponent tc, boolean replaceTabsWithSpaces) {
            ParameterizedCompletionInsertionInfo info = new ParameterizedCompletionInsertionInfo();
            StringBuilder sb = new StringBuilder();
            char paramListStart = this.getProvider().getParameterListStart();
            if (paramListStart != '\u0000') {
                sb.append(paramListStart);
            }
            int dot = tc.getCaretPosition() + sb.length();
            int paramCount = this.getParamCount();
            Position maxPos = null;
            try {
                maxPos = tc.getDocument().createPosition(dot - sb.length() + 1);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            info.setCaretRange(dot, maxPos);
            int firstParamLen = 0;
            int start = dot;
            for (int i = 0; i < paramCount; ++i) {
                ParameterizedCompletion.Parameter param = this.getParam(i);
                String paramText = this.getParameterText(param);
                if (i == 0) {
                    firstParamLen = paramText.length();
                }
                sb.append(paramText);
                int end = start + paramText.length();
                info.addReplacementLocation(start, end);
                String sep = this.getProvider().getParameterListSeparator();
                if (i >= paramCount - 1 || sep == null) continue;
                sb.append(sep);
                start = end + sep.length();
            }
            char charListEnd = this.getProvider().getParameterListEnd();
            if (charListEnd > '\u0000') {
                sb.append(this.getProvider().getParameterListEnd());
            }
            sb.append(";");
            int endOffs = dot + sb.length();
            info.addReplacementLocation(--endOffs, endOffs);
            info.setDefaultEndOffs(endOffs);
            int selectionEnd = paramCount > 0 ? dot + firstParamLen : dot;
            info.setInitialSelection(dot, selectionEnd);
            info.setTextToInsert(sb.toString());
            return info;
        }

        private String getParameterText(ParameterizedCompletion.Parameter param) {
            String replacement = this.argumentReplacements.get(param.getName());
            if (replacement != null) {
                return replacement;
            }
            return param.getName();
        }

        public String getReplacementText() {
            if (this.assignment == null) {
                return super.getReplacementText();
            }
            return this.assignment + super.getReplacementText();
        }
    }
}

