/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.thread;

import de.riwagis.thread.WatchedThread;
import de.riwagis.thread.event.ThreadEvent;
import de.riwagis.thread.event.ThreadListener;
import java.util.ArrayList;
import java.util.List;

public class ThreadWatchDog
extends Thread
implements ThreadListener {
    private final List<WatchedThread> lstThread = new ArrayList<WatchedThread>();
    private final List<Long> lstTime = new ArrayList<Long>();

    public ThreadWatchDog() {
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(2000L);
                if (this.isInterrupted()) {
                    return;
                }
                long lngTime = System.currentTimeMillis();
                List<WatchedThread> list = this.lstThread;
                synchronized (list) {
                    for (int i = this.lstThread.size() - 1; i > -1; --i) {
                        long lngTimeout = this.lstTime.get(i);
                        WatchedThread currThread = this.lstThread.get(i);
                        if (lngTime > lngTimeout) {
                            try {
                                currThread.interrupt();
                                System.out.println(String.format("Thread Watchdog: Thread '%s' abgebrochen", currThread.getName()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.removeThread(i);
                            --i;
                            continue;
                        }
                        if (currThread.isAlive()) continue;
                        this.removeThread(i);
                        --i;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ThreadEvent event) throws Exception {
        WatchedThread thWatched = event.getThread();
        Long lngTime = System.currentTimeMillis() + (long)thWatched.getTimeout();
        if (this.lstThread.contains(thWatched)) {
            List<Long> list = this.lstTime;
            synchronized (list) {
                int i = this.lstThread.indexOf(thWatched);
                this.lstTime.set(i, lngTime);
            }
        }
        List<Object> list = this.lstThread;
        synchronized (list) {
            this.lstThread.add(thWatched);
        }
        list = this.lstTime;
        synchronized (list) {
            this.lstTime.add(lngTime);
        }
    }

    private synchronized void removeThread(int i) {
        this.lstTime.remove(i);
        this.lstThread.remove(i);
    }
}

