/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.thread;

import de.riwagis.util.thread.CancelableRunnable;
import de.riwagis.util.thread.SimpleThreadFactory;
import de.riwagis.util.thread.ThreadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadQueue
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadQueue.class);
    private static final int WAIT_TIME = 100;
    private transient Lock addLock = new ReentrantLock();
    private final int intMaxThreads;
    private final List<StatefulRunnableProxy> lstQueued = new ArrayList<StatefulRunnableProxy>();
    private final Collection<Listener> listeners = new ArrayList<Listener>();
    private final Collection<Throwable> uncaughtExceptions = new ArrayList<Throwable>();
    private static final AtomicInteger intGlobalCount = new AtomicInteger(0);
    private final Thread.UncaughtExceptionHandler exHandler = new Thread.UncaughtExceptionHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.warn(String.format("Exception in Thread '%s': %s", t.getName(), e.getMessage()), e);
            Collection<Throwable> collection = ThreadQueue.this.uncaughtExceptions;
            synchronized (collection) {
                ThreadQueue.this.uncaughtExceptions.add(e);
            }
            if (Thread.getDefaultUncaughtExceptionHandler() != null) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, e);
            }
        }
    };
    private final int tCounter;
    private final String externalThreadName;
    private boolean doShutdown;
    private ExecutorService pool;

    public ThreadQueue(int _intMaxThreads, String _externalThreadName) {
        if (_intMaxThreads <= 0) {
            throw new IllegalArgumentException("MaxThreads must be 1 or greater");
        }
        this.doShutdown = false;
        this.externalThreadName = StringUtils.isBlank((CharSequence)_externalThreadName) ? "" : String.format(" (Ext. Name: '%s')", StringUtils.defaultString((String)_externalThreadName, (String)""));
        this.tCounter = intGlobalCount.incrementAndGet();
        this.setName(String.format("ThreadQueue %d%s", this.tCounter, this.externalThreadName));
        this.setDaemon(true);
        this.setPriority(4);
        this.intMaxThreads = _intMaxThreads;
        String queueThreadName = String.format("ThreadQueue %d", this.tCounter) + this.externalThreadName + " T: %d";
        SimpleThreadFactory queueThreadFactory = new SimpleThreadFactory(queueThreadName, 5, true, this.exHandler);
        this.pool = Executors.newFixedThreadPool(this.intMaxThreads, (ThreadFactory)queueThreadFactory);
        LOG.trace(String.format("'%s' initialized.", this.getName()));
    }

    public ThreadQueue(int _intMaxThreads) {
        this(_intMaxThreads, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Throwable> retrieveUncaughtExceptions() {
        ArrayList<Throwable> res = new ArrayList<Throwable>();
        Collection<Throwable> collection = this.uncaughtExceptions;
        synchronized (collection) {
            res.addAll(this.uncaughtExceptions);
            this.uncaughtExceptions.clear();
        }
        return res;
    }

    public boolean isRunning() {
        return this.lstQueued.size() > 0;
    }

    public void shutdown() {
        this.doShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptQueue() {
        try {
            this.addLock.lock();
            if (this.lstQueued.isEmpty()) {
                return;
            }
            for (StatefulRunnableProxy rp : this.lstQueued) {
                StatefulRunnableProxy.cancelCancelable(rp);
            }
            this.pool.shutdown();
            if (!this.doShutdown) {
                BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern((String)StringUtils.getIfBlank((CharSequence)this.externalThreadName, () -> "Unknown") + "-%d").build();
                this.pool = Executors.newFixedThreadPool(this.intMaxThreads, (ThreadFactory)factory);
            }
            this.lstQueued.clear();
            Collection<Throwable> collection = this.uncaughtExceptions;
            synchronized (collection) {
                this.uncaughtExceptions.clear();
            }
            this.fireAllRunningThreadsFinished(true);
        }
        finally {
            this.addLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.doShutdown && !this.isInterrupted()) {
                ThreadUtils.sleepQuietly((long)100L);
                this.addLock.lock();
                try {
                    if (this.lstQueued.isEmpty()) continue;
                    for (int i = this.lstQueued.size() - 1; i >= 0; --i) {
                        StatefulRunnableProxy rp = this.lstQueued.get(i);
                        if (rp.getRunnableState() != StatefulRunnableProxy.RunnableState.Finished) continue;
                        this.lstQueued.remove(i);
                    }
                    if (!this.lstQueued.isEmpty()) continue;
                    this.fireAllRunningThreadsFinished(false);
                }
                finally {
                    this.addLock.unlock();
                }
            }
        }
        finally {
            this.interruptQueue();
            this.pool.shutdownNow();
        }
    }

    public void add(Runnable ru) {
        if (ru != null && !this.doShutdown) {
            this.addLock.lock();
            try {
                StatefulRunnableProxy rp = new StatefulRunnableProxy(ru);
                this.lstQueued.add(rp);
                this.pool.submit(rp);
            }
            finally {
                this.addLock.unlock();
            }
        }
    }

    public void addRunnables(Collection<Runnable> lst2Add) {
        if (lst2Add != null && !lst2Add.isEmpty()) {
            for (Runnable ru : lst2Add) {
                this.add(ru);
            }
        }
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    private void fireAllRunningThreadsFinished(boolean interrupted) {
        LOG.trace("firing allThreadsFinished.");
        for (Listener listener : Collections.unmodifiableCollection(this.listeners)) {
            listener.allRunningThreadsFinished(interrupted);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.interruptQueue();
            this.shutdown();
            if (this.pool != null) {
                this.pool.shutdownNow();
            }
        }
        catch (Throwable eatit) {
            System.out.println("Error shutting down thread pool. (" + eatit.getMessage() + ")");
        }
        super.finalize();
    }

    private static class StatefulRunnableProxy
    implements Runnable {
        private final Runnable torun;
        private RunnableState currentState;

        private StatefulRunnableProxy(Runnable _torun) {
            this.reset();
            this.torun = _torun;
        }

        private void reset() {
            this.currentState = RunnableState.Waiting;
        }

        public RunnableState getRunnableState() {
            return this.currentState;
        }

        public Runnable getTorun() {
            return this.torun;
        }

        @Override
        public void run() {
            try {
                if (this.currentState == RunnableState.Waiting) {
                    this.currentState = RunnableState.Running;
                    this.torun.run();
                }
            }
            finally {
                this.currentState = RunnableState.Finished;
            }
        }

        public static void cancelCancelable(StatefulRunnableProxy proxy) {
            Runnable toRun = proxy.getTorun();
            if (toRun instanceof CancelableRunnable) {
                ((CancelableRunnable)toRun).cancel();
            }
        }

        private static enum RunnableState {
            Waiting,
            Running,
            Finished;

        }
    }

    public static interface Listener {
        public void allRunningThreadsFinished(boolean var1);
    }
}

