/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.map3d;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.gis3d.Gis3DContextImpl;
import de.riwagis.icons.IconLoader;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class Show3DMapPlugIn
extends AbstractPlugIn {
    private JMenuItem menuItem;
    private AbstractButton toggleButton;
    private final Gis3DContextImpl instance = Gis3DContextImpl.getInstance();
    private final Gis3DContextImpl.Gis3DMode gis3DMode;

    public Show3DMapPlugIn(Gis3DContextImpl.Gis3DMode gis3DMode) {
        this.gis3DMode = gis3DMode;
    }

    @Override
    public String getName() {
        if (this.gis3DMode.getName() != null && !this.gis3DMode.getName().isBlank()) {
            return I18N.get("ui.plugin.Show3DMapPlugIn.name") + " (" + this.gis3DMode.getName() + ")";
        }
        return I18N.get("ui.plugin.Show3DMapPlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        if (this.instance.getGis3DMode() != this.gis3DMode) {
            this.instance.setGis3DMode(this.gis3DMode);
            this.instance.set3DActive(true);
        } else {
            boolean newState = !this.instance.is3DActive();
            this.instance.set3DActive(newState);
        }
        this.menuItem.setSelected(this.shouldBeEnabled());
        this.toggleButton.setSelected(this.shouldBeEnabled());
        return true;
    }

    private boolean shouldBeEnabled() {
        return this.instance.is3DActive() && this.instance.getGis3DMode() == this.gis3DMode;
    }

    public ImageIcon getIconSplit() {
        return IconLoader.svgIcon((String)"common_map_3d_split.svg");
    }

    public ImageIcon getIconExternal() {
        return IconLoader.svgIcon((String)"common_map_3d.svg");
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheck requires3DProject = EnableCheckFactory.getInstance().createRequires3DProject();
        return component -> {
            String check3d = requires3DProject.check(component);
            if (check3d != null) {
                return check3d;
            }
            this.menuItem.setSelected(this.shouldBeEnabled());
            this.toggleButton.setSelected(this.shouldBeEnabled());
            return null;
        };
    }

    public void setMenuItem(JMenuItem menuItem) {
        this.menuItem = menuItem;
        this.menuItem.setSelected(this.shouldBeEnabled());
    }

    public void setButton(AbstractButton toggleButton) {
        this.toggleButton = toggleButton;
        this.toggleButton.setSelected(this.shouldBeEnabled());
    }
}

