/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.DesktopPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import java.util.Collection;
import javax.swing.JTabbedPane;
import org.locationtech.jts.util.Assert;

public class SetDigiLayerPlugin
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("de.riwagis.riwajump.workbench.ui.plugin.layer.SetDigiLayerPlugin.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        JTabbedPane rightTabbedPane;
        Collection<Layer> selectedNodes = context.getLayerNamePanel().selectedNodes(Layer.class);
        Assert.isTrue((selectedNodes.size() == 1 ? 1 : 0) != 0, (String)"Exactly one layer needs to be selected.");
        Layer layer = selectedNodes.iterator().next();
        Assert.isTrue((boolean)layer.canBeDigiLayer(), (String)"Layer needs to be a possible digi layer candidate");
        EditingPanel.instanceOf().setCurrentLayer(layer);
        DesktopPanel desktopPanel = context.getWorkbenchFrame().getDesktopPanel();
        if (!desktopPanel.getRightTabsVisible()) {
            desktopPanel.setRightTabsVisible(true);
        }
        if ((rightTabbedPane = desktopPanel.getRightTabbedPane()).getSelectedComponent() != EditingPanel.instanceOf()) {
            rightTabbedPane.setSelectedComponent(EditingPanel.instanceOf());
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layer.class)).add(checkFactory.createSelectedLayersCanBeDigiLayerCheck());
    }
}

