/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dwg;

import com.google.gson.Gson;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.COpt;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.GeoPackageImportFormat;
import de.riwagis.gis.context.GisContext;
import de.riwagis.guitools.Tasks;
import de.riwagis.riwajump.workbench.ui.plugin.dwg.ConversionService;
import de.riwagis.riwajump.workbench.ui.plugin.dwg.TokenService;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.dialogs.ExpandableDialog;
import feign.Feign;
import feign.FeignException;
import feign.reactive.ReactorFeign;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opengis.referencing.ReferenceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ConvertDwgToGeoPackagePlugIn
extends AbstractPlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertDwgToGeoPackagePlugIn.class);
    private static final String ENDING_CONVERTED = "cad";
    public static final String TOKEN_TYPE_DWG = "dwg";
    private static final Duration STATE_DELAY = Duration.ofMillis(500L);
    private static final String KEY_DIR = ConvertDwgToGeoPackagePlugIn.class.getName() + "_KEY_DIR";
    private final GeoPackageImportFormat importer = new GeoPackageImportFormat(StandardCategoryNames.DWG);
    public static final FileFilter DWG_FILE_FILTER = GUISupport.createFileFilter((String)I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.autocad-drawing-description"), (String[])new String[]{"dwg", "dxf", "cad"});
    public static final FileFilter CAD_FILE_FILTER = GUISupport.createFileFilter((String)I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.converted-drawing-description"), (String[])new String[]{"cad"});

    private String getApiUrl() {
        try {
            GisContext gisContext = JUMPWorkbench.GIS_CONTEXT;
            if (gisContext == null) {
                return null;
            }
            return Objects.toString(gisContext.getModuleApp().getUserInfo().get("usr_dwg_service_url"), "");
        }
        catch (Exception ex) {
            log.error("Could not retrieve dwg converter url", (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getName() {
        if (!this.converterAndPrivilegesAvailable()) {
            return I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.name-readonly");
        }
        return I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Tasks.submit(messager -> this.getSourceFile(context).flatMap(sourceFile -> this.getConvertedFile(context, (File)sourceFile, (Consumer<String>)messager)).flatMap(toOpen -> this.createLayer(context, (Path)toOpen)), true);
        return true;
    }

    private boolean serviceAvailable() {
        return StringUtils.isNotBlank((CharSequence)this.getApiUrl());
    }

    private boolean converterAndPrivilegesAvailable() {
        return this.serviceAvailable() && !COpt.VIEWER;
    }

    private Mono<Void> createLayer(PlugInContext context, Path toOpen) {
        log.info("creating layer(s) for dwg");
        try {
            this.importer.doImport(context, Collections.singletonList(toOpen.toFile()));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return Mono.empty();
    }

    private Mono<File> getSourceFile(PlugInContext context) {
        JFileChooser fileChooser = GUISupport.createJFileChooser((boolean)true);
        if (this.converterAndPrivilegesAvailable()) {
            fileChooser.setFileFilter(DWG_FILE_FILTER);
        } else {
            fileChooser.setFileFilter(CAD_FILE_FILTER);
        }
        fileChooser.removeChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
        File fileSelected = new File(PersistentBlackboardPlugIn.get().get(KEY_DIR, ""));
        fileChooser.setSelectedFile(fileSelected);
        int chooseResult = fileChooser.showOpenDialog(context.getWorkbenchFrame());
        if (chooseResult == 1) {
            return Mono.empty();
        }
        PersistentBlackboardPlugIn.get().put(KEY_DIR, fileChooser.getSelectedFile().toString());
        return Mono.just((Object)fileChooser.getSelectedFile());
    }

    private Mono<Path> getConvertedFile(PlugInContext context, File sourceFile, Consumer<String> messager) {
        log.info("determining output file and conversions");
        String sourceExtension = FilenameUtils.getExtension((String)sourceFile.getPath());
        boolean isConvertedFile = ENDING_CONVERTED.equalsIgnoreCase(sourceExtension);
        if (isConvertedFile) {
            return Mono.just((Object)sourceFile.toPath());
        }
        if (!this.getTaskCRS().isPresent()) {
            return Mono.error((Throwable)new IllegalStateException(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.GeoPackageExportFormat.no-crs-defined-error")));
        }
        JOptionPane.showConfirmDialog(context.getWorkbenchFrame(), I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.disclaimer"), I18N.get("common.information"), -1, 1);
        try {
            return this.determineTargetFile(context, sourceFile).flatMap(file -> Optional.of(this.convertFileWithService(sourceFile, (Path)file, messager))).orElseGet(Mono::empty).onErrorResume(e -> e instanceof FeignException && ((FeignException)((Object)e)).status() == 503, e -> {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(context.getWorkbenchFrame(), I18N.getMessage("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.converter-service-busy", new Object[0]), I18N.get("common.error"), 0));
                return Mono.empty();
            }).onErrorResume(e -> e instanceof FeignException && ((FeignException)((Object)e)).status() == 413, e -> {
                String s = ((FeignException)((Object)e)).contentUTF8();
                ConversionService.FileTooBigError fileTooBigError = (ConversionService.FileTooBigError)new Gson().fromJson(s, ConversionService.FileTooBigError.class);
                long fileSizeInMB = fileTooBigError.getMaxFileSize() / 1024L / 1024L;
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(context.getWorkbenchFrame(), I18N.getMessage("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.file-too-big", fileSizeInMB), I18N.get("common.error"), 0));
                return Mono.empty();
            });
        }
        catch (FeignException | IOException e2) {
            return Mono.error((Throwable)e2);
        }
    }

    private Optional<Path> determineTargetFile(PlugInContext context, File sourceFile) throws IOException {
        boolean useDefaultTarget;
        Path defaultTarget = Path.of(FilenameUtils.removeExtension((String)sourceFile.getPath()) + ".cad", new String[0]);
        boolean bl = useDefaultTarget = !Files.exists(defaultTarget, new LinkOption[0]) && this.isCreatable(defaultTarget);
        if (useDefaultTarget) {
            return Optional.of(defaultTarget);
        }
        JFileChooser fileChooserTarget = GUISupport.createJFileChooser((boolean)false);
        fileChooserTarget.setFileFilter(CAD_FILE_FILTER);
        fileChooserTarget.removeChoosableFileFilter(fileChooserTarget.getAcceptAllFileFilter());
        fileChooserTarget.setCurrentDirectory(sourceFile.getParentFile());
        int chooseResult = fileChooserTarget.showSaveDialog(context.getWorkbenchFrame());
        if (chooseResult == 1) {
            return Optional.empty();
        }
        String selectedTarget = fileChooserTarget.getSelectedFile().getPath();
        Path finalTarget = !ENDING_CONVERTED.equalsIgnoreCase(FilenameUtils.getExtension((String)selectedTarget)) ? Path.of(selectedTarget + ".cad", new String[0]) : Path.of(selectedTarget, new String[0]);
        if (Files.exists(finalTarget, new LinkOption[0])) {
            boolean overwrite = GUISupport.yesnobox((Component)WorkbenchContext.getFrame(), (String)I18N.get("common.overwrite-file"), (String)I18N.get("common.alert"));
            if (!overwrite) {
                return Optional.empty();
            }
            Files.delete(finalTarget);
        }
        return Optional.of(finalTarget);
    }

    private boolean isCreatable(Path cadFile) {
        try {
            Files.createFile(cadFile, new FileAttribute[0]);
            Files.delete(cadFile);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private Mono<Path> convertFileWithService(File dwgFile, Path targetFile, Consumer<String> messager) {
        messager.accept(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.start-conversion"));
        TokenService tokenService = WorkbenchContext.getInterface(TokenService.class);
        ConversionService converter = WorkbenchContext.getInterface(ConversionService.class, (Feign.Builder)ReactorFeign.builder(), this.getApiUrl(), builder -> {
            String token = "Bearer " + tokenService.createToken(TOKEN_TYPE_DWG);
            builder.requestInterceptor(template -> template.header("Authorization", new String[]{token}));
        });
        return converter.create().flatMap(id -> this.uploadFileAndReturnId(converter, dwgFile, (String)id, messager)).flatMap(id -> this.submitJobAndReturnId(converter, dwgFile, (String)id)).flatMap(id -> this.waitForConversionFinished(converter, (String)id, messager)).filter(this::handleErrorsAndWarnings).flatMap(result -> this.downloadFile(targetFile, (String)result.getLeft(), converter, messager));
    }

    private boolean handleErrorsAndWarnings(Pair<String, ConversionService.ConversionResult> idAndResult) {
        ConversionService.ConversionResult result = (ConversionService.ConversionResult)idAndResult.getRight();
        ConversionService.ConversionRange successfulConversions = result.getSuccessfulConversions();
        if (!result.isSuccessful()) {
            ExpandableDialog.showError((Component)WorkbenchContext.getFrame(), (String)I18N.get("common.error"), (String)I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.conversion-error"), (String)result.getLogMessages());
            return false;
        }
        if (successfulConversions != null && successfulConversions.getCurrent() != successfulConversions.getTotal()) {
            ExpandableDialog.showInfo((Component)WorkbenchContext.getFrame(), (String)I18N.getMessage("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.partial-result", successfulConversions.getCurrent(), successfulConversions.getTotal()), (String)result.getLogMessages());
        }
        return true;
    }

    private Mono<ConversionService.ConversionResult> getResult(Consumer<String> messager, ConversionService converter, String id) {
        log.info("Downloading log file");
        messager.accept(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.download-log"));
        return converter.getResult(id);
    }

    private Mono<Path> downloadFile(Path targetFile, String id, ConversionService converter, Consumer<String> messager) {
        log.info("Downloading final CAD-GPKG to local filesystem");
        messager.accept(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.download-converted-file"));
        return converter.getConvertedFile(id).flatMap(response -> {
            Mono mono;
            block8: {
                InputStream stream = response.body().asInputStream();
                try {
                    Files.copy(stream, targetFile, new CopyOption[0]);
                    mono = Mono.just((Object)targetFile);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return Mono.error((Throwable)e);
                    }
                }
                stream.close();
            }
            return mono;
        });
    }

    private Mono<String> uploadFileAndReturnId(ConversionService conversionService, File dwgFile, String id, Consumer<String> messager) {
        messager.accept(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.upload-file"));
        return conversionService.uploadFile(id, TOKEN_TYPE_DWG, dwgFile).then(Mono.just((Object)id));
    }

    private Mono<String> submitJobAndReturnId(ConversionService conversionService, File dwgFile, String id) {
        return this.getTaskCRS(crsIdentifier -> {
            ConversionService.ConversionMetadata metadata = new ConversionService.ConversionMetadata(crsIdentifier.toString(), false, true, "dwg_conversion", dwgFile.toPath().getFileName().toString());
            return conversionService.submitJob(id, metadata).flatMap(aVoid -> Mono.just((Object)id));
        });
    }

    private <T> Mono<T> getTaskCRS(Function<ReferenceIdentifier, Mono<T>> dwg_conversion) {
        return this.getTaskCRS().map(dwg_conversion).orElseGet(() -> Mono.error((Throwable)new IllegalStateException(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.GeoPackageExportFormat.no-crs-defined-error"))));
    }

    private Optional<ReferenceIdentifier> getTaskCRS() {
        return Optional.ofNullable(WorkbenchContext.getTask().getCRSDefinition().getCRS()).flatMap(crs -> crs.getIdentifiers().stream().findFirst());
    }

    private Mono<Pair<String, ConversionService.ConversionResult>> waitForConversionFinished(ConversionService conversionService, String id, Consumer<String> messager) {
        return conversionService.getProgress(id).delayElement(STATE_DELAY).repeat().skipWhile(conversionState -> {
            Integer processedEntities = conversionState.getEntitiesProcessed();
            if (processedEntities != null) {
                messager.accept(I18N.getMessage("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.converting-with-progress", processedEntities));
            } else {
                messager.accept(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.ConvertDwgToGeoPackagePlugIn.converting"));
            }
            return this.isConversionNotReady((ConversionService.ConversionState)conversionState);
        }).next().flatMap(state -> this.getResult(messager, conversionService, id)).flatMap(result -> Mono.just((Object)Pair.of((Object)id, (Object)result)));
    }

    private boolean isConversionNotReady(ConversionService.ConversionState conversionState) {
        log.debug("Waiting for dwg conversion to finish...");
        Integer entitiesProcessed = conversionState.getEntitiesProcessed();
        if (entitiesProcessed != null) {
            log.info(String.format("Processed %d entities...", entitiesProcessed));
        } else {
            log.info("Converting...");
        }
        return !conversionState.isFinished();
    }

    @Override
    public EnableCheck createEnableCheck() {
        return EnableCheckFactory.getInstance().createTaskWindowMustBeActiveCheck();
    }

    public boolean loadFromFile(PlugInContext context, File file) {
        Tasks.submit(messager -> Mono.just((Object)file).flatMap(sourceFile -> this.getConvertedFile(context, (File)sourceFile, (Consumer<String>)messager)).flatMap(toOpen -> this.createLayer(context, (Path)toOpen)), true);
        return true;
    }
}

