/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dwg;

import feign.Headers;
import feign.Param;
import feign.RequestLine;
import feign.Response;
import java.io.File;
import lombok.Generated;
import reactor.core.publisher.Mono;

public interface ConversionService {
    @RequestLine(value="POST /conversions")
    public Mono<String> create();

    @RequestLine(value="PUT /conversions/{id}/upload/{type}")
    @Headers(value={"Content-Type: multipart/form-data"})
    public Mono<Void> uploadFile(@Param(value="id") String var1, @Param(value="type") String var2, @Param(value="file") File var3);

    @RequestLine(value="POST /conversions/{id}/submit")
    @Headers(value={"Content-Type: application/json"})
    public Mono<ConversionMetadata> submitJob(@Param(value="id") String var1, ConversionMetadata var2);

    @RequestLine(value="GET /conversions/{id}/progress")
    public Mono<ConversionState> getProgress(@Param(value="id") String var1);

    @RequestLine(value="GET /conversions/{id}")
    @Headers(value={"Accept: application/octet-stream"})
    public Mono<Response> getConvertedFile(@Param(value="id") String var1);

    @RequestLine(value="GET /conversions/{id}/result")
    public Mono<ConversionResult> getResult(@Param(value="id") String var1);

    public static class FileTooBigError
    extends Error {
        private final long maxFileSize;

        public FileTooBigError(String message, long maxFileSize) {
            super(message);
            this.maxFileSize = maxFileSize;
        }

        public long getMaxFileSize() {
            return this.maxFileSize;
        }
    }

    public static class Error {
        private final String message;

        public Error(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class ConversionResult {
        private final boolean successful;
        private final String logMessages;
        private final ConversionRange successfulConversions;

        @Generated
        public ConversionResult(boolean successful, String logMessages, ConversionRange successfulConversions) {
            this.successful = successful;
            this.logMessages = logMessages;
            this.successfulConversions = successfulConversions;
        }

        @Generated
        public boolean isSuccessful() {
            return this.successful;
        }

        @Generated
        public String getLogMessages() {
            return this.logMessages;
        }

        @Generated
        public ConversionRange getSuccessfulConversions() {
            return this.successfulConversions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConversionResult)) {
                return false;
            }
            ConversionResult other = (ConversionResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccessful() != other.isSuccessful()) {
                return false;
            }
            String this$logMessages = this.getLogMessages();
            String other$logMessages = other.getLogMessages();
            if (this$logMessages == null ? other$logMessages != null : !this$logMessages.equals(other$logMessages)) {
                return false;
            }
            ConversionRange this$successfulConversions = this.getSuccessfulConversions();
            ConversionRange other$successfulConversions = other.getSuccessfulConversions();
            return !(this$successfulConversions == null ? other$successfulConversions != null : !((Object)this$successfulConversions).equals(other$successfulConversions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConversionResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccessful() ? 79 : 97);
            String $logMessages = this.getLogMessages();
            result = result * 59 + ($logMessages == null ? 43 : $logMessages.hashCode());
            ConversionRange $successfulConversions = this.getSuccessfulConversions();
            result = result * 59 + ($successfulConversions == null ? 43 : ((Object)$successfulConversions).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ConversionService.ConversionResult(successful=" + this.isSuccessful() + ", logMessages=" + this.getLogMessages() + ", successfulConversions=" + String.valueOf(this.getSuccessfulConversions()) + ")";
        }
    }

    public static class ConversionState {
        private final boolean finished;
        private final Integer entitiesProcessed;

        @Generated
        public ConversionState(boolean finished, Integer entitiesProcessed) {
            this.finished = finished;
            this.entitiesProcessed = entitiesProcessed;
        }

        @Generated
        public boolean isFinished() {
            return this.finished;
        }

        @Generated
        public Integer getEntitiesProcessed() {
            return this.entitiesProcessed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConversionState)) {
                return false;
            }
            ConversionState other = (ConversionState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isFinished() != other.isFinished()) {
                return false;
            }
            Integer this$entitiesProcessed = this.getEntitiesProcessed();
            Integer other$entitiesProcessed = other.getEntitiesProcessed();
            return !(this$entitiesProcessed == null ? other$entitiesProcessed != null : !((Object)this$entitiesProcessed).equals(other$entitiesProcessed));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConversionState;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFinished() ? 79 : 97);
            Integer $entitiesProcessed = this.getEntitiesProcessed();
            result = result * 59 + ($entitiesProcessed == null ? 43 : ((Object)$entitiesProcessed).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ConversionService.ConversionState(finished=" + this.isFinished() + ", entitiesProcessed=" + this.getEntitiesProcessed() + ")";
        }
    }

    public static class ConversionRange {
        private final int current;
        private final int total;

        @Generated
        public ConversionRange(int current, int total) {
            this.current = current;
            this.total = total;
        }

        @Generated
        public int getCurrent() {
            return this.current;
        }

        @Generated
        public int getTotal() {
            return this.total;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConversionRange)) {
                return false;
            }
            ConversionRange other = (ConversionRange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCurrent() != other.getCurrent()) {
                return false;
            }
            return this.getTotal() == other.getTotal();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConversionRange;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCurrent();
            result = result * 59 + this.getTotal();
            return result;
        }

        @Generated
        public String toString() {
            return "ConversionService.ConversionRange(current=" + this.getCurrent() + ", total=" + this.getTotal() + ")";
        }
    }

    public static class ConversionMetadata {
        private final String srid;
        private final boolean exploadHatches;
        private final boolean ignoreLayerAdjustments;
        private final String typeName;
        private final String typeIdentifier;

        @Generated
        public ConversionMetadata(String srid, boolean exploadHatches, boolean ignoreLayerAdjustments, String typeName, String typeIdentifier) {
            this.srid = srid;
            this.exploadHatches = exploadHatches;
            this.ignoreLayerAdjustments = ignoreLayerAdjustments;
            this.typeName = typeName;
            this.typeIdentifier = typeIdentifier;
        }

        @Generated
        public String getSrid() {
            return this.srid;
        }

        @Generated
        public boolean isExploadHatches() {
            return this.exploadHatches;
        }

        @Generated
        public boolean isIgnoreLayerAdjustments() {
            return this.ignoreLayerAdjustments;
        }

        @Generated
        public String getTypeName() {
            return this.typeName;
        }

        @Generated
        public String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConversionMetadata)) {
                return false;
            }
            ConversionMetadata other = (ConversionMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isExploadHatches() != other.isExploadHatches()) {
                return false;
            }
            if (this.isIgnoreLayerAdjustments() != other.isIgnoreLayerAdjustments()) {
                return false;
            }
            String this$srid = this.getSrid();
            String other$srid = other.getSrid();
            if (this$srid == null ? other$srid != null : !this$srid.equals(other$srid)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
                return false;
            }
            String this$typeIdentifier = this.getTypeIdentifier();
            String other$typeIdentifier = other.getTypeIdentifier();
            return !(this$typeIdentifier == null ? other$typeIdentifier != null : !this$typeIdentifier.equals(other$typeIdentifier));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConversionMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExploadHatches() ? 79 : 97);
            result = result * 59 + (this.isIgnoreLayerAdjustments() ? 79 : 97);
            String $srid = this.getSrid();
            result = result * 59 + ($srid == null ? 43 : $srid.hashCode());
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            String $typeIdentifier = this.getTypeIdentifier();
            result = result * 59 + ($typeIdentifier == null ? 43 : $typeIdentifier.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ConversionService.ConversionMetadata(srid=" + this.getSrid() + ", exploadHatches=" + this.isExploadHatches() + ", ignoreLayerAdjustments=" + this.isIgnoreLayerAdjustments() + ", typeName=" + this.getTypeName() + ", typeIdentifier=" + this.getTypeIdentifier() + ")";
        }
    }
}

