/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.ExcelExport;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributesToExcelPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.EditorFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.GeoPackageEditorFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.ShapefileEditorFormat;
import de.riwagis.crs.Transformer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Features;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Logger;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.WriteOption;
import de.riwagis.util.gui.GUISupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class StoreExporter {
    private static final String KEY_DIRECTORY_LASTUSED = StoreExporter.class.getName() + "_DIRECTORY_LASTUSED";
    private final PlugInContext context;
    private final Logger logger;
    private final FileChooser fileChooser;

    StoreExporter(PlugInContext context, JFrame rootFrame, Logger logger) {
        this.context = context;
        this.logger = logger;
        this.fileChooser = new SwingFileChooser(this, rootFrame);
    }

    StoreExporter(PlugInContext context, Logger logger, FileChooser fileChooser) {
        this.context = context;
        this.logger = logger;
        this.fileChooser = fileChooser;
    }

    public void writeFeaturesToGPKG(Features features, String targetFile, String typeName, WriteOption writeOption) throws Exception {
        if (StringUtils.isBlank((CharSequence)typeName)) {
            throw new IllegalArgumentException(I18N.get("typename-cannot-be-empty"));
        }
        this.writeFeaturesToStore(features, targetFile, writeOption, new GeoPackageStoreWriter(this, typeName));
    }

    public void writeFeaturesToSHP(Features features, String targetFile, WriteOption writeOption) throws Exception {
        this.writeFeaturesToStore(features, targetFile, writeOption, new ShapefileStoreWriter(features));
    }

    public void writeFeaturesToExcel(Features features, String targetFile) throws Exception {
        if (this.isFeaturesEmpty(features)) {
            return;
        }
        File outputFile = this.determineOutputFile(targetFile, ".xlsx", AttributesToExcelPlugIn.FILE_FILTER);
        ExcelExport.writeFile(features.getFeatureType().getName().getLocalPart(), features.toList(), outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFeaturesToStore(Features features, String targetFile, WriteOption writeOption, StoreWriter storeWriter) throws Exception {
        if (this.isFeaturesEmpty(features)) {
            return;
        }
        File outputFile = this.determineOutputFile(targetFile, storeWriter.getFileEnding(), storeWriter.getFileFilter());
        String typeName = storeWriter.getTypeName(outputFile);
        Task task = this.context.getTask();
        DatastoreMetadata dmd = storeWriter.createDataStore(task, outputFile);
        try {
            SimpleFeatureType targetSchema;
            DataStore dataStore = dmd.getDataStore();
            boolean typeExists = List.of(dataStore.getTypeNames()).contains(typeName);
            if (writeOption == WriteOption.REPLACE && typeExists) {
                this.dropSchema(storeWriter, dmd, typeName, outputFile);
                typeExists = false;
            }
            SimpleFeatureType sourceSchema = features.getFeatureType();
            sourceSchema = this.renameFeatureType(sourceSchema, typeName);
            sourceSchema = storeWriter.buildCompatibleSchema(sourceSchema);
            if (!typeExists) {
                if (writeOption == WriteOption.UPDATE) {
                    throw new IllegalArgumentException(I18N.getMessage("update-not-allowed-on-non-existing-type", typeName, outputFile));
                }
                this.logger.log(I18N.getMessage("creating-type-in-file", typeName, outputFile));
                targetSchema = storeWriter.createSchema(dmd, sourceSchema);
            } else {
                targetSchema = storeWriter.getSchemaFromStore(dataStore, typeName);
                int compareNames = DataUtilities.compareNames((SimpleFeatureType)sourceSchema, (SimpleFeatureType)targetSchema);
                if (compareNames == -1) {
                    this.logger.log(I18N.getMessage("source-is-not-a-subtype", typeName, outputFile));
                }
            }
            CoordinateReferenceSystem sourceCRS = task.getCRSDefinition().getCRS();
            CoordinateReferenceSystem targetCRS = targetSchema.getCoordinateReferenceSystem();
            Transformer crsTransformer = null;
            if (sourceCRS != null && targetCRS != null && !CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)targetCRS)) {
                crsTransformer = new Transformer(sourceCRS, targetCRS);
                this.logger.log(I18N.getMessage("transforming-from-to-crs", CRS.toSRS((CoordinateReferenceSystem)sourceCRS), CRS.toSRS((CoordinateReferenceSystem)targetCRS), typeName, outputFile));
            }
            switch (writeOption) {
                case ADD: {
                    this.appendFeatures(dmd, storeWriter, typeName, features, outputFile, crsTransformer);
                    break;
                }
                case REPLACE: {
                    this.appendFeatures(dmd, storeWriter, typeName, features, outputFile, crsTransformer);
                    break;
                }
                case UPDATE: {
                    this.updateFeatures(dmd, storeWriter, typeName, features, outputFile, crsTransformer);
                }
            }
            if (writeOption == WriteOption.REPLACE) {
                storeWriter.updateLayerSettingsFromSchema(task, dmd, dmd.getDataStore().getSchema(typeName));
            } else {
                this.refreshAllAffectedLayers(this.context.getTask(), dmd, typeName, storeWriter);
            }
        }
        finally {
            dmd.dispose();
            task.getLocalDataStores().removeDatastore(dmd);
        }
    }

    private void appendFeatures(DatastoreMetadata dmd, StoreWriter storeWriter, String typeName, Features features, File file, Transformer transformer) throws Exception {
        int writtenFeatures = 0;
        try (Transaction t = storeWriter.createTransaction();
             FeatureWriter writer = dmd.getDataStore().getFeatureWriterAppend(typeName, t);){
            for (SimpleFeature source : features) {
                SimpleFeature target = (SimpleFeature)writer.next();
                this.copyFeatureData(source, target, storeWriter, transformer);
                writer.write();
                ++writtenFeatures;
            }
            t.commit();
        }
        this.logger.log(I18N.getMessage("n-features-added-in-type-and-file", writtenFeatures, typeName, file));
    }

    private void updateFeatures(DatastoreMetadata dmd, StoreWriter storeWriter, String typeName, Features features, File file, Transformer transformer) throws Exception {
        int updatedFeatures = 0;
        Map<String, SimpleFeature> fidToFeature = features.stream().collect(Collectors.toMap(f -> FeatureUtil.getFeatureIDWithoutTable((String)f.getID()), f -> f));
        try (Transaction t = storeWriter.createTransaction();
             FeatureWriter writer = dmd.getDataStore().getFeatureWriter(typeName, t);){
            while (writer.hasNext()) {
                SimpleFeature target = (SimpleFeature)writer.next();
                SimpleFeature source = fidToFeature.get(FeatureUtil.getFeatureIDWithoutTable((String)target.getID()));
                if (source == null) continue;
                this.copyFeatureData(source, target, storeWriter, transformer);
                writer.write();
                ++updatedFeatures;
            }
            t.commit();
        }
        this.logger.log(I18N.getMessage("n-features-updated-in-type-and-file", updatedFeatures, typeName, file));
    }

    private void copyFeatureData(SimpleFeature source, SimpleFeature target, StoreWriter storeWriter, Transformer transformer) throws Exception {
        FeatureUtil.copyFeatureData((SimpleFeature)source, (SimpleFeature)target);
        storeWriter.copyFeatureData(source, target);
        if (transformer != null) {
            transformer.transform2d(target);
        }
    }

    private void dropSchema(StoreWriter storeWriter, DatastoreMetadata dmd, String typeName, File file) throws IOException {
        storeWriter.removeSchema(dmd, typeName);
        this.logger.log(I18N.getMessage("existing-schema-was-dropped", typeName, file));
    }

    private SimpleFeatureType renameFeatureType(SimpleFeatureType featureType, String newTypeName) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(newTypeName);
        tb.setNamespaceURI(featureType.getName().getNamespaceURI());
        tb.setCRS(featureType.getCoordinateReferenceSystem());
        for (AttributeDescriptor descriptor : featureType.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) {
                GeometryDescriptor geoDesc = (GeometryDescriptor)descriptor;
                CoordinateReferenceSystem crs = Objects.requireNonNullElseGet(geoDesc.getCoordinateReferenceSystem(), () -> this.context.getTask().getCRSDefinition().getCRS());
                tb.add(geoDesc.getLocalName(), geoDesc.getType().getBinding(), crs);
                continue;
            }
            tb.add(descriptor);
        }
        tb.setDefaultGeometry(featureType.getGeometryDescriptor().getLocalName());
        return tb.buildFeatureType();
    }

    private void refreshAllAffectedLayers(Task task, DatastoreMetadata dmd, String typeName, StoreWriter storeWriter) {
        this.context.getLayerManager().updateSilently(() -> {
            File sourceFile = new File(storeWriter.getFileSystemStoreSource(dmd));
            ArrayList<Layerable> layerablesToRefresh = new ArrayList<Layerable>();
            DMDCollection dmdCol = task.getLocalDataStores();
            for (Layer layer : task.getLayerManager().getLayerablesUnordered(Layer.class)) {
                FeaturestoreMetadata fmd = layer.getFMD();
                DatastoreMetadata dmdLayer = dmdCol.getByName(fmd.getDatastoreName());
                if (dmdLayer == null || !StringUtils.isNotEmpty((CharSequence)dmdLayer.getDataName()) || !dmdLayer.getDataName().equals(storeWriter.getStoreTypeName())) continue;
                File layerFile = new File(storeWriter.getFileSystemStoreSource(dmdLayer));
                if (!fmd.getDatatypeName().equals(typeName) || !layerFile.equals(sourceFile)) continue;
                layerablesToRefresh.addAll(layer.reload());
            }
            this.context.getLayerViewPanel().getRenderingManager().render(layerablesToRefresh.iterator(), true);
        });
    }

    private File determineOutputFile(String targetFile, String ending, FileFilter fileFilter) {
        if (StringUtils.isBlank((CharSequence)targetFile)) {
            File outputFile = this.fileChooser.chooseFile(fileFilter);
            if (outputFile == null) {
                throw new IllegalStateException(I18N.get("no-file-selected"));
            }
            if (!StringUtils.endsWithIgnoreCase((CharSequence)outputFile.getName(), (CharSequence)ending)) {
                outputFile = new File(String.valueOf(outputFile) + ending);
            }
            return outputFile;
        }
        return new File(targetFile);
    }

    private boolean isFeaturesEmpty(Features features) {
        if (features.count() <= 0) {
            this.logger.log(I18N.get("feature-collection-empty"));
            return true;
        }
        return false;
    }

    private class SwingFileChooser
    implements FileChooser {
        private final JFrame rootFrame;

        public SwingFileChooser(StoreExporter storeExporter, JFrame rootFrame) {
            this.rootFrame = rootFrame;
        }

        @Override
        public File chooseFile(FileFilter fileFilter) {
            JFileChooser jFileChooser = GUISupport.createJFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(fileFilter);
            jFileChooser.setCurrentDirectory(this.getLastUsedDirectory());
            int result = jFileChooser.showSaveDialog(this.rootFrame);
            if (result == 1) {
                return null;
            }
            File outputFile = jFileChooser.getSelectedFile();
            if (outputFile == null) {
                return null;
            }
            this.setLastUsedDirectory(outputFile.getParentFile());
            return outputFile;
        }

        private File getLastUsedDirectory() {
            String lastUsedFile = (String)PersistentBlackboardPlugIn.get().get(KEY_DIRECTORY_LASTUSED);
            if (lastUsedFile == null) {
                return null;
            }
            return new File(lastUsedFile);
        }

        private void setLastUsedDirectory(File file) {
            PersistentBlackboardPlugIn.get().put(KEY_DIRECTORY_LASTUSED, file.getAbsolutePath());
        }
    }

    @FunctionalInterface
    static interface FileChooser {
        public File chooseFile(FileFilter var1);
    }

    private class GeoPackageStoreWriter
    extends EditorFormatBasedStoreWriter {
        private final String typeName;

        public GeoPackageStoreWriter(StoreExporter storeExporter, String typeName) {
            super(storeExporter, new GeoPackageEditorFormat());
            this.typeName = typeName;
        }

        @Override
        public String getTypeName(File outputFile) {
            return this.typeName;
        }
    }

    private static interface StoreWriter {
        public SimpleFeatureType buildCompatibleSchema(SimpleFeatureType var1);

        public String getTypeName(File var1);

        public void copyFeatureData(SimpleFeature var1, SimpleFeature var2);

        public SimpleFeatureType getSchemaFromStore(DataStore var1, String var2) throws IOException;

        public SimpleFeatureType createSchema(DatastoreMetadata var1, SimpleFeatureType var2) throws IOException;

        public void removeSchema(DatastoreMetadata var1, String var2) throws IOException;

        public String getStoreTypeName();

        public String getFileEnding();

        public FileFilter getFileFilter();

        public String getFileSystemStoreSource(DatastoreMetadata var1);

        public DatastoreMetadata createDataStore(Task var1, File var2);

        public Transaction createTransaction();

        public void updateLayerSettingsFromSchema(Task var1, DatastoreMetadata var2, SimpleFeatureType var3) throws IOException;
    }

    private class ShapefileStoreWriter
    extends EditorFormatBasedStoreWriter {
        private static final Set<Class<? extends Geometry>> POINTS = Set.of(Point.class, MultiPoint.class);
        private static final Set<Class<? extends Geometry>> LINESTRINGS = Set.of(LineString.class, MultiLineString.class);
        private static final Set<Class<? extends Geometry>> POLYGONS = Set.of(Polygon.class, MultiPolygon.class);
        private final Class<? extends Geometry> outputGeomType;

        public ShapefileStoreWriter(Features features) {
            super(StoreExporter.this, new ShapefileEditorFormat());
            this.outputGeomType = this.determineGeometryType(features);
        }

        private Class<? extends Geometry> determineGeometryType(Features features) throws IllegalArgumentException {
            Set providedGeometryTypes = features.stream().filter(f -> f.getDefaultGeometry() != null).map(f -> f.getDefaultGeometry().getClass()).collect(Collectors.toSet());
            if (providedGeometryTypes.isEmpty()) {
                return Point.class;
            }
            if (providedGeometryTypes.size() == 1) {
                Class firstType = (Class)providedGeometryTypes.iterator().next();
                if (firstType.equals(GeometryCollection.class)) {
                    throw new IllegalArgumentException(I18N.get("shapefiles-do-not-support-geometrycollection"));
                }
                return firstType;
            }
            if (providedGeometryTypes.size() == 2) {
                if (POINTS.containsAll(providedGeometryTypes)) {
                    return MultiPoint.class;
                }
                if (LINESTRINGS.containsAll(providedGeometryTypes)) {
                    return MultiLineString.class;
                }
                if (POLYGONS.containsAll(providedGeometryTypes)) {
                    return MultiPolygon.class;
                }
            }
            String typeNames = providedGeometryTypes.stream().map(type -> type.getSimpleName()).collect(Collectors.joining(","));
            throw new IllegalArgumentException(I18N.getMessage("shapefiles-do-not-support-multipe-geometry-types-provided", typeNames));
        }

        @Override
        public SimpleFeatureType buildCompatibleSchema(SimpleFeatureType source) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setName(source.getName());
            tb.setNamespaceURI(source.getName().getNamespaceURI());
            tb.setCRS(source.getCoordinateReferenceSystem());
            for (AttributeDescriptor descriptor : source.getAttributeDescriptors()) {
                if (descriptor instanceof GeometryDescriptor) {
                    GeometryDescriptor geoDesc = (GeometryDescriptor)descriptor;
                    CoordinateReferenceSystem crs = Objects.requireNonNullElseGet(geoDesc.getCoordinateReferenceSystem(), () -> StoreExporter.this.context.getTask().getCRSDefinition().getCRS());
                    tb.add("the_geom", this.outputGeomType, crs);
                    continue;
                }
                if (descriptor.getLocalName().length() > 10) {
                    tb.add(descriptor.getLocalName().substring(0, 10), descriptor.getType().getBinding());
                    continue;
                }
                tb.add(descriptor);
            }
            tb.setDefaultGeometry("the_geom");
            return tb.buildFeatureType();
        }

        @Override
        public String getTypeName(File outputFile) {
            return FilenameUtils.getBaseName((String)outputFile.toString());
        }

        @Override
        public void copyFeatureData(SimpleFeature source, SimpleFeature target) {
            target.setDefaultGeometry(source.getDefaultGeometry());
            for (AttributeDescriptor descriptor : source.getType().getAttributeDescriptors()) {
                String name;
                if (descriptor instanceof GeometryDescriptor || (name = descriptor.getLocalName()).length() <= 10) continue;
                String shortenedName = name.substring(0, 10);
                Object sourceAttribute = FeatureUtil.getAttribute((SimpleFeature)source, (String)name);
                FeatureUtil.setAttribute((SimpleFeature)target, (String)shortenedName, (Object)sourceAttribute);
            }
        }

        @Override
        public Transaction createTransaction() {
            return Transaction.AUTO_COMMIT;
        }
    }

    private abstract class EditorFormatBasedStoreWriter
    implements StoreWriter {
        private static final String TRANSACTION_HANDLE = "gdpBatch";
        private final EditorFormat editorFormat;

        public EditorFormatBasedStoreWriter(StoreExporter storeExporter, EditorFormat editorFormat) {
            this.editorFormat = editorFormat;
        }

        @Override
        public SimpleFeatureType getSchemaFromStore(DataStore dataStore, String typeName) throws IOException {
            return this.editorFormat.getSchemaFromStore(dataStore, typeName);
        }

        @Override
        public SimpleFeatureType createSchema(DatastoreMetadata dmd, SimpleFeatureType schema) throws IOException {
            return this.editorFormat.createSchema(dmd, schema);
        }

        @Override
        public void removeSchema(DatastoreMetadata dmd, String typeName) throws IOException {
            this.editorFormat.deleteSchema(dmd, typeName);
        }

        @Override
        public String getStoreTypeName() {
            return this.editorFormat.getStoreTypeName();
        }

        @Override
        public String getFileEnding() {
            return this.editorFormat.getFileEnding();
        }

        @Override
        public FileFilter getFileFilter() {
            return this.editorFormat.getFileFilter();
        }

        @Override
        public String getFileSystemStoreSource(DatastoreMetadata dmd) {
            return this.editorFormat.getFileSystemStoreSource(dmd);
        }

        @Override
        public DatastoreMetadata createDataStore(Task task, File file) {
            return this.editorFormat.createDataStore(task, file);
        }

        @Override
        public Transaction createTransaction() {
            return new DefaultTransaction(TRANSACTION_HANDLE);
        }

        @Override
        public SimpleFeatureType buildCompatibleSchema(SimpleFeatureType source) {
            return source;
        }

        @Override
        public void copyFeatureData(SimpleFeature source, SimpleFeature target) {
        }

        @Override
        public void updateLayerSettingsFromSchema(Task task, DatastoreMetadata dmd, SimpleFeatureType schema) throws IOException {
            this.editorFormat.updateLayerSettingsFromSchema(task, schema, this.editorFormat.getFileSystemStoreSource(dmd));
        }
    }
}

