/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Task;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.AttributeConfiguration;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Features;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.FilterIntersectOperation;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.GroupingFunction;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.IntersectOperation;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Logger;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.MergeOperation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class SpatialMethods {
    private static final String ATTRIBUTE_DEFAULT_GEOM = "geom";
    private static final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
    private final Supplier<Task> taskSupplier;
    private final Logger logger;

    SpatialMethods(Supplier<Task> taskSupplier, Logger logger) {
        this.taskSupplier = taskSupplier;
        this.logger = logger;
    }

    Features mergeFeaturesByGeometry(Features features, MergeOperation spatialOperation, AttributeConfiguration attributeConfiguration) {
        CoordinateReferenceSystem crs = this.taskSupplier.get().getCRSDefinition().getCRS();
        FeatureMerger featureMerger = new FeatureMerger(attributeConfiguration, crs, features.getFeatureType());
        BiPredicate<Geometry, Geometry> matchOperation = this.findMatchOperationBidirectional(spatialOperation);
        List<SimpleFeature> featuresWithGeometries = SpatialMethods.filterFeaturesWithGeometries(features);
        STRtree tree = this.buildTree(featuresWithGeometries);
        Map<SimpleFeature, Set> neighbours = featuresWithGeometries.stream().collect(Collectors.toMap(f -> f, featureToMatch -> {
            Geometry geom = this.getGeometryFromFeature((SimpleFeature)featureToMatch);
            List featuresInArea = tree.query(geom.getEnvelopeInternal());
            return featuresInArea.stream().filter(matchingCandidate -> matchOperation.test(geom, this.getGeometryFromFeature((SimpleFeature)matchingCandidate))).collect(Collectors.toSet());
        }));
        Comparator<SimpleFeature> featureComparatorById = Comparator.comparing(SimpleFeature::getID);
        ArrayList<TreeSet<SimpleFeature>> groupedFeatures = new ArrayList<TreeSet<SimpleFeature>>();
        while (!neighbours.isEmpty()) {
            TreeSet<SimpleFeature> featureGroup = new TreeSet<SimpleFeature>(featureComparatorById);
            ArrayDeque<SimpleFeature> stack = new ArrayDeque<SimpleFeature>();
            stack.push(neighbours.keySet().iterator().next());
            while (!stack.isEmpty()) {
                SimpleFeature feature = (SimpleFeature)stack.pop();
                featureGroup.add(feature);
                Set matchingFeatures = neighbours.remove(feature);
                if (matchingFeatures == null) continue;
                stack.addAll(matchingFeatures);
            }
            groupedFeatures.add(featureGroup);
        }
        List<SimpleFeature> unionizedFeatures = groupedFeatures.stream().map(connectFeatures -> this.unionizeFeatures((Collection<SimpleFeature>)connectFeatures, featureMerger)).toList();
        return this.returnAndLogCreatedFeatures(unionizedFeatures, "groupFeaturesByGeometry");
    }

    Features mergeFeaturesByAttribute(Features features, String attributeToGroupBy, AttributeConfiguration attributeConfiguration) {
        CoordinateReferenceSystem crs = this.taskSupplier.get().getCRSDefinition().getCRS();
        FeatureMerger featureMerger = new FeatureMerger(attributeConfiguration, crs, features.getFeatureType());
        int attributeIndex = features.getFeatureType().indexOf(attributeToGroupBy);
        Map<Object, List<SimpleFeature>> groupedFeatures = features.stream().collect(Collectors.groupingBy(f -> Objects.requireNonNullElse(f.getAttribute(attributeIndex), this)));
        List<SimpleFeature> unionizedFeatures = groupedFeatures.values().stream().map(featureGroup -> this.unionizeFeatures((Collection<SimpleFeature>)featureGroup, featureMerger)).toList();
        return this.returnAndLogCreatedFeatures(unionizedFeatures, "groupFeaturesByAttribute");
    }

    private SimpleFeature unionizeFeatures(Collection<SimpleFeature> features, FeatureMerger featureMerger) {
        Collection allGeometriesOfGroup = FeatureUtil.toGeometries(features);
        Geometry geom = geometryFactory.buildGeometry(allGeometriesOfGroup).union();
        return featureMerger.buildFeature(features, geom);
    }

    Features intersectFeatureGeometries(Features featuresToSubstractFrom, Features featuresToSubtract, IntersectOperation spatialOperation, AttributeConfiguration attributeConfiguration) {
        BiPredicate<Geometry, Geometry> matchOperation = this.findMatchOperationDirectional(spatialOperation);
        return this.computeFeatureGeometries(attributeConfiguration, featuresToSubstractFrom, featuresToSubtract, matchOperation, Geometry::intersection, "intersectFeatureGeometries");
    }

    Features intersectFeatureGeometries(Features featuresToSubstractFrom, Features featuresToSubtract, FilterIntersectOperation spatialOperation, AttributeConfiguration attributeConfiguration) {
        BiPredicate<Geometry, Geometry> matchOperation = this.findMatchOperationDirectional(spatialOperation);
        return this.computeFeatureGeometries(attributeConfiguration, featuresToSubstractFrom, featuresToSubtract, matchOperation, (a, b) -> a, "intersectFeatureGeometries");
    }

    private Features computeFeatureGeometries(AttributeConfiguration attributeConfiguration, Features featuresToSubstractFrom, Features featuresToSubtract, BiPredicate<Geometry, Geometry> matchOperation, BinaryOperator<Geometry> geometryFunction, String methodName) {
        CoordinateReferenceSystem crs = this.taskSupplier.get().getCRSDefinition().getCRS();
        FeatureMerger featureMerger = new FeatureMerger(attributeConfiguration, crs, featuresToSubstractFrom.getFeatureType(), featuresToSubtract.getFeatureType());
        List<SimpleFeature> featuresWithGeometries2 = SpatialMethods.filterFeaturesWithGeometries(featuresToSubtract);
        STRtree tree = this.buildTree(featuresWithGeometries2);
        List<SimpleFeature> featuresWithGeometries1 = SpatialMethods.filterFeaturesWithGeometries(featuresToSubstractFrom);
        LinkedHashMap<SimpleFeature, List> intersectingFeaturesGroups = new LinkedHashMap<SimpleFeature, List>();
        for (SimpleFeature featureToCheck : featuresWithGeometries1) {
            Geometry sourceGeometry = (Geometry)featureToCheck.getDefaultGeometry();
            List featuresInArea = tree.query(sourceGeometry.getEnvelopeInternal());
            ArrayList<SimpleFeature> intersectingFeatures = new ArrayList<SimpleFeature>();
            for (SimpleFeature testFeature : featuresInArea) {
                Geometry testGeometry = (Geometry)testFeature.getDefaultGeometry();
                if (!matchOperation.test(sourceGeometry, testGeometry)) continue;
                intersectingFeatures.add(testFeature);
            }
            if (intersectingFeatures.isEmpty()) continue;
            intersectingFeaturesGroups.put(featureToCheck, intersectingFeatures);
        }
        ArrayList<SimpleFeature> intersectedFeatures = new ArrayList<SimpleFeature>();
        intersectingFeaturesGroups.forEach((source, intersects) -> {
            Collection allGeometriesOfGroup = FeatureUtil.toGeometries((Collection)intersects);
            Geometry intersectionGeometry = geometryFactory.buildGeometry(allGeometriesOfGroup).union();
            if (intersectionGeometry.isEmpty()) {
                return;
            }
            Geometry sourceGeometry = this.getGeometryFromFeature((SimpleFeature)source);
            Geometry finalGeometry = (Geometry)geometryFunction.apply(sourceGeometry, intersectionGeometry);
            if (finalGeometry.isEmpty()) {
                return;
            }
            intersects.add(0, source);
            intersectedFeatures.add(featureMerger.buildFeature((Collection<SimpleFeature>)intersects, finalGeometry));
        });
        return this.returnAndLogCreatedFeatures(intersectedFeatures, methodName);
    }

    Features clipFeatureGeometries(Features featuresToClipFrom, Features featuresToClip, boolean ignoreFeaturesWithoutGeometry) {
        ArrayList<SimpleFeature> resultFeatures = new ArrayList<SimpleFeature>();
        List<SimpleFeature> featuresWithGeometries = SpatialMethods.filterFeaturesWithGeometries(featuresToClip);
        STRtree tree = this.buildTree(featuresWithGeometries);
        for (SimpleFeature feat1 : featuresToClipFrom) {
            List featuresInArea;
            Geometry geomFeat2;
            Geometry geomFeat1 = (Geometry)feat1.getDefaultGeometry();
            if (geomFeat1 != null && !geomFeat1.isEmpty() && (geomFeat2 = geometryFactory.buildGeometry(FeatureUtil.toGeometries((Collection)(featuresInArea = tree.query(geomFeat1.getEnvelopeInternal())))).union()) != null && !geomFeat2.isEmpty()) {
                geomFeat1 = geomFeat1.difference(geomFeat2);
            }
            if (ignoreFeaturesWithoutGeometry && (geomFeat1 == null || geomFeat1.isEmpty())) continue;
            SimpleFeature clonedFeature = FeatureUtil.cloneFeature((SimpleFeature)feat1);
            clonedFeature.setDefaultGeometry((Object)geomFeat1);
            resultFeatures.add(clonedFeature);
        }
        return this.returnAndLogCreatedFeatures(resultFeatures, "clipFeatureGeometries");
    }

    private Features returnAndLogCreatedFeatures(List<SimpleFeature> resultSet, String method) {
        this.logger.log(I18N.getMessage("method-created-n-features", method, resultSet.size()));
        return new Features(resultSet);
    }

    private static List<SimpleFeature> filterFeaturesWithGeometries(Features features) {
        return features.stream().filter(f -> f.getDefaultGeometry() != null).toList();
    }

    private STRtree buildTree(List<SimpleFeature> featuresWithGeometries) {
        STRtree tree = new STRtree();
        for (SimpleFeature feature : featuresWithGeometries) {
            Geometry geom = this.getGeometryFromFeature(feature);
            tree.insert(geom.getEnvelopeInternal(), (Object)feature);
        }
        tree.build();
        return tree;
    }

    private Geometry getGeometryFromFeature(SimpleFeature feature) {
        return (Geometry)feature.getDefaultGeometry();
    }

    private BiPredicate<Geometry, Geometry> findMatchOperationBidirectional(MergeOperation spatialOperation) {
        switch (spatialOperation) {
            case ON_INTERSECTION: {
                return (a, b) -> a.intersects(b) && !a.touches(b);
            }
            case ON_INTERSECTION_OR_TOUCH: {
                return Geometry::intersects;
            }
            case ON_CONTAIN: {
                return (a, b) -> a.contains(b) || b.contains(a);
            }
            case ON_CONTAIN_OR_TOUCH: {
                return (a, b) -> a.touches(b) || a.contains(b) || b.contains(a);
            }
            case ON_TOUCH: {
                return Geometry::touches;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)spatialOperation));
    }

    private BiPredicate<Geometry, Geometry> findMatchOperationDirectional(IntersectOperation spatialOperation) {
        switch (spatialOperation) {
            case ON_INTERSECTION: {
                return (a, b) -> a.intersects(b) && !a.touches(b);
            }
            case ON_CONTAIN: {
                return Geometry::contains;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)spatialOperation));
    }

    private BiPredicate<Geometry, Geometry> findMatchOperationDirectional(FilterIntersectOperation spatialOperation) {
        switch (spatialOperation) {
            case ON_INTERSECTION: {
                return (a, b) -> a.intersects(b) && !a.touches(b);
            }
            case ON_CONTAIN: {
                return Geometry::contains;
            }
            case ON_WITHIN: {
                return Geometry::within;
            }
            case ON_TOUCH: {
                return Geometry::touches;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)spatialOperation));
    }

    private static class FeatureMerger {
        private final SimpleFeatureBuilder featureBuilder;
        private final List<Reducer> reducerForAttributes = new ArrayList<Reducer>();

        FeatureMerger(AttributeConfiguration attributeConfiguration, CoordinateReferenceSystem crs, SimpleFeatureType ... featureTypes) {
            this.featureBuilder = new SimpleFeatureBuilder(this.buildFeatureType(attributeConfiguration, crs, List.of(featureTypes)));
        }

        SimpleFeature buildFeature(Collection<SimpleFeature> featuresToMerge, Geometry geometry) {
            for (Reducer reducer : this.reducerForAttributes) {
                this.featureBuilder.add(reducer.reduce(featuresToMerge.stream()));
            }
            this.featureBuilder.add((Object)geometry);
            return this.featureBuilder.buildFeature(null);
        }

        private SimpleFeatureType buildFeatureType(AttributeConfiguration attributeConfiguration, CoordinateReferenceSystem crs, List<SimpleFeatureType> featureTypes) {
            SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
            typeBuilder.setName(featureTypes.stream().map(ft -> ft.getTypeName()).collect(Collectors.joining("_")));
            attributeConfiguration.getAttributes().forEach((attributeName, value) -> this.buildFeatureAttribute((AttributeConfiguration.AttributeDefinition)value, featureTypes, (String)attributeName, typeBuilder));
            typeBuilder.add(SpatialMethods.ATTRIBUTE_DEFAULT_GEOM, Geometry.class, crs);
            typeBuilder.setDefaultGeometry(SpatialMethods.ATTRIBUTE_DEFAULT_GEOM);
            return typeBuilder.buildFeatureType();
        }

        private void buildFeatureAttribute(AttributeConfiguration.AttributeDefinition attributeDef, List<SimpleFeatureType> featureTypes, String attributeName, SimpleFeatureTypeBuilder typeBuilder) {
            AttributeDescriptor newDescriptor;
            GroupingFunction function = attributeDef.function();
            String sourceAttribute = attributeDef.sourceAttribute();
            SimpleFeatureType sourceFeatureType = attributeDef.sourceFeatureType();
            AttributeDescriptor descriptor = featureTypes.stream().filter(featureType -> sourceFeatureType == null || sourceFeatureType.equals(featureType)).map(featureType -> featureType.getDescriptor(sourceAttribute)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException(I18N.getMessage("feature-attribute-does-not-exist-in-source-types", sourceAttribute)));
            this.reducerForAttributes.add(this.buildReducer(descriptor, function, sourceFeatureType));
            if (!sourceAttribute.equals(attributeName) || function.hasFixedBinding()) {
                AttributeTypeBuilder attBuilder = new AttributeTypeBuilder();
                attBuilder.init(descriptor);
                if (function.hasFixedBinding()) {
                    attBuilder.setBinding(function.getBinding());
                }
                newDescriptor = attBuilder.buildDescriptor(attributeName);
            } else {
                newDescriptor = descriptor;
            }
            typeBuilder.add(newDescriptor);
        }

        private Reducer buildReducer(AttributeDescriptor sourceAttribute, GroupingFunction function, SimpleFeatureType sourceFeatureType) {
            String attributeName = sourceAttribute.getLocalName();
            Class binding = sourceAttribute.getType().getBinding();
            Reducer groupByReducer = this.buildGroupingFunction(function, attributeName, binding);
            if (sourceFeatureType == null) {
                return groupByReducer;
            }
            return features -> groupByReducer.reduce(this.filterFeaturesByFeatureType(features, sourceFeatureType));
        }

        private Stream<SimpleFeature> filterFeaturesByFeatureType(Stream<SimpleFeature> features, SimpleFeatureType sourceFeatureType) {
            return features.filter(feature -> feature.getFeatureType().equals((Object)sourceFeatureType));
        }

        private Reducer buildGroupingFunction(GroupingFunction function, String attributeName, Class<?> binding) {
            switch (function) {
                case FIRST: {
                    return this.buildFirstFunction(attributeName);
                }
                case AVG: {
                    return this.buildAverageFunction(attributeName, binding);
                }
                case SUM: {
                    return this.buildSumFunction(attributeName, binding);
                }
                case CONCAT: {
                    return this.buildConcatFunction(attributeName);
                }
                case COUNT: {
                    return this.buildCountFunction(attributeName);
                }
            }
            throw new IllegalArgumentException("unsupported grouping function: " + function.name());
        }

        private Reducer buildCountFunction(String attributeName) {
            return f -> this.getNonNullAttributes(attributeName, f).count();
        }

        private Reducer buildConcatFunction(String attributeName) {
            return f -> this.getNonNullAttributes(attributeName, f).map(Objects::toString).collect(Collectors.joining(","));
        }

        private Reducer buildSumFunction(String attributeName, Class<?> binding) {
            if (binding.equals(Integer.class)) {
                return f -> this.getNonNullIntAttributes(attributeName, f).sum();
            }
            if (binding.equals(Long.class)) {
                return f -> this.getNonNullLongAttributes(attributeName, f).sum();
            }
            if (binding.equals(Double.class)) {
                return f -> this.getNonNullDoubleAttributes(attributeName, f).sum();
            }
            if (binding.equals(Float.class)) {
                return f -> Float.valueOf((float)this.getNonNullFloatAttributes(attributeName, f).sum());
            }
            throw new IllegalStateException(I18N.getMessage("grouping-function-does-not-support-type", new Object[]{GroupingFunction.SUM, binding.getSimpleName()}));
        }

        private Reducer buildAverageFunction(String attributeName, Class<?> binding) {
            if (binding.equals(Integer.class)) {
                return f -> (int)Math.round(this.getNonNullIntAttributes(attributeName, f).average().getAsDouble());
            }
            if (binding.equals(Long.class)) {
                return f -> Math.round(this.getNonNullLongAttributes(attributeName, f).average().getAsDouble());
            }
            if (binding.equals(Double.class)) {
                return f -> this.getNonNullDoubleAttributes(attributeName, f).average().getAsDouble();
            }
            if (binding.equals(Float.class)) {
                return f -> Float.valueOf((float)this.getNonNullFloatAttributes(attributeName, f).average().getAsDouble());
            }
            throw new IllegalStateException(I18N.getMessage("grouping-function-does-not-support-type", new Object[]{GroupingFunction.AVG, binding.getSimpleName()}));
        }

        private Reducer buildFirstFunction(String attributeName) {
            return f -> this.getNonNullAttributes(attributeName, f).findFirst().orElse(null);
        }

        private DoubleStream getNonNullDoubleAttributes(String attributeName, Stream<SimpleFeature> featuresToMerge) {
            return this.getAllValuesOfType(attributeName, featuresToMerge, Double.class).mapToDouble(a -> a);
        }

        private DoubleStream getNonNullFloatAttributes(String attributeName, Stream<SimpleFeature> featuresToMerge) {
            return this.getAllValuesOfType(attributeName, featuresToMerge, Float.class).mapToDouble(Number::doubleValue);
        }

        private LongStream getNonNullLongAttributes(String attributeName, Stream<SimpleFeature> featuresToMerge) {
            return this.getAllValuesOfType(attributeName, featuresToMerge, Long.class).mapToLong(a -> a);
        }

        private IntStream getNonNullIntAttributes(String attributeName, Stream<SimpleFeature> featuresToMerge) {
            return this.getAllValuesOfType(attributeName, featuresToMerge, Integer.class).mapToInt(a -> a);
        }

        private <T> Stream<T> getAllValuesOfType(String attributeName, Stream<SimpleFeature> featuresToMerge, Class<T> type) {
            return this.getNonNullAttributes(attributeName, featuresToMerge).filter(type::isInstance).map(t -> t);
        }

        private Stream<Object> getNonNullAttributes(String attributeName, Stream<SimpleFeature> featuresToMerge) {
            return featuresToMerge.map(f -> f.getAttribute(attributeName)).filter(Objects::nonNull);
        }

        @FunctionalInterface
        private static interface Reducer {
            public Object reduce(Stream<SimpleFeature> var1);
        }
    }
}

