/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.ConstMoveParallelSupport;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.data.dir.DirShpDataStore;
import de.riwagis.geotools.feature.bsh.FeatBshObjectBuilder;
import de.riwagis.geotools.feature.util.FeatureTypeUtil;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.Filters;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.feature.PropertyCaseResolvingVisitor;
import de.riwagis.riwajump.reduction.ProjectionReduction;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.AttributeConfiguration;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.AttributeType;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.ComparisonOperation;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.EndCapStyle;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Features;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.FilterIntersectOperation;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.IntersectOperation;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.JoinStyle;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.MergeOperation;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.SpatialMethods;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.StoreExporter;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.WriteOption;
import de.riwagis.util.ThrowingFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.swing.JFrame;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.WKTWriter2;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Methods {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Methods.class);
    private static Consumer<String> logConsumer = arg_0 -> ((Logger)log).info(arg_0);
    private static WorkbenchContext workbenchContext;
    private static StoreExporter storeExporter;
    private static SpatialMethods spatialMethods;
    private static final WKTWriter2 wktWriter;

    public static void setLogger(Consumer<String> logConsumer) {
        if (logConsumer == null) {
            logConsumer = arg_0 -> ((Logger)log).info(arg_0);
        }
        Methods.logConsumer = logConsumer;
    }

    public static void setupContext(WorkbenchContext workbenchContext, JFrame rootFrame) {
        Methods.workbenchContext = workbenchContext;
        storeExporter = new StoreExporter(workbenchContext.createPlugInContext(), rootFrame, Methods::log);
        spatialMethods = new SpatialMethods(() -> Methods.getLayerManager().getTask(), Methods::log);
    }

    static void setupContext(WorkbenchContext workbenchContext, StoreExporter storeExporter) {
        Methods.workbenchContext = workbenchContext;
        Methods.storeExporter = storeExporter;
    }

    public static Features readFeaturesFromLayer(String layerKey, String cqlFilter) throws Exception {
        Layer layer = Methods.getLayer(layerKey);
        Filter filter = Methods.parseFilter(cqlFilter, layer);
        List<SimpleFeature> features = Methods.retrieveFeaturesFromLayer(layer, filter);
        return new Features(features);
    }

    public static Features readFeaturesFromLayer(String layerKey) throws Exception {
        return Methods.readFeaturesFromLayer(layerKey, null);
    }

    public static Features readFeaturesFromSelection(String layerKey, String cqlFilter) throws CQLException {
        Layer layer = Methods.getLayer(layerKey);
        Collection<SimpleFeature> selectedFeatures = Methods.getSelectionManager().getFeaturesWithSelectedItems(layer);
        Filter filter = Methods.parseFilter(cqlFilter, layer);
        List<SimpleFeature> matchingFeatures = selectedFeatures.stream().filter(arg_0 -> ((Filter)filter).evaluate(arg_0)).toList();
        return new Features(matchingFeatures);
    }

    public static Features readFeaturesFromSelection(String layerKey) throws CQLException {
        return Methods.readFeaturesFromSelection(layerKey, null);
    }

    public static void writeFeaturesToGPKG(Features features, String targetFile, String typeName, WriteOption writeOption) throws Exception {
        Methods.validateFeatures(features);
        storeExporter.writeFeaturesToGPKG(features, targetFile, typeName, writeOption);
    }

    public static void writeFeaturesToXLSX(Features features, String targetFile) throws Exception {
        Methods.validateFeatures(features);
        storeExporter.writeFeaturesToExcel(features, targetFile);
    }

    public static void writeFeaturesToSHP(Features features, String targetFile, WriteOption writeOption) throws Exception {
        Methods.validateFeatures(features);
        storeExporter.writeFeaturesToSHP(features, targetFile, writeOption);
    }

    public static void writeFeaturesToLayer(Features features, String layerKey, WriteOption writeOption) throws Exception {
        Methods.validateFeatures(features);
        Layer layer = Methods.getLayer(layerKey);
        ArrayList<EditTransaction> editTransactions = new ArrayList<EditTransaction>();
        features = Methods.ensureFeaturesAreCompatibleWithLayer(features, layer);
        switch (writeOption) {
            case ADD: {
                EditTransaction transaction = Methods.createTransaction(Collections.emptyList(), layer, true);
                features.stream().map(feature -> FeatureUtil.cloneFeature((SimpleFeature)feature, (boolean)true)).forEach(transaction::createFeature);
                editTransactions.add(transaction);
                break;
            }
            case REPLACE: {
                EditTransaction clearTransaction = Methods.createTransaction(Collections.emptyList(), layer, true);
                EditTransaction addTransaction = Methods.createTransaction(Collections.emptyList(), layer, true);
                List<SimpleFeature> existingFeatures = Methods.retrieveFeaturesFromLayer(layer, (Filter)Filter.INCLUDE);
                existingFeatures.forEach(clearTransaction::deleteFeature);
                features.forEach(addTransaction::createFeature);
                editTransactions.add(clearTransaction);
                editTransactions.add(addTransaction);
                break;
            }
            case UPDATE: {
                List<Filter> fidsFilters = Filters.createPartitionedFiltersForFIDs(Methods.getFidsFromFeatures(features, layer));
                List<SimpleFeature> existingFeatures = Methods.retrieveFeaturesFromLayerByFilters(layer, fidsFilters, Collections.emptySet());
                Set<String> existingFids = Methods.getFidsFromFeatures(existingFeatures, layer);
                List<SimpleFeature> modifiedExistingFeatures = features.stream().filter(feature -> existingFids.contains(Methods.getFidFromFeature(feature, layer))).toList();
                EditTransaction transaction = Methods.createTransaction(modifiedExistingFeatures, layer, false);
                editTransactions.add(transaction);
            }
        }
        EditTransaction.commit(editTransactions);
    }

    private static Features ensureFeaturesAreCompatibleWithLayer(Features features, Layer layer) {
        SimpleFeatureType sourceType = features.getFeatureType();
        SimpleFeatureType targetType = layer.getFeatureType();
        if (layer instanceof RedlineLayer) {
            RedlineLayer redlineLayer = (RedlineLayer)layer;
            return Methods.convertFeaturesToRedlineFeatures(redlineLayer, features);
        }
        if (DataUtilities.compare((SimpleFeatureType)sourceType, (SimpleFeatureType)targetType) != 0) {
            SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(targetType);
            List<SimpleFeature> retypedFeatures = features.stream().map(f -> Methods.retypeFeature(f, simpleFeatureBuilder)).toList();
            return new Features(retypedFeatures);
        }
        return features;
    }

    private static SimpleFeature retypeFeature(SimpleFeature feature, SimpleFeatureBuilder simpleFeatureBuilder) {
        SimpleFeature result = SimpleFeatureBuilder.retype((SimpleFeature)feature, (SimpleFeatureBuilder)simpleFeatureBuilder);
        if (result.getDefaultGeometry() == null && feature.getDefaultGeometry() != null) {
            result.setDefaultGeometry(feature.getDefaultGeometry());
        }
        return result;
    }

    private static Features convertFeaturesToRedlineFeatures(RedlineLayer redlineLayer, Features features) throws IllegalAttributeException {
        ArrayList<SimpleFeature> rlFeatures = new ArrayList<SimpleFeature>();
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(redlineLayer.getDefaultFeatureType());
        for (SimpleFeature f : features) {
            if (f.getDefaultGeometry() == null) continue;
            SimpleFeature rlFeature = simpleFeatureBuilder.buildFeature(f.getID());
            FeatureUtil.copyFeatureData((SimpleFeature)redlineLayer.getDefaultFeature(), (SimpleFeature)rlFeature);
            FeatureUtil.copyFeatureData((SimpleFeature)f, (SimpleFeature)rlFeature);
            rlFeature.setDefaultGeometry(f.getDefaultGeometry());
            rlFeatures.add(rlFeature);
        }
        return new Features(rlFeatures);
    }

    private static Set<String> getFidsFromFeatures(Iterable<SimpleFeature> features, Layer layer) {
        return StreamSupport.stream(features.spliterator(), false).map(feat -> Methods.getFidFromFeature(feat, layer)).collect(Collectors.toSet());
    }

    private static String getFidFromFeature(SimpleFeature feat, Layer layer) {
        try {
            if (layer.getFMD().getDataStore(layer.getDMDCol()) instanceof DirShpDataStore) {
                return feat.getIdentifier().toString();
            }
        }
        catch (IOException e) {
            log.debug(String.format("error retrieving fid for shp-Datastore: %s", e.getMessage()), (Throwable)e);
        }
        return FeatureUtil.getFeatureIDWithoutTable((SimpleFeature)feat);
    }

    public static Features buffer(Features features, double distance) {
        return Methods.buffer(features, distance, EndCapStyle.ROUND, JoinStyle.ROUND);
    }

    public static Features buffer(Features features, double distance, EndCapStyle endCapStyle, JoinStyle joinStyle) {
        Methods.validateFeatures(features);
        BufferParameters bufferParameters = new BufferParameters();
        bufferParameters.setEndCapStyle(endCapStyle.getId());
        bufferParameters.setJoinStyle(joinStyle.getId());
        ArrayList<SimpleFeature> bufferedFeatures = new ArrayList<SimpleFeature>();
        for (SimpleFeature feature : features) {
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (geometry == null) continue;
            SimpleFeature bufferedFeature = FeatureUtil.cloneFeature((SimpleFeature)feature);
            Geometry bufferedGeometry = BufferOp.bufferOp((Geometry)geometry, (double)distance, (BufferParameters)bufferParameters);
            bufferedFeature.setDefaultGeometry((Object)bufferedGeometry);
            bufferedFeatures.add(bufferedFeature);
        }
        return new Features(bufferedFeatures);
    }

    public static Features bufferLines(Features features, double distance) {
        Methods.validateFeatures(features);
        List<SimpleFeature> lineStrings = features.stream().filter(feature -> feature.getDefaultGeometry() instanceof LineString || feature.getDefaultGeometry() instanceof MultiLineString).toList();
        GeometryFactory factory = new GeometryFactory();
        ArrayList<SimpleFeature> bufferedLines = new ArrayList<SimpleFeature>();
        for (SimpleFeature feature2 : lineStrings) {
            SimpleFeature bufferedFeature = FeatureUtil.cloneFeature((SimpleFeature)feature2);
            Geometry geom = (Geometry)bufferedFeature.getDefaultGeometry();
            if (geom == null || geom.isEmpty()) continue;
            if (geom instanceof LineString) {
                LineString line = (LineString)geom;
                Geometry bufferedPolygon = Methods.createHull(factory, line, distance);
                if (bufferedPolygon == null) continue;
                bufferedFeature.setDefaultGeometry((Object)bufferedPolygon);
                bufferedLines.add(bufferedFeature);
                continue;
            }
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                LineString line = (LineString)geom.getGeometryN(i);
                Polygon polygon = (Polygon)Methods.createHull(factory, line, distance);
                if (polygon == null) continue;
                polygons.add(polygon);
            }
            MultiPolygon multiPolygon = factory.createMultiPolygon((Polygon[])polygons.toArray(Polygon[]::new));
            bufferedFeature.setDefaultGeometry((Object)multiPolygon.union());
            bufferedLines.add(bufferedFeature);
        }
        return new Features(bufferedLines);
    }

    private static Geometry createHull(GeometryFactory factory, LineString line, double distance) {
        LineString bufferedLine = (LineString)ConstMoveParallelSupport.moveParallel((Geometry)line, distance, new Coordinate());
        if (!bufferedLine.isSimple()) {
            Methods.log(I18N.getMessage("computed-geometry-intersects-itself", wktWriter.write((Geometry)line)));
            return null;
        }
        LineString reversedLine = bufferedLine.reverse();
        int points = line.getNumPoints();
        if (line.isClosed()) {
            LinearRing ring1 = factory.createLinearRing(line.getCoordinates());
            LinearRing ring2 = factory.createLinearRing(bufferedLine.getCoordinates());
            if (ring1.convexHull().contains((Geometry)ring2)) {
                return factory.createPolygon(ring1, new LinearRing[]{ring2});
            }
            return factory.createPolygon(ring2, new LinearRing[]{ring1});
        }
        Coordinate[] coordinates = new Coordinate[points * 2 + 1];
        System.arraycopy(line.getCoordinates(), 0, coordinates, 0, points);
        System.arraycopy(reversedLine.getCoordinates(), 0, coordinates, points, points);
        coordinates[points * 2] = line.getCoordinateN(0);
        return factory.createPolygon(coordinates);
    }

    public static Features mergeFeaturesByGeometry(Features features, MergeOperation spatialOperation, AttributeConfiguration attributeConfiguration) {
        Methods.validateFeatures(features);
        if (spatialOperation == null) {
            throw new IllegalArgumentException(I18N.getMessage("parameter-must-not-be-null-or-empty", "spatialOperation"));
        }
        if (features.count() == 0) {
            return new Features(new SimpleFeature[0]);
        }
        if (attributeConfiguration == null) {
            attributeConfiguration = AttributeConfiguration.create().allFrom(features).build();
        }
        return spatialMethods.mergeFeaturesByGeometry(features, spatialOperation, attributeConfiguration);
    }

    public static Features mergeFeaturesByGeometry(Features features, MergeOperation spatialOperation) {
        return Methods.mergeFeaturesByGeometry(features, spatialOperation, null);
    }

    public static Features mergeFeaturesByAttribute(Features features, String attributeToGroupBy, AttributeConfiguration attributeConfiguration) {
        Methods.validateFeatures(features);
        Methods.validateNullOrBlankParameter(attributeToGroupBy, "attributeToGroupBy");
        if (features.count() == 0) {
            return new Features(new SimpleFeature[0]);
        }
        String attributeToGroupByWithCase = FeatureTypeUtil.getSchemaAttribute((SimpleFeatureType)features.getFeatureType(), (String)attributeToGroupBy);
        if (attributeToGroupByWithCase == null) {
            throw new IllegalArgumentException(I18N.getMessage("schema-does-not-contain-attribute", attributeToGroupBy));
        }
        if (attributeConfiguration == null) {
            attributeConfiguration = AttributeConfiguration.create().allFrom(features).build();
        }
        return spatialMethods.mergeFeaturesByAttribute(features, attributeToGroupByWithCase, attributeConfiguration);
    }

    public static Features mergeFeaturesByAttribute(Features features, String attributeToGroupBy) {
        return Methods.mergeFeaturesByAttribute(features, attributeToGroupBy, null);
    }

    public static Features intersectFeatureGeometries(Features featuresToIntersectWith, Features featuresToIntersect, IntersectOperation spatialOperation, AttributeConfiguration attributeConfiguration) {
        Methods.validateFeatures(featuresToIntersectWith);
        Methods.validateFeatures(featuresToIntersect);
        if (featuresToIntersectWith.count() == 0 || featuresToIntersect.count() == 0) {
            return new Features(new SimpleFeature[0]);
        }
        if (attributeConfiguration == null) {
            attributeConfiguration = AttributeConfiguration.create().allFrom(featuresToIntersect).allFrom(featuresToIntersectWith).build();
        }
        Methods.validateNullParameter((Object)spatialOperation, "spatialOperation");
        return spatialMethods.intersectFeatureGeometries(featuresToIntersectWith, featuresToIntersect, spatialOperation, attributeConfiguration);
    }

    public static Features intersectFeatureGeometries(Features featuresToIntersectWith, Features featuresToIntersect, IntersectOperation spatialOperation) {
        return Methods.intersectFeatureGeometries(featuresToIntersectWith, featuresToIntersect, spatialOperation, null);
    }

    public static Features filterByArea(Features features, ComparisonOperation operation, double area) {
        return Methods.calculatePropertiesBasedOnType(features, operation, area, ProjectionReduction.getInstance()::calculateRealWorldArea);
    }

    public static Features filterByLength(Features features, ComparisonOperation operation, double length) {
        return Methods.calculatePropertiesBasedOnType(features, operation, length, ProjectionReduction.getInstance()::calculateRealWorldLength);
    }

    private static Features calculatePropertiesBasedOnType(Features features, ComparisonOperation operation, double value, ToDoubleFunction<Geometry> calculation) {
        Methods.validateFeatures(features);
        double delta = 1.0E-8;
        ArrayList<SimpleFeature> resultFeatures = new ArrayList<SimpleFeature>();
        for (SimpleFeature feature : features) {
            boolean result;
            Geometry geom = (Geometry)feature.getDefaultGeometry();
            if (geom == null) continue;
            double geomValue = calculation.applyAsDouble(geom);
            double absoluteValue = Math.abs(value - geomValue);
            if (!(result = (switch (operation) {
                default -> throw new MatchException(null, null);
                case ComparisonOperation.EQUAL -> {
                    if (absoluteValue <= delta) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperation.GREATER -> {
                    if (geomValue > value) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperation.GREATER_OR_EQUAL -> {
                    if (geomValue >= value) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperation.LESS -> {
                    if (geomValue > 0.0 && geomValue < value) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperation.LESS_OR_EQUAL -> geomValue > 0.0 && geomValue <= value;
            }))) continue;
            resultFeatures.add(feature);
        }
        return new Features(resultFeatures);
    }

    public static void selectFeaturesOnLayer(Features features, String layerKey) throws Exception {
        Methods.selectFeaturesOnLayer(features, layerKey, null);
    }

    public static void selectFeaturesOnLayer(Features features, String layerKey, String attributeName) throws Exception {
        List<Object> values;
        Methods.validateFeatures(features);
        Layer layer = Methods.getLayer(layerKey);
        if (features.count() == 0) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            values = features.stream().map(f -> Methods.getFidFromFeature(f, layer)).toList();
        } else {
            if (!FeatureTypeUtil.hasSchemaAttribute((SimpleFeatureType)features.getFeatureType(), (String)attributeName)) {
                throw new IllegalArgumentException(I18N.getMessage("schema-does-not-contain-attribute", attributeName));
            }
            values = features.stream().map(f -> FeatureUtil.getAttribute((SimpleFeature)f, (String)attributeName)).toList();
        }
        String layerKeyAttribute = Methods.getKeyAttribute(layer);
        List<Filter> filters = StringUtils.isBlank((CharSequence)layerKeyAttribute) ? Filters.createPartitionedFiltersForFIDs(values) : Filters.createPartitionedFiltersForAttributeIn(layerKeyAttribute, values);
        Methods.retrieveAndSelectFeatures(layer, filters);
    }

    private static String getKeyAttribute(Layer layer) {
        FeaturestoreMetadata fmd = layer.getFMD();
        if (StringUtils.isNotBlank((CharSequence)fmd.getKeyAttView())) {
            return fmd.getKeyAttView();
        }
        return fmd.getKeyAtt();
    }

    private static void retrieveAndSelectFeatures(Layer layer, List<Filter> filters) throws Exception {
        List<SimpleFeature> foundFeatures = Methods.retrieveFeaturesFromLayerByFilters(layer, filters);
        foundFeatures.removeIf(f -> f.getDefaultGeometry() == null);
        Methods.getSelectionManager().clear();
        Methods.getSelectionManager().getFeatureSelection().selectItems(layer, foundFeatures);
    }

    public static Features clipFeatureGeometries(Features featuresToClipFrom, Features featuresToClip, boolean ignoreFeaturesWithoutGeometry) {
        Methods.validateNullParameter(featuresToClipFrom, "featuresToClipFrom");
        Methods.validateNullParameter(featuresToClip, "featuresToClip");
        return spatialMethods.clipFeatureGeometries(featuresToClipFrom, featuresToClip, ignoreFeaturesWithoutGeometry);
    }

    public static void addAttribute(Features features, String attributeName, AttributeType attributeType) {
        Methods.validateFeatures(features);
        Methods.validateNullOrBlankParameter(attributeName, "attributeName");
        Methods.validateNullParameter((Object)attributeType, "attributeType");
        if (features.count() == 0) {
            return;
        }
        SimpleFeatureTypeBuilder ftBuilder = Methods.retrieveFeatureTypeBuilder(features);
        if (ftBuilder.get(attributeName) != null) {
            throw new IllegalStateException(I18N.getMessage("attribute-is-already-in-schema", attributeName));
        }
        ftBuilder.add(attributeName, attributeType.getBinding());
        Methods.replaceFeatures(ftBuilder, features);
    }

    public static void deleteAttribute(Features features, String attribute) {
        Methods.validateFeatures(features);
        Methods.validateNullParameter(attribute, "attribute");
        if (features.count() == 0) {
            return;
        }
        SimpleFeatureTypeBuilder ftBuilder = Methods.retrieveFeatureTypeBuilder(features);
        ftBuilder.remove(attribute);
        Methods.replaceFeatures(ftBuilder, features);
    }

    private static SimpleFeatureTypeBuilder retrieveFeatureTypeBuilder(Features features) {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        SimpleFeatureType schema = features.getFeatureType();
        ftBuilder.setName(schema.getName());
        ftBuilder.setSuperType((SimpleFeatureType)schema.getSuper());
        ftBuilder.addAll(schema.getAttributeDescriptors());
        return ftBuilder;
    }

    private static void replaceFeatures(SimpleFeatureTypeBuilder ftBuilder, Features features) {
        SimpleFeatureType newSchema = ftBuilder.buildFeatureType();
        ArrayList<SimpleFeature> newFeatures = new ArrayList<SimpleFeature>();
        for (SimpleFeature feature : features) {
            SimpleFeature newFeature = DataUtilities.reType((SimpleFeatureType)newSchema, (SimpleFeature)feature);
            newFeatures.add(newFeature);
        }
        features.replaceAll(newFeatures);
    }

    public static void computeAttribute(Features features, String attributeName, String operation) {
        FeatBshObjectBuilder objBuilder;
        Methods.validateFeatures(features);
        Methods.validateNullOrBlankParameter(attributeName, "attributeName");
        Methods.validateNullOrBlankParameter(operation, "operation");
        if (features.count() == 0) {
            return;
        }
        try {
            objBuilder = FeatBshObjectBuilder.getInstance((String)operation);
            if (Methods.getTask() != null && Methods.getTask().isProjectionReductionActive()) {
                objBuilder.setProjectionReductionActive(Methods.getTask().isProjectionReductionActive());
                objBuilder.setHeightReduction(Methods.getTask().getHeightReduction());
                objBuilder.setCRSDefintion(Methods.getTask().getCRSDefinition());
                objBuilder.setDrawingUnit(Methods.getTask().getDrawingUnit());
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(I18N.getMessage("operation-is-faulty", ex));
        }
        for (SimpleFeature feature : features) {
            Object bshResult;
            try {
                objBuilder.setFeature(feature);
                bshResult = objBuilder.getObject();
            }
            catch (Exception ex) {
                throw new IllegalStateException(I18N.getMessage("operation-could-not-be-executed-for-dataset", feature.getID()), ex);
            }
            feature.setAttribute(attributeName, bshResult);
        }
    }

    public static Features filterFeatures(Features features, String cqlFilter) throws Exception {
        Methods.validateFeatures(features);
        Methods.validateNullOrBlankParameter(cqlFilter, "cqlFilter");
        if (features.count() == 0) {
            return features;
        }
        Filter filter = Methods.parseFilter(cqlFilter, features);
        List<SimpleFeature> matchingFeatures = features.stream().filter(arg_0 -> ((Filter)filter).evaluate(arg_0)).toList();
        return new Features(matchingFeatures);
    }

    public static Features filterFeaturesByIntersection(Features featuresToIntersectWith, Features featuresToIntersect, FilterIntersectOperation spatialOperation) {
        return Methods.filterFeaturesByIntersection(featuresToIntersectWith, featuresToIntersect, spatialOperation, null);
    }

    public static Features filterFeaturesByIntersection(Features featuresToIntersectWith, Features featuresToIntersect, FilterIntersectOperation spatialOperation, AttributeConfiguration attributeConfiguration) {
        Methods.validateFeatures(featuresToIntersectWith);
        Methods.validateFeatures(featuresToIntersect);
        if (featuresToIntersectWith.count() == 0 || featuresToIntersect.count() == 0) {
            return new Features(new SimpleFeature[0]);
        }
        if (attributeConfiguration == null) {
            attributeConfiguration = AttributeConfiguration.create().allFrom(featuresToIntersect).allFrom(featuresToIntersectWith).build();
        }
        Methods.validateNullParameter((Object)spatialOperation, "spatialOperation");
        return spatialMethods.intersectFeatureGeometries(featuresToIntersectWith, featuresToIntersect, spatialOperation, attributeConfiguration);
    }

    private static Layer getLayer(String layerKey) {
        Methods.validateNullOrBlankParameter(layerKey, "layerKey");
        Layer layer = Methods.getLayerManager().getLayerByKey(layerKey);
        if (layer == null) {
            throw new IllegalStateException(I18N.getMessage("error-layer-not-found", layerKey));
        }
        return layer;
    }

    private static boolean validateFeatures(Features features) {
        return Methods.validateNullParameter(features, "features");
    }

    private static boolean validateNullParameter(Object value, String parameterName) {
        if (value == null) {
            throw new IllegalArgumentException(I18N.getMessage("parameter-must-not-be-null-or-empty", parameterName));
        }
        return true;
    }

    private static boolean validateNullOrBlankParameter(String value, String parameterName) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException(I18N.getMessage("parameter-must-not-be-null-or-empty", parameterName));
        }
        return true;
    }

    public static void log(Object thingToLog) {
        logConsumer.accept(Objects.toString(thingToLog));
    }

    private static EditTransaction createTransaction(List<SimpleFeature> sourceFeatures, Layer layer, boolean allowAddingAndRemovingFeatures) {
        return new EditTransaction(sourceFeatures, "GDV", layer, Methods.isRollingBackInvalidEdits(), allowAddingAndRemovingFeatures, Methods.getLayerViewPanel());
    }

    private static List<SimpleFeature> retrieveFeaturesFromLayerByFilters(Layer layer, List<Filter> filters) throws Exception {
        return Methods.retrieveFeaturesFromLayerByFilters(filters, layer::getFeatureIterator);
    }

    private static List<SimpleFeature> retrieveFeaturesFromLayerByFilters(Layer layer, List<Filter> filters, Set<String> attributes) throws Exception {
        return Methods.retrieveFeaturesFromLayerByFilters(filters, (Filter partition) -> layer.getFeatureIterator((Filter)partition, attributes));
    }

    private static List<SimpleFeature> retrieveFeaturesFromLayerByFilters(Collection<Filter> filters, ThrowingFunction<Filter, FeatureIterator<SimpleFeature>, Exception> retriever) throws Exception {
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        for (Filter filter : filters) {
            features.addAll(Methods.collectFeatures(retriever.apply(filter)));
        }
        return features;
    }

    private static List<SimpleFeature> retrieveFeaturesFromLayer(Layer layer, Filter filter) throws Exception {
        return Methods.collectFeatures(layer.getFeatureIterator(filter));
    }

    private static List<SimpleFeature> collectFeatures(FeatureIterator<SimpleFeature> iterator) {
        try (FeatureIterator<SimpleFeature> featureIterator = iterator;){
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            while (iterator.hasNext()) {
                features.add((SimpleFeature)iterator.next());
            }
            ArrayList<SimpleFeature> arrayList = features;
            return arrayList;
        }
    }

    private static Filter parseFilter(String cqlFilter, Layer layer) throws CQLException {
        IncludeFilter filter = Filter.INCLUDE;
        if (StringUtils.isNotBlank((CharSequence)cqlFilter)) {
            filter = ECQL.toFilter((String)cqlFilter);
        }
        return PropertyCaseResolvingVisitor.ignoreCaseOfProperties((Filter)filter, layer.getFMD());
    }

    private static Filter parseFilter(String cqlFilter, Features features) throws CQLException {
        Filter filter = Methods.getCQLFilter(cqlFilter);
        return PropertyCaseResolvingVisitor.ignoreCaseOfPropertiesAndFailOnMissing(filter, features.getFeatureType());
    }

    private static Filter getCQLFilter(String cqlFilter) throws CQLException {
        IncludeFilter filter = Filter.INCLUDE;
        if (StringUtils.isNotBlank((CharSequence)cqlFilter)) {
            filter = ECQL.toFilter((String)cqlFilter);
        }
        return filter;
    }

    private static LayerViewPanel getLayerViewPanel() {
        return workbenchContext.getLayerViewPanel();
    }

    private static LayerManager getLayerManager() {
        return workbenchContext.getLayerManager();
    }

    private static SelectionManager getSelectionManager() {
        return workbenchContext.getSelectionManager();
    }

    private static Task getTask() {
        return Methods.getLayerManager().getTask();
    }

    private static boolean isRollingBackInvalidEdits() {
        return JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }

    private Methods() {
    }

    static {
        wktWriter = new WKTWriter2();
    }
}

