/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl;

import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.geotools.data.DataUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class Features
implements Iterable<SimpleFeature> {
    private List<SimpleFeature> features;

    Features(List<SimpleFeature> features) {
        this.features = features;
    }

    Features(SimpleFeature ... features) {
        this.features = List.of(features);
    }

    public int count() {
        return this.features.size();
    }

    public boolean isEmpty() {
        return this.features == null || this.features.isEmpty();
    }

    public String toString() {
        if (this.features.size() <= 0) {
            return "No features";
        }
        StringWriter buffer = new StringWriter();
        buffer.append("FID,");
        buffer.append(DataUtilities.encodeType((SimpleFeatureType)this.getFeatureType()));
        buffer.append(System.lineSeparator());
        boolean firstLine = true;
        for (SimpleFeature feature : this.features) {
            if (firstLine) {
                firstLine = false;
            } else {
                buffer.append(System.lineSeparator());
            }
            buffer.append(DataUtilities.encodeFeature((SimpleFeature)feature));
        }
        return buffer.toString();
    }

    public SimpleFeatureType getFeatureType() {
        if (this.features.isEmpty()) {
            return null;
        }
        return this.features.get(0).getFeatureType();
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        return this.features.iterator();
    }

    Stream<SimpleFeature> stream() {
        return this.features.stream();
    }

    List<SimpleFeature> toList() {
        return Collections.unmodifiableList(this.features);
    }

    public void replaceAll(List<SimpleFeature> features) {
        this.features = features;
    }
}

