/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl;

import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.Features;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.GroupingFunction;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class AttributeConfiguration {
    private final Map<String, AttributeDefinition> attributes;

    public Map<String, AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    public static Builder create() {
        return new BuilderImpl();
    }

    private AttributeConfiguration(Map<String, AttributeDefinition> attributes) {
        this.attributes = attributes;
    }

    private static class BuilderImpl
    implements BuilderWithAttributeFromAs {
        private final Map<String, AttributeDefinition> attributes = new LinkedHashMap<String, AttributeDefinition>();
        private String currentAttribute;

        @Override
        public BuilderWithAttributeFromAs first(String attribute) {
            return this.appendAttribute(attribute, GroupingFunction.FIRST);
        }

        @Override
        public BuilderWithAttributeFromAs count(String attribute) {
            return this.appendAttribute(attribute, GroupingFunction.COUNT);
        }

        @Override
        public BuilderWithAttributeFromAs avg(String attribute) {
            return this.appendAttribute(attribute, GroupingFunction.AVG);
        }

        @Override
        public BuilderWithAttributeFromAs sum(String attribute) {
            return this.appendAttribute(attribute, GroupingFunction.SUM);
        }

        @Override
        public BuilderWithAttributeFromAs concat(String attribute) {
            return this.appendAttribute(attribute, GroupingFunction.CONCAT);
        }

        @Override
        public Builder allFrom(Features features) {
            for (AttributeDescriptor desc : features.getFeatureType().getAttributeDescriptors()) {
                if (desc instanceof GeometryDescriptor) continue;
                this.appendAttribute(desc.getLocalName(), GroupingFunction.FIRST, features.getFeatureType());
            }
            return this;
        }

        @Override
        public Builder remove(String attribute) {
            this.attributes.remove(attribute);
            return this;
        }

        @Override
        public Builder as(String alias) {
            AttributeDefinition currentDef = this.attributes.remove(this.currentAttribute);
            this.attributes.put(alias, currentDef);
            return this;
        }

        @Override
        public BuilderWithAttributeAs from(Features source) {
            AttributeDefinition currentDef = this.attributes.get(this.currentAttribute);
            this.attributes.put(this.currentAttribute, new AttributeDefinition(currentDef.sourceAttribute(), currentDef.function(), source.getFeatureType()));
            return this;
        }

        @Override
        public AttributeConfiguration build() {
            return new AttributeConfiguration(this.attributes);
        }

        private BuilderWithAttributeFromAs appendAttribute(String attribute, GroupingFunction groupingFunction) {
            return this.appendAttribute(attribute, groupingFunction, null);
        }

        private BuilderWithAttributeFromAs appendAttribute(String attribute, GroupingFunction groupingFunction, SimpleFeatureType sourceFeatureType) {
            this.currentAttribute = attribute;
            this.attributes.put(attribute, new AttributeDefinition(attribute, groupingFunction, sourceFeatureType));
            return this;
        }

        private BuilderImpl() {
        }
    }

    public static interface BuilderWithAttributeFromAs
    extends BuilderWithAttributeAs {
        public BuilderWithAttributeAs from(Features var1);
    }

    public static interface BuilderWithAttributeAs
    extends Builder {
        public Builder as(String var1);
    }

    public static interface Builder {
        public BuilderWithAttributeFromAs first(String var1);

        public BuilderWithAttributeFromAs count(String var1);

        public BuilderWithAttributeFromAs avg(String var1);

        public BuilderWithAttributeFromAs sum(String var1);

        public BuilderWithAttributeFromAs concat(String var1);

        public Builder allFrom(Features var1);

        public Builder remove(String var1);

        public AttributeConfiguration build();
    }

    public record AttributeDefinition(String sourceAttribute, GroupingFunction function, SimpleFeatureType sourceFeatureType) {
    }
}

