/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Task;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.LayerSelectionPanel;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.dsl.WriteOption;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class TargetPanel
extends JPanel {
    public static final int TARGET_GEOPACKAGE = 0;
    public static final int TARGET_SHAPE = 1;
    public static final int TARGET_EXCEL = 2;
    public static final int TARGET_LAYER = 3;
    private boolean blockEvents = false;
    private JComboBox<String> cmbWriteOption;
    private LayerSelectionPanel exportLayerPanel;
    private JPanel jPanel1;
    private JLabel lblTableName;
    private JLabel lblWriteOption;
    private JRadioButton rdoExcel;
    private JRadioButton rdoGeopackage;
    private JRadioButton rdoLayer;
    private JRadioButton rdoShape;
    private JTextField txtTableName;
    private ButtonGroup writeFormat;

    public TargetPanel() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.cmbWriteOption.removeAllItems();
        this.cmbWriteOption.addItem(I18N.get("TargetPanel.writeOption.REPLACE"));
        this.cmbWriteOption.addItem(I18N.get("TargetPanel.writeOption.ADD"));
        this.cmbWriteOption.addItem(I18N.get("TargetPanel.writeOption.UPDATE"));
    }

    private void init() {
        this.blockEvents = true;
        try {
            this.rdoGeopackage.setSelected(true);
            this.exportLayerPanel.displayFilterDefinition(false);
            this.exportLayerPanel.displayOnlyRedlineLayers(true);
            this.exportLayerPanel.displayUseSelection(false);
            this.updateComponents();
        }
        finally {
            this.blockEvents = false;
        }
    }

    public void setTask(Task task) {
        this.exportLayerPanel.setTask(task);
    }

    public void resetTaskByWorkbench() {
        this.exportLayerPanel.resetTaskByWorkbench();
    }

    public String validateInput() {
        if (this.rdoGeopackage.isSelected() && StringUtils.isBlank((String)this.txtTableName.getText())) {
            return I18N.get("TargetPanel.choose-gpkg-tablename");
        }
        if (this.rdoLayer.isSelected() && this.exportLayerPanel.validateInput() != null) {
            return this.exportLayerPanel.validateInput();
        }
        return null;
    }

    private String getWriteOptionText() {
        switch (this.cmbWriteOption.getSelectedIndex()) {
            case 0: {
                return "WriteOption.REPLACE";
            }
            case 1: {
                return "WriteOption.ADD";
            }
            case 2: {
                return "WriteOption.UPDATE";
            }
        }
        throw new AssertionError();
    }

    public String getGdbBeanshell() throws IllegalStateException {
        StringBuilder sbBeanshell = new StringBuilder();
        sbBeanshell.append("//Write processed data\n");
        if (this.rdoGeopackage.isSelected()) {
            sbBeanshell.append(String.format("writeFeaturesToGPKG(features, \"\",\"%s\", %s);", this.txtTableName.getText(), this.getWriteOptionText()));
        } else if (this.rdoShape.isSelected()) {
            sbBeanshell.append(String.format("writeFeaturesToSHP(features, \"\", %s);", this.getWriteOptionText()));
        } else if (this.rdoExcel.isSelected()) {
            sbBeanshell.append(String.format("writeFeaturesToXLSX(features, \"\");", new Object[0]));
        } else if (this.rdoLayer.isSelected()) {
            sbBeanshell.append(String.format("writeFeaturesToLayer(features, \"%s\", %s);", this.exportLayerPanel.getSelectedLayerId(), this.getWriteOptionText()));
        }
        sbBeanshell.append("\n\n");
        return sbBeanshell.toString();
    }

    private void updateComponents() {
        if (this.rdoShape.isSelected()) {
            this.cmbWriteOption.setEditable(true);
            this.cmbWriteOption.setEnabled(true);
        } else if (this.rdoGeopackage.isSelected()) {
            this.cmbWriteOption.setEditable(true);
            this.cmbWriteOption.setEnabled(true);
        } else if (this.rdoExcel.isSelected()) {
            this.cmbWriteOption.setSelectedIndex(0);
            this.cmbWriteOption.setEditable(false);
            this.cmbWriteOption.setEnabled(false);
        } else if (this.rdoLayer.isSelected()) {
            this.cmbWriteOption.setEditable(true);
            this.cmbWriteOption.setEnabled(true);
        }
        if (this.rdoGeopackage.isSelected()) {
            this.txtTableName.setVisible(true);
            this.lblTableName.setVisible(true);
        } else {
            this.txtTableName.setVisible(false);
            this.lblTableName.setVisible(false);
        }
        if (this.rdoLayer.isSelected()) {
            this.exportLayerPanel.setVisible(true);
        } else {
            this.exportLayerPanel.setVisible(false);
        }
    }

    public void selectTarget(int TARGET) {
        switch (TARGET) {
            case 0: {
                this.rdoGeopackage.setSelected(true);
                break;
            }
            case 1: {
                this.rdoShape.setSelected(true);
                break;
            }
            case 2: {
                this.rdoExcel.setSelected(true);
                break;
            }
            case 3: {
                this.rdoLayer.setSelected(true);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void setWriteOption(WriteOption writeOption) {
        switch (writeOption) {
            case REPLACE: {
                this.cmbWriteOption.setSelectedIndex(0);
                break;
            }
            case ADD: {
                this.cmbWriteOption.setSelectedIndex(1);
                break;
            }
            case UPDATE: {
                this.cmbWriteOption.setSelectedIndex(2);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void setTableName(String tableName) {
        this.txtTableName.setText(tableName);
    }

    private void initComponents() {
        this.writeFormat = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.rdoGeopackage = new JRadioButton();
        this.rdoShape = new JRadioButton();
        this.rdoExcel = new JRadioButton();
        this.rdoLayer = new JRadioButton();
        this.cmbWriteOption = new JComboBox();
        this.lblWriteOption = new JLabel();
        this.lblTableName = new JLabel();
        this.txtTableName = new JTextField();
        this.exportLayerPanel = new LayerSelectionPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.writeFormat.add(this.rdoGeopackage);
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.rdoGeopackage.setText(bundle.getString("TargetPanel.rdoGeopackage.text"));
        this.rdoGeopackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetPanel.this.rdoGeopackageActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.rdoGeopackage, gridBagConstraints);
        this.writeFormat.add(this.rdoShape);
        this.rdoShape.setText(bundle.getString("TargetPanel.rdoShape.text"));
        this.rdoShape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetPanel.this.rdoShapeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.rdoShape, gridBagConstraints);
        this.writeFormat.add(this.rdoExcel);
        this.rdoExcel.setText(bundle.getString("TargetPanel.rdoExcel.text"));
        this.rdoExcel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetPanel.this.rdoExcelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.rdoExcel, gridBagConstraints);
        this.writeFormat.add(this.rdoLayer);
        this.rdoLayer.setText(bundle.getString("TargetPanel.rdoLayer.text"));
        this.rdoLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetPanel.this.rdoLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.rdoLayer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.cmbWriteOption.setModel(new DefaultComboBoxModel<String>(new String[]{"ersetzen", "anh\u00e4ngen", "\u00e4ndern"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.cmbWriteOption, gridBagConstraints);
        this.lblWriteOption.setText(bundle.getString("TargetPanel.lblWriteOption.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblWriteOption, gridBagConstraints);
        this.lblTableName.setText(bundle.getString("TargetPanel.lblTableName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblTableName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtTableName, gridBagConstraints);
        this.exportLayerPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("TargetPanel.exportLayerPanel.border.title")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.exportLayerPanel, gridBagConstraints);
    }

    private void rdoShapeActionPerformed(ActionEvent evt) {
        if (!this.blockEvents) {
            this.updateComponents();
        }
    }

    private void rdoGeopackageActionPerformed(ActionEvent evt) {
        if (!this.blockEvents) {
            this.updateComponents();
        }
    }

    private void rdoExcelActionPerformed(ActionEvent evt) {
        if (!this.blockEvents) {
            this.updateComponents();
        }
    }

    private void rdoLayerActionPerformed(ActionEvent evt) {
        if (!this.blockEvents) {
            this.updateComponents();
        }
    }
}

