/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.workbench.ui.plugin.dataprocessing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.ExecuteGeoDataProcessingPanel;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.GdpDialog;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.LayerSelectionPanel;
import de.riwagis.riwajump.workbench.ui.plugin.dataprocessing.TargetPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.commons.lang.StringUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class MergeDialog
extends JDialog
implements GdpDialog {
    private final PlugInContext context;
    private JPanel bufferMerge;
    private ButtonGroup buttonGroupMergeType;
    private JComboBox<String> cmbAttribute;
    private JComboBox<String> cmbIntersectionType;
    private ExecuteGeoDataProcessingPanel executeGeoDataProcessingPanel;
    private JLabel lblAttribute;
    private JLabel lblIntersectionType;
    private JPanel pnlMergeType;
    private JRadioButton rdoAttribute;
    private JRadioButton rdoGeometry;
    private LayerSelectionPanel sourcePanel;
    private TargetPanel targetPanel;
    private TargetPanel targetPanel1;

    public MergeDialog(PlugInContext context) {
        super((Frame)context.getWorkbenchFrame(), false);
        this.context = context;
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.cmbIntersectionType.removeAllItems();
        this.cmbIntersectionType.addItem(I18N.get("MergeDialog.cmbIntersectionType.intersection"));
        this.cmbIntersectionType.addItem(I18N.get("MergeDialog.cmbIntersectionType.intersection-and-touch"));
        this.cmbIntersectionType.addItem(I18N.get("MergeDialog.cmbIntersectionType.contains"));
        this.cmbIntersectionType.addItem(I18N.get("MergeDialog.cmbIntersectionType.contains-and-touch"));
        this.cmbIntersectionType.addItem(I18N.get("MergeDialog.cmbIntersectionType.touch"));
    }

    private void init() {
        this.sourcePanel.resetTaskByWorkbench();
        this.executeGeoDataProcessingPanel.setGdpDialog(this);
        this.sourcePanel.addActionListener(e -> this.refillLayerAttributes());
        this.rdoGeometry.setSelected(true);
        this.cmbIntersectionType.setSelectedIndex(1);
        this.updateComponents();
    }

    private void updateComponents() {
        if (this.rdoAttribute.isSelected()) {
            this.lblAttribute.setVisible(true);
            this.cmbAttribute.setVisible(true);
            this.lblIntersectionType.setVisible(false);
            this.cmbIntersectionType.setVisible(false);
        }
        if (this.rdoGeometry.isSelected()) {
            this.lblAttribute.setVisible(false);
            this.cmbAttribute.setVisible(false);
            this.lblIntersectionType.setVisible(true);
            this.cmbIntersectionType.setVisible(true);
        }
    }

    private void initComponents() {
        this.targetPanel1 = new TargetPanel();
        this.buttonGroupMergeType = new ButtonGroup();
        this.sourcePanel = new LayerSelectionPanel();
        this.bufferMerge = new JPanel();
        this.lblAttribute = new JLabel();
        this.cmbAttribute = new JComboBox();
        this.pnlMergeType = new JPanel();
        this.rdoGeometry = new JRadioButton();
        this.rdoAttribute = new JRadioButton();
        this.lblIntersectionType = new JLabel();
        this.cmbIntersectionType = new JComboBox();
        this.targetPanel = new TargetPanel();
        this.executeGeoDataProcessingPanel = new ExecuteGeoDataProcessingPanel();
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.setTitle(bundle.getString("MergeDialog.title"));
        this.setMinimumSize(new Dimension(460, 550));
        this.setPreferredSize(new Dimension(460, 550));
        this.setSize(new Dimension(460, 550));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                MergeDialog.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("MergeDialog.sourcePanel.border.title")));
        this.sourcePanel.setMinimumSize(new Dimension(83, 180));
        this.sourcePanel.setName("sourcePanel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.sourcePanel, gridBagConstraints);
        this.bufferMerge.setBorder(BorderFactory.createTitledBorder(bundle.getString("MergeDialog.bufferMerge.border.title")));
        this.bufferMerge.setLayout(new GridBagLayout());
        this.lblAttribute.setText(bundle.getString("MergeDialog.lblAttribute.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bufferMerge.add((Component)this.lblAttribute, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bufferMerge.add(this.cmbAttribute, gridBagConstraints);
        this.pnlMergeType.setLayout(new GridBagLayout());
        this.buttonGroupMergeType.add(this.rdoGeometry);
        this.rdoGeometry.setText(bundle.getString("MergeDialog.rdoGeometry.text"));
        this.rdoGeometry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.rdoGeometryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlMergeType.add((Component)this.rdoGeometry, gridBagConstraints);
        this.buttonGroupMergeType.add(this.rdoAttribute);
        this.rdoAttribute.setText(bundle.getString("MergeDialog.rdoAttribute.text"));
        this.rdoAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.rdoAttributeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlMergeType.add((Component)this.rdoAttribute, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.bufferMerge.add((Component)this.pnlMergeType, gridBagConstraints);
        this.lblIntersectionType.setText(bundle.getString("MergeDialog.lblIntersectionType.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bufferMerge.add((Component)this.lblIntersectionType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bufferMerge.add(this.cmbIntersectionType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.bufferMerge, gridBagConstraints);
        this.targetPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("MergeDialog.targetPanel.border.title")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.targetPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.executeGeoDataProcessingPanel, gridBagConstraints);
        this.pack();
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.sourcePanel.resetTaskByWorkbench();
        this.targetPanel.resetTaskByWorkbench();
    }

    private void rdoGeometryActionPerformed(ActionEvent evt) {
        this.updateComponents();
    }

    private void rdoAttributeActionPerformed(ActionEvent evt) {
        this.updateComponents();
    }

    @Override
    public String getGdpBeanshell() {
        StringBuilder sbBeanshell = new StringBuilder();
        sbBeanshell.append(this.sourcePanel.getGdbBeanshell());
        sbBeanshell.append("//Merge features\n");
        if (this.rdoGeometry.isSelected()) {
            sbBeanshell.append(String.format("features = mergeFeaturesByGeometry(features, %s);", this.getIntersectionTypeText()));
        }
        if (this.rdoAttribute.isSelected()) {
            sbBeanshell.append(String.format("features = mergeFeaturesByAttribute(features, \"%s\");", this.getAttributeText()));
        }
        sbBeanshell.append("\n\n");
        sbBeanshell.append(this.targetPanel.getGdbBeanshell());
        return sbBeanshell.toString();
    }

    @Override
    public void closeDialog() {
        this.setVisible(false);
    }

    @Override
    public String validateInput() {
        StringBuilder sbErrors = new StringBuilder();
        if (this.sourcePanel.validateInput() != null) {
            sbErrors.append(this.sourcePanel.validateInput()).append("\n");
        }
        if (this.targetPanel.validateInput() != null) {
            sbErrors.append(this.targetPanel.validateInput()).append("\n");
        }
        if (sbErrors.isEmpty()) {
            return null;
        }
        return sbErrors.toString();
    }

    @Override
    public String getOperationName() {
        return "Merge";
    }

    @Override
    public PlugInContext getPlugInContext() {
        return this.context;
    }

    private void refillLayerAttributes() {
        String lastSelection = (String)this.cmbAttribute.getSelectedItem();
        this.cmbAttribute.removeAllItems();
        if (this.sourcePanel.getSelectedLayer() != null) {
            Layer layer = this.sourcePanel.getSelectedLayer();
            SimpleFeatureType lyFeatureType = layer.getFeatureType();
            List lyAtts = lyFeatureType.getAttributeDescriptors();
            List lyAttNames = lyAtts.stream().filter(attdesc -> !(attdesc instanceof GeometryDescriptor)).map(attdesc -> attdesc.getLocalName()).collect(Collectors.toList());
            Collections.sort(lyAttNames);
            for (String attName : lyAttNames) {
                this.cmbAttribute.addItem(attName);
            }
            if (StringUtils.isNotBlank((String)lastSelection)) {
                this.cmbAttribute.setSelectedItem(lastSelection);
            }
        }
    }

    private String getIntersectionTypeText() {
        switch (this.cmbIntersectionType.getSelectedIndex()) {
            case 0: {
                return "MergeOperation.ON_INTERSECTION";
            }
            case 1: {
                return "MergeOperation.ON_INTERSECTION_OR_TOUCH";
            }
            case 2: {
                return "MergeOperation.ON_CONTAIN";
            }
            case 3: {
                return "MergeOperation.ON_CONTAIN_OR_TOUCH";
            }
            case 4: {
                return "MergeOperation.ON_TOUCH";
            }
        }
        throw new IllegalStateException("Should never reach here. Invalid intersection type.");
    }

    private String getAttributeText() {
        if (this.cmbAttribute.getSelectedItem() != null) {
            return (String)this.cmbAttribute.getSelectedItem();
        }
        throw new IllegalStateException("Should never reach here. No attributes in attribute list found.");
    }
}

